/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImpersonatorInterceptor
implements Interceptor {
    public static final String NAME = "IMPERSONATOR";
    private final Config config;

    public ImpersonatorInterceptor(Config config) {
        this.config = config;
    }

    @Override
    public void before(BasicBuilder builder, HttpHeaders headers) {
        RequestConfig requestConfig = this.config.getRequestConfig();
        if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateUsername())) {
            Map<String, List<String>> impersonateExtras;
            builder.header("Impersonate-User", requestConfig.getImpersonateUsername());
            String[] impersonateGroups = requestConfig.getImpersonateGroups();
            if (Utils.isNotNullOrEmpty(impersonateGroups)) {
                for (String string : impersonateGroups) {
                    builder.header("Impersonate-Group", string);
                }
            }
            if (Utils.isNotNullOrEmpty(impersonateExtras = requestConfig.getImpersonateExtras())) {
                Set<String> keys = impersonateExtras.keySet();
                for (Object e : keys) {
                    List<String> values = impersonateExtras.get(e);
                    if (values == null) continue;
                    for (String value : values) {
                        builder.header("Impersonate-Extra-" + e, value);
                    }
                }
            }
        }
    }
}

