/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.plugin.h2.monitor;

import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMonitor;

public class H2Monitor
implements DatabaseMonitor {
    private final DataSource dataSource;

    public H2Monitor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DatabaseMetrics getDatabaseMetrics() {
        DatabaseMetrics monitorRecord = new DatabaseMetrics();
        monitorRecord.setDate(new Date());
        monitorRecord.setDbType(DbType.H2);
        monitorRecord.setState(DatabaseMetrics.DatabaseHealthStatus.YES);
        try (Connection connection = this.dataSource.getConnection();
             Statement pstmt = connection.createStatement();
             ResultSet rs1 = pstmt.executeQuery("select count(1) as total from information_schema.sessions;");){
            if (rs1.next()) {
                int currentSessions = rs1.getInt("total");
                monitorRecord.setThreadsConnections((long)currentSessions);
                monitorRecord.setMaxUsedConnections((long)currentSessions);
            }
        }
        return monitorRecord;
    }
}

