/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectPreferenceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROJECT_PREFERENCE_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/project-preference"})
public class ProjectPreferenceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectPreferenceController.class);
    @Autowired
    private ProjectPreferenceService projectPreferenceService;

    @Operation(summary="updateProjectPreference", description="UPDATE_PROJECT_PREFERENCE_NOTES")
    @Parameters(value={@Parameter(name="projectPreferences", description="PROJECT_PREFERENCES", schema=@Schema(implementation=String.class))})
    @PutMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_PROJECT_PREFERENCE_ERROR)
    public Result updateProjectPreference(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="projectPreferences", required=true) String projectPreferences) {
        return this.projectPreferenceService.updateProjectPreference(loginUser, projectCode, projectPreferences);
    }

    @Operation(summary="queryProjectPreferenceByProjectCode", description="QUERY_PROJECT_PREFERENCE_NOTES")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_PREFERENCE_ERROR)
    public Result queryProjectPreferenceByProjectCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        return this.projectPreferenceService.queryProjectPreferenceByProjectCode(loginUser, projectCode);
    }

    @Operation(summary="enableProjectPreference", description="UPDATE_PROJECT_PREFERENCE_STATE_NOTES")
    @Parameters(value={@Parameter(name="state", description="PROJECT_PREFERENCES_STATE", schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROJECT_PREFERENCE_STATE_ERROR)
    public Result enableProjectPreference(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="state", required=true) int state) {
        return this.projectPreferenceService.enableProjectPreference(loginUser, projectCode, state);
    }
}

