/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(value="api")
public class ApiConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiConfig.class);
    private String baseUrl;
    private String uiUrl;
    private boolean auditEnable = false;
    private TrafficConfiguration trafficControl = new TrafficConfiguration();
    private PythonGatewayConfiguration pythonGateway = new PythonGatewayConfiguration();

    public boolean supports(Class<?> clazz) {
        return ApiConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        this.validatePythonGateway(errors);
        this.printConfig();
    }

    private void validatePythonGateway(Errors errors) {
        if (this.pythonGateway.isEnabled() && StringUtils.isEmpty((CharSequence)this.pythonGateway.getAuthToken())) {
            errors.rejectValue("pythonGateway.auth-token", null, "should not be empty when enabled is true");
        }
    }

    private void printConfig() {
        log.info("API config: baseUrl -> {} ", (Object)this.baseUrl);
        log.info("API config: uiUrl -> {} ", (Object)this.uiUrl);
        log.info("API config: auditEnable -> {} ", (Object)this.auditEnable);
        log.info("API config: trafficControl -> {} ", (Object)this.trafficControl);
        log.info("API config: pythonGateway -> {} ", (Object)this.pythonGateway);
    }

    @Generated
    public ApiConfig() {
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getUiUrl() {
        return this.uiUrl;
    }

    @Generated
    public boolean isAuditEnable() {
        return this.auditEnable;
    }

    @Generated
    public TrafficConfiguration getTrafficControl() {
        return this.trafficControl;
    }

    @Generated
    public PythonGatewayConfiguration getPythonGateway() {
        return this.pythonGateway;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setUiUrl(String uiUrl) {
        this.uiUrl = uiUrl;
    }

    @Generated
    public void setAuditEnable(boolean auditEnable) {
        this.auditEnable = auditEnable;
    }

    @Generated
    public void setTrafficControl(TrafficConfiguration trafficControl) {
        this.trafficControl = trafficControl;
    }

    @Generated
    public void setPythonGateway(PythonGatewayConfiguration pythonGateway) {
        this.pythonGateway = pythonGateway;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiConfig)) {
            return false;
        }
        ApiConfig other = (ApiConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuditEnable() != other.isAuditEnable()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$uiUrl = this.getUiUrl();
        String other$uiUrl = other.getUiUrl();
        if (this$uiUrl == null ? other$uiUrl != null : !this$uiUrl.equals(other$uiUrl)) {
            return false;
        }
        TrafficConfiguration this$trafficControl = this.getTrafficControl();
        TrafficConfiguration other$trafficControl = other.getTrafficControl();
        if (this$trafficControl == null ? other$trafficControl != null : !((Object)this$trafficControl).equals(other$trafficControl)) {
            return false;
        }
        PythonGatewayConfiguration this$pythonGateway = this.getPythonGateway();
        PythonGatewayConfiguration other$pythonGateway = other.getPythonGateway();
        return !(this$pythonGateway == null ? other$pythonGateway != null : !((Object)this$pythonGateway).equals(other$pythonGateway));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuditEnable() ? 79 : 97);
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $uiUrl = this.getUiUrl();
        result = result * 59 + ($uiUrl == null ? 43 : $uiUrl.hashCode());
        TrafficConfiguration $trafficControl = this.getTrafficControl();
        result = result * 59 + ($trafficControl == null ? 43 : ((Object)$trafficControl).hashCode());
        PythonGatewayConfiguration $pythonGateway = this.getPythonGateway();
        result = result * 59 + ($pythonGateway == null ? 43 : ((Object)$pythonGateway).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiConfig(baseUrl=" + this.getBaseUrl() + ", uiUrl=" + this.getUiUrl() + ", auditEnable=" + this.isAuditEnable() + ", trafficControl=" + this.getTrafficControl() + ", pythonGateway=" + this.getPythonGateway() + ")";
    }

    public static class PythonGatewayConfiguration {
        private boolean enabled = false;
        private String gatewayServerAddress = "0.0.0.0";
        private int gatewayServerPort = 25333;
        private String pythonAddress = "127.0.0.1";
        private int pythonPort = 25334;
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private String authToken = "jwUDzpLsNKEFER4*a8gruBH_GsAurNxU7A@Xc";

        @Generated
        public String toString() {
            return "ApiConfig.PythonGatewayConfiguration(enabled=" + this.isEnabled() + ", gatewayServerAddress=" + this.getGatewayServerAddress() + ", gatewayServerPort=" + this.getGatewayServerPort() + ", pythonAddress=" + this.getPythonAddress() + ", pythonPort=" + this.getPythonPort() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getGatewayServerAddress() {
            return this.gatewayServerAddress;
        }

        @Generated
        public int getGatewayServerPort() {
            return this.gatewayServerPort;
        }

        @Generated
        public String getPythonAddress() {
            return this.pythonAddress;
        }

        @Generated
        public int getPythonPort() {
            return this.pythonPort;
        }

        @Generated
        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        @Generated
        public int getReadTimeout() {
            return this.readTimeout;
        }

        @Generated
        public String getAuthToken() {
            return this.authToken;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setGatewayServerAddress(String gatewayServerAddress) {
            this.gatewayServerAddress = gatewayServerAddress;
        }

        @Generated
        public void setGatewayServerPort(int gatewayServerPort) {
            this.gatewayServerPort = gatewayServerPort;
        }

        @Generated
        public void setPythonAddress(String pythonAddress) {
            this.pythonAddress = pythonAddress;
        }

        @Generated
        public void setPythonPort(int pythonPort) {
            this.pythonPort = pythonPort;
        }

        @Generated
        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        @Generated
        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        @Generated
        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PythonGatewayConfiguration)) {
                return false;
            }
            PythonGatewayConfiguration other = (PythonGatewayConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getGatewayServerPort() != other.getGatewayServerPort()) {
                return false;
            }
            if (this.getPythonPort() != other.getPythonPort()) {
                return false;
            }
            if (this.getConnectTimeout() != other.getConnectTimeout()) {
                return false;
            }
            if (this.getReadTimeout() != other.getReadTimeout()) {
                return false;
            }
            String this$gatewayServerAddress = this.getGatewayServerAddress();
            String other$gatewayServerAddress = other.getGatewayServerAddress();
            if (this$gatewayServerAddress == null ? other$gatewayServerAddress != null : !this$gatewayServerAddress.equals(other$gatewayServerAddress)) {
                return false;
            }
            String this$pythonAddress = this.getPythonAddress();
            String other$pythonAddress = other.getPythonAddress();
            if (this$pythonAddress == null ? other$pythonAddress != null : !this$pythonAddress.equals(other$pythonAddress)) {
                return false;
            }
            String this$authToken = this.getAuthToken();
            String other$authToken = other.getAuthToken();
            return !(this$authToken == null ? other$authToken != null : !this$authToken.equals(other$authToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PythonGatewayConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getGatewayServerPort();
            result = result * 59 + this.getPythonPort();
            result = result * 59 + this.getConnectTimeout();
            result = result * 59 + this.getReadTimeout();
            String $gatewayServerAddress = this.getGatewayServerAddress();
            result = result * 59 + ($gatewayServerAddress == null ? 43 : $gatewayServerAddress.hashCode());
            String $pythonAddress = this.getPythonAddress();
            result = result * 59 + ($pythonAddress == null ? 43 : $pythonAddress.hashCode());
            String $authToken = this.getAuthToken();
            result = result * 59 + ($authToken == null ? 43 : $authToken.hashCode());
            return result;
        }

        @Generated
        public PythonGatewayConfiguration() {
        }

        @Generated
        public PythonGatewayConfiguration(boolean enabled, String gatewayServerAddress, int gatewayServerPort, String pythonAddress, int pythonPort, int connectTimeout, int readTimeout, String authToken) {
            this.enabled = enabled;
            this.gatewayServerAddress = gatewayServerAddress;
            this.gatewayServerPort = gatewayServerPort;
            this.pythonAddress = pythonAddress;
            this.pythonPort = pythonPort;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.authToken = authToken;
        }
    }

    public static class TrafficConfiguration {
        private boolean globalSwitch = false;
        private Integer maxGlobalQpsRate = 300;
        private boolean tenantSwitch = false;
        private Integer defaultTenantQpsRate = 10;
        private Map<String, Integer> customizeTenantQpsRate = new HashMap<String, Integer>();

        @Generated
        public boolean isGlobalSwitch() {
            return this.globalSwitch;
        }

        @Generated
        public Integer getMaxGlobalQpsRate() {
            return this.maxGlobalQpsRate;
        }

        @Generated
        public boolean isTenantSwitch() {
            return this.tenantSwitch;
        }

        @Generated
        public Integer getDefaultTenantQpsRate() {
            return this.defaultTenantQpsRate;
        }

        @Generated
        public Map<String, Integer> getCustomizeTenantQpsRate() {
            return this.customizeTenantQpsRate;
        }

        @Generated
        public void setGlobalSwitch(boolean globalSwitch) {
            this.globalSwitch = globalSwitch;
        }

        @Generated
        public void setMaxGlobalQpsRate(Integer maxGlobalQpsRate) {
            this.maxGlobalQpsRate = maxGlobalQpsRate;
        }

        @Generated
        public void setTenantSwitch(boolean tenantSwitch) {
            this.tenantSwitch = tenantSwitch;
        }

        @Generated
        public void setDefaultTenantQpsRate(Integer defaultTenantQpsRate) {
            this.defaultTenantQpsRate = defaultTenantQpsRate;
        }

        @Generated
        public void setCustomizeTenantQpsRate(Map<String, Integer> customizeTenantQpsRate) {
            this.customizeTenantQpsRate = customizeTenantQpsRate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrafficConfiguration)) {
                return false;
            }
            TrafficConfiguration other = (TrafficConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGlobalSwitch() != other.isGlobalSwitch()) {
                return false;
            }
            if (this.isTenantSwitch() != other.isTenantSwitch()) {
                return false;
            }
            Integer this$maxGlobalQpsRate = this.getMaxGlobalQpsRate();
            Integer other$maxGlobalQpsRate = other.getMaxGlobalQpsRate();
            if (this$maxGlobalQpsRate == null ? other$maxGlobalQpsRate != null : !((Object)this$maxGlobalQpsRate).equals(other$maxGlobalQpsRate)) {
                return false;
            }
            Integer this$defaultTenantQpsRate = this.getDefaultTenantQpsRate();
            Integer other$defaultTenantQpsRate = other.getDefaultTenantQpsRate();
            if (this$defaultTenantQpsRate == null ? other$defaultTenantQpsRate != null : !((Object)this$defaultTenantQpsRate).equals(other$defaultTenantQpsRate)) {
                return false;
            }
            Map<String, Integer> this$customizeTenantQpsRate = this.getCustomizeTenantQpsRate();
            Map<String, Integer> other$customizeTenantQpsRate = other.getCustomizeTenantQpsRate();
            return !(this$customizeTenantQpsRate == null ? other$customizeTenantQpsRate != null : !((Object)this$customizeTenantQpsRate).equals(other$customizeTenantQpsRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TrafficConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGlobalSwitch() ? 79 : 97);
            result = result * 59 + (this.isTenantSwitch() ? 79 : 97);
            Integer $maxGlobalQpsRate = this.getMaxGlobalQpsRate();
            result = result * 59 + ($maxGlobalQpsRate == null ? 43 : ((Object)$maxGlobalQpsRate).hashCode());
            Integer $defaultTenantQpsRate = this.getDefaultTenantQpsRate();
            result = result * 59 + ($defaultTenantQpsRate == null ? 43 : ((Object)$defaultTenantQpsRate).hashCode());
            Map<String, Integer> $customizeTenantQpsRate = this.getCustomizeTenantQpsRate();
            result = result * 59 + ($customizeTenantQpsRate == null ? 43 : ((Object)$customizeTenantQpsRate).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApiConfig.TrafficConfiguration(globalSwitch=" + this.isGlobalSwitch() + ", maxGlobalQpsRate=" + this.getMaxGlobalQpsRate() + ", tenantSwitch=" + this.isTenantSwitch() + ", defaultTenantQpsRate=" + this.getDefaultTenantQpsRate() + ", customizeTenantQpsRate=" + this.getCustomizeTenantQpsRate() + ")";
        }

        @Generated
        public TrafficConfiguration() {
        }

        @Generated
        public TrafficConfiguration(boolean globalSwitch, Integer maxGlobalQpsRate, boolean tenantSwitch, Integer defaultTenantQpsRate, Map<String, Integer> customizeTenantQpsRate) {
            this.globalSwitch = globalSwitch;
            this.maxGlobalQpsRate = maxGlobalQpsRate;
            this.tenantSwitch = tenantSwitch;
            this.defaultTenantQpsRate = defaultTenantQpsRate;
            this.customizeTenantQpsRate = customizeTenantQpsRate;
        }
    }
}

