/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ServiceAccountTokenProjection represents a projected service account token volume. This projection can be used to insert a service account token into the pods runtime filesystem for use against APIs (Kubernetes API Server or otherwise).")
public class V1ServiceAccountTokenProjection {
    public static final String SERIALIZED_NAME_AUDIENCE = "audience";
    @SerializedName(value="audience")
    private String audience;
    public static final String SERIALIZED_NAME_EXPIRATION_SECONDS = "expirationSeconds";
    @SerializedName(value="expirationSeconds")
    private Long expirationSeconds;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;

    public V1ServiceAccountTokenProjection audience(String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.")
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public V1ServiceAccountTokenProjection expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.")
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public V1ServiceAccountTokenProjection path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path is the path relative to the mount point of the file to project the token into.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceAccountTokenProjection v1ServiceAccountTokenProjection = (V1ServiceAccountTokenProjection)o;
        return Objects.equals(this.audience, v1ServiceAccountTokenProjection.audience) && Objects.equals(this.expirationSeconds, v1ServiceAccountTokenProjection.expirationSeconds) && Objects.equals(this.path, v1ServiceAccountTokenProjection.path);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.expirationSeconds, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceAccountTokenProjection {\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

