/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.sql.whereclausebuilder.NoReplacementsPreparedStatementPart;
import org.apache.torque.sql.whereclausebuilder.OnlyReplacementsPreparedStatementPart;

public class CombinedPreparedStatementPart
implements PreparedStatementPart {
    private final List<PreparedStatementPart> parts = new ArrayList<PreparedStatementPart>();

    public CombinedPreparedStatementPart() {
    }

    public CombinedPreparedStatementPart(PreparedStatementPart toAdd) {
        this.append(toAdd);
    }

    public void append(PreparedStatementPart toAdd) {
        if (toAdd == null) {
            throw new NullPointerException("toAdd must not be null");
        }
        this.parts.add(toAdd);
    }

    public void appendSql(String sql) {
        this.parts.add(new NoReplacementsPreparedStatementPart(sql));
    }

    public void addPreparedStatementReplacement(Object toAdd) {
        this.parts.add(new OnlyReplacementsPreparedStatementPart(toAdd));
    }

    @Override
    public String getSqlAsString() {
        StringBuilder result = new StringBuilder();
        this.parts.forEach(part -> result.append(part.getSqlAsString()));
        return result.toString();
    }

    @Override
    public List<Object> getPreparedStatementReplacements() {
        ArrayList result = new ArrayList();
        this.parts.forEach(part -> result.addAll(part.getPreparedStatementReplacements()));
        return Collections.unmodifiableList(result);
    }
}

