/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.infoset.InfosetComplexElement;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.api.infoset.InfosetSimpleElement;
import org.apache.daffodil.api.infoset.XMLTextEscapeStyle;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Indentable;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$String$;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.XMLTextInfoset$;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter$;
import org.codehaus.stax2.XMLStreamWriter2;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.NamespaceBinding;
import scala.xml.TopScope$;
import scala.xml.Utility$;

public class XMLTextInfosetOutputter
extends InfosetOutputter
implements Indentable {
    private int indentSize;
    private char indentChar;
    private String org$apache$daffodil$lib$util$Indentable$$indentString;
    private int org$apache$daffodil$lib$util$Indentable$$indentLength;
    private final BufferedWriter writer;
    private final boolean pretty;
    private final XMLTextEscapeStyle xmlTextEscapeStyle;
    private final boolean minimal;
    private final StringBuilder sb;
    private boolean inScopeComplexElementHasChildren;

    public static XMLTextEscapeStyle $lessinit$greater$default$3() {
        return XMLTextInfosetOutputter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return XMLTextInfosetOutputter$.MODULE$.$lessinit$greater$default$4();
    }

    private XMLTextInfosetOutputter(BufferedWriter writer, boolean pretty, XMLTextEscapeStyle xmlTextEscapeStyle, boolean minimal) {
        this.writer = writer;
        this.pretty = pretty;
        this.xmlTextEscapeStyle = xmlTextEscapeStyle;
        this.minimal = minimal;
        Indentable.$init$(this);
        this.sb = new StringBuilder();
        this.inScopeComplexElementHasChildren = false;
        Statics.releaseFence();
    }

    @Override
    public int indentSize() {
        return this.indentSize;
    }

    @Override
    public char indentChar() {
        return this.indentChar;
    }

    @Override
    public String org$apache$daffodil$lib$util$Indentable$$indentString() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentString;
    }

    @Override
    public int org$apache$daffodil$lib$util$Indentable$$indentLength() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentLength;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentString_$eq(String x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentString = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentLength_$eq(int x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentLength = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentSize_$eq(int x$0) {
        this.indentSize = x$0;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentChar_$eq(char x$0) {
        this.indentChar = x$0;
    }

    public XMLTextInfosetOutputter(OutputStream os, boolean pretty, XMLTextEscapeStyle xmlTextEscapeStyle, boolean minimal) {
        this(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)), pretty, xmlTextEscapeStyle, minimal);
    }

    @Override
    public void reset() {
        this.resetIndentation();
        this.inScopeComplexElementHasChildren = false;
    }

    private void outputTagName(DIElement elem) {
        String prefix = elem.erd().prefix();
        if (prefix != null) {
            String string = prefix;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.writer.write(prefix);
                this.writer.write(":");
            }
        }
        this.writer.write(elem.erd().name());
    }

    private void outputStartTag(DIElement elem) {
        this.writer.write("<");
        this.outputTagName(elem);
        if (!this.minimal) {
            NamespaceBinding nsbStart = elem.erd().minimizedScope();
            TopScope$ nsbEnd = elem.isRoot() ? TopScope$.MODULE$ : elem.diParent().erd().minimizedScope();
            NamespaceBinding namespaceBinding = nsbStart;
            TopScope$ topScope$ = nsbEnd;
            if (namespaceBinding == null ? topScope$ != null : !namespaceBinding.equals(topScope$)) {
                this.sb.setLength(0);
                nsbStart.buildString(this.sb, (NamespaceBinding)nsbEnd);
                this.writer.write(this.sb.toString());
            }
        }
        if (elem.isNilled()) {
            this.writer.write(" xsi:nil=\"true\"");
        }
        this.writer.write(">");
    }

    private void outputEndTag(DIElement elem) {
        this.writer.write("</");
        this.outputTagName(elem);
        this.writer.write(">");
    }

    private void writeStringAsXml(String str) {
        this.incrementIndentation();
        if (this.pretty) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
        }
        this.writer.write("<");
        this.writer.write(XMLTextInfoset$.MODULE$.stringAsXml());
        this.writer.write(" xmlns=\"\">");
        if (this.pretty) {
            this.writer.newLine();
        }
        StringReader sr = new StringReader(str);
        XMLStreamReader xsr = XMLTextInfoset$.MODULE$.xmlInputFactory().createXMLStreamReader((Reader)sr);
        XMLStreamWriter2 xsw = XMLTextInfoset$.MODULE$.xmlOutputFactory().createXMLStreamWriter((Writer)this.writer, StandardCharsets.UTF_8.toString());
        if (xsr.getEventType() != 7) {
            throw Assert$.MODULE$.abort("Invariant broken: xsr.getEventType().==(javax.xml.stream.XMLStreamConstants.START_DOCUMENT)");
        }
        while (xsr.hasNext()) {
            xsr.next();
            XMLTextInfoset$.MODULE$.writeXMLStreamEvent(xsr, (XMLStreamWriter)xsw);
        }
        if (this.pretty) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
        }
        this.writer.write("</");
        this.writer.write(XMLTextInfoset$.MODULE$.stringAsXml());
        this.writer.write(">");
        this.decrementIndentation();
        if (this.pretty) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
            return;
        }
    }

    @Override
    public void startSimple(InfosetSimpleElement se) {
        DISimple simple = (DISimple)se;
        if (this.pretty) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
        }
        this.outputStartTag(simple);
        if (simple.hasValue()) {
            Object object = simple.erd().optPrimType().get();
            NodeInfo$PrimType$String$ nodeInfo$PrimType$String$ = NodeInfo$.MODULE$.String();
            if (!(object != null ? !object.equals(nodeInfo$PrimType$String$) : nodeInfo$PrimType$String$ != null)) {
                String simpleVal = simple.dataValueAsString();
                String string = simple.erd().runtimeProperties().get(XMLTextInfoset$.MODULE$.stringAsXml());
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.writeStringAsXml(simpleVal);
                } else {
                    String string3;
                    String xmlSafe = XMLUtils$.MODULE$.remapXMLIllegalCharactersToPUA(simpleVal);
                    XMLTextEscapeStyle xMLTextEscapeStyle = this.xmlTextEscapeStyle;
                    XMLTextEscapeStyle xMLTextEscapeStyle2 = XMLTextEscapeStyle.CDATA;
                    XMLTextEscapeStyle xMLTextEscapeStyle3 = xMLTextEscapeStyle;
                    if (!(xMLTextEscapeStyle2 != null ? !((Object)((Object)xMLTextEscapeStyle2)).equals((Object)xMLTextEscapeStyle3) : xMLTextEscapeStyle3 != null)) {
                        boolean needsCDataEscape = StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(xmlSafe), (Function1 & Serializable)c -> XMLTextInfosetOutputter.$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
                        string3 = needsCDataEscape ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<![CDATA[%s]]>"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{xmlSafe.replaceAll("]]>", "]]]]><![CDATA[>")})) : xmlSafe;
                    } else {
                        XMLTextEscapeStyle xMLTextEscapeStyle4 = XMLTextEscapeStyle.Standard;
                        XMLTextEscapeStyle xMLTextEscapeStyle5 = xMLTextEscapeStyle;
                        if (!(xMLTextEscapeStyle4 != null ? !((Object)((Object)xMLTextEscapeStyle4)).equals((Object)xMLTextEscapeStyle5) : xMLTextEscapeStyle5 != null)) {
                            boolean needsStandardEscape = StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(xmlSafe), (Function1 & Serializable)c -> XMLTextInfosetOutputter.$anonfun$2(BoxesRunTime.unboxToChar((Object)c)));
                            string3 = needsStandardEscape ? Utility$.MODULE$.escape(xmlSafe) : xmlSafe;
                        } else {
                            throw new MatchError((Object)xMLTextEscapeStyle);
                        }
                    }
                    String escaped = string3;
                    this.writer.write(escaped);
                }
            } else {
                this.writer.write(simple.dataValueAsString());
            }
        }
        this.outputEndTag(simple);
        this.inScopeComplexElementHasChildren = true;
    }

    @Override
    public void endSimple(InfosetSimpleElement simple) {
    }

    @Override
    public void startComplex(InfosetComplexElement ce) {
        DIComplex complex = (DIComplex)ce;
        if (this.pretty) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
        }
        this.outputStartTag(complex);
        this.incrementIndentation();
        this.inScopeComplexElementHasChildren = false;
    }

    @Override
    public void endComplex(InfosetComplexElement ce) {
        DIComplex complex = (DIComplex)ce;
        this.decrementIndentation();
        if (this.pretty && this.inScopeComplexElementHasChildren) {
            this.writer.newLine();
            this.outputIndentation(this.writer);
        }
        this.outputEndTag(complex);
        this.inScopeComplexElementHasChildren = true;
    }

    @Override
    public void startArray(InfosetArray array) {
    }

    @Override
    public void endArray(InfosetArray array) {
    }

    @Override
    public void startDocument() {
        if (!this.minimal) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            return;
        }
    }

    @Override
    public void endDocument() {
        this.writer.newLine();
        this.writer.flush();
    }

    private static final /* synthetic */ boolean $anonfun$1(char c) {
        return c == '<' || c == '>' || c == '\"' || c == '&' || RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c));
    }

    private static final /* synthetic */ boolean $anonfun$2(char c) {
        return c == '<' || c == '>' || c == '\"' || c == '&';
    }
}

