/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import org.apache.daffodil.api.DFDLPrimType;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.infoset.InfosetComplexElement;
import org.apache.daffodil.api.infoset.InfosetSimpleElement;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter$;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.runtime.Scala3RunTime$;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.Node;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.UnprefixedAttribute;

public class ScalaXMLInfosetOutputter
extends org.apache.daffodil.api.infoset.ScalaXMLInfosetOutputter {
    private final boolean showFreedInfo;
    private final MStackOf stack;
    private Object resultNode;

    public static boolean $lessinit$greater$default$1() {
        return ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1();
    }

    public ScalaXMLInfosetOutputter(boolean showFreedInfo) {
        this.showFreedInfo = showFreedInfo;
        this.stack = new MStackOf();
        this.resultNode = Maybe$.MODULE$.Nope();
    }

    public MStackOf<ListBuffer<Node>> stack() {
        return this.stack;
    }

    @Override
    public void reset() {
        this.resultNode = Maybe$.MODULE$.Nope();
        this.stack().clear();
    }

    @Override
    public void startDocument() {
        this.stack().push((ListBuffer<Node>)new ListBuffer());
    }

    @Override
    public void endDocument() {
        ListBuffer<Node> root = this.stack().pop();
        if (root.length() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.resultNode = Maybe$.MODULE$.apply(root.apply(0));
    }

    private MetaData getAttributes(DIElement diElem) {
        Null$ null$;
        Null$ nilAttr;
        Object object = nilAttr = diElem.isNilled() ? XMLUtils$.MODULE$.xmlNilAttribute() : Null$.MODULE$;
        if (this.showFreedInfo) {
            boolean arrayFreed;
            boolean selfFreed = diElem.wouldHaveBeenFreed();
            boolean bl = arrayFreed = diElem.erd().isArray() ? ((DINode)diElem.diParent().find((Function1<DINode, Object>)(Function1 & Serializable)_$2 -> _$2.erd() == diElem.erd()).get()).wouldHaveBeenFreed() : false;
            if (selfFreed || arrayFreed) {
                String freedAttrVal = selfFreed && arrayFreed ? "self+array" : (selfFreed ? "self" : "array");
                null$ = new UnprefixedAttribute("freed", freedAttrVal, (MetaData)nilAttr);
            } else {
                null$ = nilAttr;
            }
        } else {
            null$ = nilAttr;
        }
        Null$ freedAttr = null$;
        return freedAttr;
    }

    @Override
    public void startSimple(InfosetSimpleElement se) {
        Seq seq;
        DISimple diSimple = (DISimple)se;
        MetaData attributes = this.getAttributes(diSimple);
        if (!diSimple.isNilled() && diSimple.hasValue()) {
            DFDLPrimType dFDLPrimType = diSimple.metadata().dfdlType();
            DFDLPrimType dFDLPrimType2 = DFDLPrimType.String;
            String text = !(dFDLPrimType != null ? !((Object)((Object)dFDLPrimType)).equals((Object)dFDLPrimType2) : dFDLPrimType2 != null) ? XMLUtils$.MODULE$.remapXMLIllegalCharactersToPUA(diSimple.dataValueAsString()) : diSimple.dataValueAsString();
            seq = (Seq)((SeqOps)new .colon.colon((Object)new Text(text), (List)Nil$.MODULE$));
        } else {
            seq = (Seq)((SeqOps)Nil$.MODULE$);
        }
        Seq children = seq;
        Elem elem = Elem$.MODULE$.apply(diSimple.metadata().prefix(), diSimple.metadata().name(), attributes, diSimple.metadata().minimizedScope(), true, children);
        ((Buffer)this.stack().top()).append((Object)elem);
    }

    @Override
    public void endSimple(InfosetSimpleElement se) {
    }

    @Override
    public void startComplex(InfosetComplexElement ce) {
        this.stack().push((ListBuffer<Node>)new ListBuffer());
    }

    @Override
    public void endComplex(InfosetComplexElement ce) {
        DIComplex diComplex = (DIComplex)ce;
        MetaData attributes = this.getAttributes(diComplex);
        ListBuffer<Node> children = this.stack().pop();
        Elem elem = Elem$.MODULE$.apply(diComplex.metadata().prefix(), diComplex.metadata().name(), attributes, diComplex.metadata().minimizedScope(), true, (Seq)NodeSeq$.MODULE$.seqToNodeSeq(children));
        ((Buffer)this.stack().top()).append((Object)elem);
    }

    @Override
    public void startArray(InfosetArray ar) {
    }

    @Override
    public void endArray(InfosetArray ar) {
    }

    @Override
    public Node getResult() {
        Object object = this.resultNode;
        if (!Maybe$.MODULE$.isDefined$extension(object)) {
            throw Assert$.MODULE$.usageError2("No result to get. Must check isError parse result before calling getResult", "ScalaXMLInfosetOutputter.this.resultNode.isDefined");
        }
        Object object2 = this.resultNode;
        return (Node)Maybe$.MODULE$.get$extension(object2);
    }
}

