/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionBindingQueryResponseMessage
extends PacketImpl {
    protected boolean exists;
    protected List<SimpleString> queueNames;

    public SessionBindingQueryResponseMessage(boolean exists, List<SimpleString> queueNames) {
        super((byte)50);
        this.exists = exists;
        this.queueNames = queueNames;
    }

    public SessionBindingQueryResponseMessage() {
        super((byte)50);
    }

    public SessionBindingQueryResponseMessage(byte v) {
        super(v);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isExists() {
        return this.exists;
    }

    public List<SimpleString> getQueueNames() {
        return this.queueNames;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exists);
        buffer.writeInt(this.queueNames.size());
        for (SimpleString queueName : this.queueNames) {
            buffer.writeSimpleString(queueName);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exists = buffer.readBoolean();
        int numQueues = buffer.readInt();
        this.queueNames = new ArrayList<SimpleString>(numQueues);
        for (int i = 0; i < numQueues; ++i) {
            this.queueNames.add(buffer.readSimpleString());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exists ? 1231 : 1237);
        result = 31 * result + (this.queueNames == null ? 0 : this.queueNames.hashCode());
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", exists=" + this.exists);
        sb.append(", queueNames=" + String.valueOf(this.queueNames));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionBindingQueryResponseMessage)) {
            return false;
        }
        SessionBindingQueryResponseMessage other = (SessionBindingQueryResponseMessage)obj;
        if (this.exists != other.exists) {
            return false;
        }
        return !(this.queueNames == null ? other.queueNames != null : !this.queueNames.equals(other.queueNames));
    }
}

