/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.spi.core.security.jaas.ReloadableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String LOGIN_CONFIG_SYS_PROP_NAME = "java.security.auth.login.config";
    static final Map<FileNameKey, ReloadableProperties> staticCache = new HashMap<FileNameKey, ReloadableProperties>();
    protected boolean debug;

    public void init(Map options) {
        this.debug = PropertiesLoader.booleanOption("debug", options);
        if (this.debug) {
            logger.debug("Initialized debug");
        }
    }

    public ReloadableProperties load(String nameProperty, String fallbackName, Map options) {
        return this.load(nameProperty, fallbackName, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReloadableProperties load(String nameProperty, String fallbackName, Map options, final NormaliseStringValues valueNormaliser) {
        ReloadableProperties result;
        FileNameKey key = new FileNameKey(nameProperty, fallbackName, options);
        key.setDebug(this.debug);
        Map<FileNameKey, ReloadableProperties> map = staticCache;
        synchronized (map) {
            result = staticCache.get(key);
            if (result == null) {
                result = valueNormaliser == null ? new ReloadableProperties(key) : new ReloadableProperties(key){

                    @Override
                    protected String normaliseStringValue(String value) {
                        return valueNormaliser.normalize(value);
                    }
                };
                staticCache.put(key, result);
            }
        }
        return result.obtained();
    }

    protected static boolean booleanOption(String name, Map options) {
        return Boolean.parseBoolean((String)options.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        ArrayList<ReloadableProperties> currentSnapshot;
        logger.debug("reLoad");
        Map<FileNameKey, ReloadableProperties> map = staticCache;
        synchronized (map) {
            currentSnapshot = new ArrayList<ReloadableProperties>(staticCache.values());
        }
        for (ReloadableProperties reloadableProperties : currentSnapshot) {
            reloadableProperties.obtained();
        }
    }

    public static void resetUsersAndGroupsCache() {
        staticCache.clear();
    }

    static interface NormaliseStringValues {
        public String normalize(String var1);
    }

    public static final class FileNameKey {
        final File file;
        final String absPath;
        final boolean reload;
        private boolean decrypt;
        private boolean debug;

        public FileNameKey(String nameProperty, String fallbackName, Map options) {
            this.file = new File(this.baseDir(options), this.stringOption(nameProperty, fallbackName, options));
            this.absPath = this.file.getAbsolutePath();
            this.reload = PropertiesLoader.booleanOption("reload", options);
            this.decrypt = PropertiesLoader.booleanOption("decrypt", options);
        }

        public boolean equals(Object other) {
            return other instanceof FileNameKey && this.absPath.equals(((FileNameKey)other).absPath);
        }

        public int hashCode() {
            return this.absPath.hashCode();
        }

        public boolean isReload() {
            return this.reload;
        }

        public File file() {
            return this.file;
        }

        public boolean isDecrypt() {
            return this.decrypt;
        }

        public void setDecrypt(boolean decrypt) {
            this.decrypt = decrypt;
        }

        private String stringOption(String key, String nameDefault, Map options) {
            Object result = options.get(key);
            return result != null ? result.toString() : nameDefault;
        }

        private File baseDir(Map options) {
            File baseDir = null;
            baseDir = options.get("baseDir") != null ? new File((String)options.get("baseDir")) : FileNameKey.parentDirOfLoginConfigSystemProperty();
            if (this.debug) {
                logger.debug("Using basedir={}", (Object)(baseDir == null ? null : baseDir.getAbsolutePath()));
            }
            return baseDir;
        }

        public static File parentDirOfLoginConfigSystemProperty() {
            String path = System.getProperty(LOGIN_CONFIG_SYS_PROP_NAME);
            if (path != null) {
                return new File(path).getParentFile();
            }
            return null;
        }

        public String toString() {
            return "PropsFile=" + this.absPath;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

