/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Test;

public final class JarTest
extends AbstractTest {
    @Test
    void testJarArchiveCreation() throws Exception {
        File output = this.newTempFile("bla.jar");
        File file1 = JarTest.getFile("test1.xml");
        File file2 = JarTest.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("jar", out);){
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            os.write(file1);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            os.write(file2);
            os.closeArchiveEntry();
        }
    }

    @Test
    void testJarUnarchive() throws Exception {
        File input = JarTest.getFile("bla.jar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipArchiveInputStream in = (ZipArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ZipArchiveEntry entry = in.getNextEntry();
            File o = this.newTempFile(entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
            entry = in.getNextEntry();
            o = this.newTempFile(entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
            entry = in.getNextEntry();
            o = this.newTempFile(entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
        }
    }

    @Test
    void testJarUnarchiveAll() throws Exception {
        File input = JarTest.getFile("bla.jar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            in.forEach(entry -> {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                } else {
                    Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                }
            });
        }
    }
}

