/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationContext;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;

class BatchTranslatorContext<T extends BatchQuery>
implements SQLGenerationContext {
    private final T query;
    private final DbAdapter adapter;
    private final List<DbAttributeBinding> bindings;

    BatchTranslatorContext(T query, DbAdapter adapter) {
        this.query = query;
        this.adapter = adapter;
        this.bindings = new ArrayList<DbAttributeBinding>();
    }

    @Override
    public DbAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public Collection<DbAttributeBinding> getBindings() {
        return this.bindings;
    }

    @Override
    public QuotingStrategy getQuotingStrategy() {
        return this.adapter.getQuotingStrategy();
    }

    @Override
    public DbEntity getRootDbEntity() {
        return ((BatchQuery)this.query).getDbEntity();
    }

    public T getQuery() {
        return this.query;
    }
}

