/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.net.AsyncStreamingInputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableZeroCopyWriter
extends SSTable
implements SSTableMultiWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigTableZeroCopyWriter.class);
    private final TableMetadataRef metadata;
    private volatile SSTableReader finalReader;
    private final Map<Component.Type, SequentialWriter> componentWriters;
    private static final SequentialWriterOption WRITER_OPTION = SequentialWriterOption.newBuilder().trickleFsync(false).bufferSize(0x200000).bufferType(BufferType.OFF_HEAP).build();
    private static final ImmutableSet<Component> SUPPORTED_COMPONENTS = ImmutableSet.of((Object)Component.DATA, (Object)Component.PRIMARY_INDEX, (Object)Component.SUMMARY, (Object)Component.STATS, (Object)Component.COMPRESSION_INFO, (Object)Component.FILTER, (Object[])new Component[]{Component.DIGEST, Component.CRC});

    public BigTableZeroCopyWriter(Descriptor descriptor, TableMetadataRef metadata, LifecycleNewTracker lifecycleNewTracker, Collection<Component> components) {
        super(descriptor, (Set<Component>)ImmutableSet.copyOf(components), metadata, DatabaseDescriptor.getDiskOptimizationStrategy());
        lifecycleNewTracker.trackNew(this);
        this.metadata = metadata;
        this.componentWriters = new EnumMap<Component.Type, SequentialWriter>(Component.Type.class);
        if (!SUPPORTED_COMPONENTS.containsAll(components)) {
            throw new AssertionError((Object)String.format("Unsupported streaming component detected %s", Sets.difference((Set)ImmutableSet.copyOf(components), SUPPORTED_COMPONENTS)));
        }
        for (Component c : components) {
            this.componentWriters.put(c.type, BigTableZeroCopyWriter.makeWriter(descriptor, c));
        }
    }

    private static SequentialWriter makeWriter(Descriptor descriptor, Component component) {
        return new SequentialWriter(new File(descriptor.filenameFor(component)), WRITER_OPTION, false);
    }

    private void write(DataInputPlus in, long size, SequentialWriter out) throws FSWriteError {
        int BUFFER_SIZE = 0x100000;
        byte[] buff = new byte[0x100000];
        try {
            int count;
            for (long bytesRead = 0L; bytesRead < size; bytesRead += (long)count) {
                int toRead = (int)Math.min(size - bytesRead, 0x100000L);
                in.readFully(buff, 0, toRead);
                count = Math.min(toRead, 0x100000);
                out.write(buff, 0, count);
            }
            out.sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, out.getPath());
        }
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        throw new UnsupportedOperationException("Operation not supported by BigTableBlockWriter");
    }

    @Override
    public Collection<SSTableReader> finish(long repairedAt, long maxDataAge, boolean openResult) {
        return this.finish(openResult);
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        this.setOpenResult(openResult);
        for (SequentialWriter writer : this.componentWriters.values()) {
            writer.finish();
        }
        return this.finished();
    }

    @Override
    public Collection<SSTableReader> finished() {
        if (this.finalReader == null) {
            this.finalReader = SSTableReader.open(this.descriptor, this.components, this.metadata);
        }
        return ImmutableList.of((Object)this.finalReader);
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        return null;
    }

    @Override
    public long getFilePointer() {
        return 0L;
    }

    @Override
    public long getOnDiskBytesWritten() {
        return 0L;
    }

    @Override
    public TableId getTableId() {
        return this.metadata.id;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        for (SequentialWriter writer : this.componentWriters.values()) {
            accumulate = writer.commit(accumulate);
        }
        return accumulate;
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        for (SequentialWriter writer : this.componentWriters.values()) {
            accumulate = writer.abort(accumulate);
        }
        return accumulate;
    }

    @Override
    public void prepareToCommit() {
        for (SequentialWriter writer : this.componentWriters.values()) {
            writer.prepareToCommit();
        }
    }

    @Override
    public void close() {
        for (SequentialWriter writer : this.componentWriters.values()) {
            writer.close();
        }
    }

    public void writeComponent(Component.Type type, DataInputPlus in, long size) {
        logger.info("Writing component {} to {} length {}", new Object[]{type, this.componentWriters.get((Object)type).getPath(), FBUtilities.prettyPrintMemory(size)});
        if (in instanceof AsyncStreamingInputPlus) {
            this.write((AsyncStreamingInputPlus)in, size, this.componentWriters.get((Object)type));
        } else {
            this.write(in, size, this.componentWriters.get((Object)type));
        }
    }

    private void write(AsyncStreamingInputPlus in, long size, SequentialWriter writer) {
        logger.info("Block Writing component to {} length {}", (Object)writer.getPath(), (Object)FBUtilities.prettyPrintMemory(size));
        try {
            in.consume(writer::writeDirectlyToChannel, size);
            writer.sync();
        }
        catch (EOFException | AsyncStreamingInputPlus.InputTimeoutException e) {
            in.close();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, writer.getPath());
        }
    }
}

