/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.SchemaConstants;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStrategy
extends AbstractReplicationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SimpleStrategy.class);

    public SimpleStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        int replicas = this.getReplicationFactor();
        ArrayList<Token> tokens = metadata.sortedTokens();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        while (endpoints.size() < replicas && iter.hasNext()) {
            InetAddress ep = metadata.getEndpoint(iter.next());
            if (endpoints.contains(ep)) continue;
            endpoints.add(ep);
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        return Integer.parseInt((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        String rf = (String)this.configOptions.get("replication_factor");
        if (rf == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
        this.validateReplicationFactor(rf);
    }

    @Override
    public void maybeWarnOnOptions() {
        if (!SchemaConstants.isLocalSystemKeyspace(this.keyspaceName) && !SchemaConstants.isReplicatedSystemKeyspace(this.keyspaceName)) {
            int nodeCount = StorageService.instance.getHostIdToEndpoint().size();
            int rf = this.getReplicationFactor();
            if (rf > nodeCount && nodeCount != 0) {
                String msg = "Your replication factor " + rf + " for keyspace " + this.keyspaceName + " is higher than the number of nodes " + nodeCount;
                if (ClientWarn.instance.getWarnings() == null || !ClientWarn.instance.getWarnings().contains(msg)) {
                    ClientWarn.instance.warn(msg);
                    logger.warn(msg);
                }
            }
        }
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.singleton("replication_factor");
    }
}

