/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.mail;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.google.api.services.gmail.Gmail.Users.Messages}.
 */
@ApiParams(apiName = "messages", 
           description = "The messages collection of methods",
           apiMethods = {@ApiMethod(methodName = "attachments", description="An accessor for creating requests from the Attachments collection", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Attachments attachments()"}), @ApiMethod(methodName = "batchDelete", description="Deletes many messages by message ID", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$BatchDelete batchDelete(String userId, com.google.api.services.gmail.model.BatchDeleteMessagesRequest content)"}), @ApiMethod(methodName = "batchModify", description="Modifies the labels on the specified messages", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$BatchModify batchModify(String userId, com.google.api.services.gmail.model.BatchModifyMessagesRequest content)"}), @ApiMethod(methodName = "delete", description="Immediately and permanently deletes the specified message", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Delete delete(String userId, String id)"}), @ApiMethod(methodName = "get", description="Gets the specified message", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Get get(String userId, String id)"}), @ApiMethod(methodName = "gmailImport", description="Imports a message into only this user's mailbox, with standard email delivery scanning and classification similar to receiving via SMTP", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$GmailImport gmailImport(String userId, com.google.api.services.gmail.model.Message content)", "com.google.api.services.gmail.Gmail$Users$Messages$GmailImport gmailImport(String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "insert", description="Directly inserts a message into only this user's mailbox similar to IMAP APPEND, bypassing most scanning and classification", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Insert insert(String userId, com.google.api.services.gmail.model.Message content)", "com.google.api.services.gmail.Gmail$Users$Messages$Insert insert(String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "list", description="Lists the messages in the user's mailbox", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$List list(String userId)"}), @ApiMethod(methodName = "modify", description="Modifies the labels on the specified message", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Modify modify(String userId, String id, com.google.api.services.gmail.model.ModifyMessageRequest content)"}), @ApiMethod(methodName = "send", description="Sends the specified message to the recipients in the To, Cc, and Bcc headers", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Send send(String userId, com.google.api.services.gmail.model.Message content)", "com.google.api.services.gmail.Gmail$Users$Messages$Send send(String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "trash", description="Moves the specified message to the trash", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Trash trash(String userId, String id)"}), @ApiMethod(methodName = "untrash", description="Removes the specified message from the trash", signatures={"com.google.api.services.gmail.Gmail$Users$Messages$Untrash untrash(String userId, String id)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
public final class GmailUsersMessagesEndpointConfiguration extends GoogleMailConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "batchDelete", description="The com.google.api.services.gmail.model.BatchDeleteMessagesRequest")})
    private com.google.api.services.gmail.model.BatchDeleteMessagesRequest batchDeleteMessagesRequest;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "batchModify", description="The com.google.api.services.gmail.model.BatchModifyMessagesRequest")})
    private com.google.api.services.gmail.model.BatchModifyMessagesRequest batchModifyMessagesRequest;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "gmailImport", description="The com.google.api.services.gmail.model.Message media metadata or null if none"), @ApiMethod(methodName = "insert", description="The com.google.api.services.gmail.model.Message media metadata or null if none"), @ApiMethod(methodName = "send", description="The com.google.api.services.gmail.model.Message media metadata or null if none")})
    private com.google.api.services.gmail.model.Message content;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "gmailImport", description="Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault administrator"), @ApiMethod(methodName = "insert", description="Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault administrator")})
    private java.lang.Boolean deleted;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "get", description="The format to return the message in")})
    private java.lang.String format;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "delete", description="The ID of the message to delete"), @ApiMethod(methodName = "get", description="The ID of the message to retrieve. This ID is usually retrieved using messages.list. The ID is also contained in the result when a message is inserted (messages.insert) or imported (messages.import)."), @ApiMethod(methodName = "modify", description="The ID of the message to modify"), @ApiMethod(methodName = "trash", description="The ID of the message to Trash"), @ApiMethod(methodName = "untrash", description="The ID of the message to remove from Trash")})
    private String id;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Include messages from SPAM and TRASH in the results")})
    private java.lang.Boolean includeSpamTrash;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "gmailImport", description="Source for Gmail's internal date of the message"), @ApiMethod(methodName = "insert", description="Source for Gmail's internal date of the message")})
    private java.lang.String internalDateSource;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Only return messages with labels that match all of the specified label IDs")})
    private java.util.List labelIds;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Maximum number of messages to return")})
    private java.lang.Long maxResults;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "gmailImport", description="The media HTTP content"), @ApiMethod(methodName = "insert", description="The media HTTP content"), @ApiMethod(methodName = "send", description="The media HTTP content")})
    private com.google.api.client.http.AbstractInputStreamContent mediaContent;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "get", description="When given and format is METADATA, only include headers specified")})
    private java.util.List metadataHeaders;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "modify", description="The com.google.api.services.gmail.model.ModifyMessageRequest")})
    private com.google.api.services.gmail.model.ModifyMessageRequest modifyMessageRequest;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "gmailImport", description="Ignore the Gmail spam classifier decision and never mark this email as SPAM in the mailbox")})
    private java.lang.Boolean neverMarkSpam;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Page token to retrieve a specific page of results in the list")})
    private java.lang.String pageToken;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "gmailImport", description="Process calendar invites in the email and add any extracted meetings to the Google Calendar for this user")})
    private java.lang.Boolean processForCalendar;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Only return messages matching the specified query")})
    private java.lang.String q;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "batchDelete", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "batchModify", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "delete", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "get", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "gmailImport", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "insert", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "list", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "modify", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "send", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "trash", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "untrash", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me")})
    private String userId;

    public com.google.api.services.gmail.model.BatchDeleteMessagesRequest getBatchDeleteMessagesRequest() {
        return batchDeleteMessagesRequest;
    }

    public void setBatchDeleteMessagesRequest(com.google.api.services.gmail.model.BatchDeleteMessagesRequest batchDeleteMessagesRequest) {
        this.batchDeleteMessagesRequest = batchDeleteMessagesRequest;
    }

    public com.google.api.services.gmail.model.BatchModifyMessagesRequest getBatchModifyMessagesRequest() {
        return batchModifyMessagesRequest;
    }

    public void setBatchModifyMessagesRequest(com.google.api.services.gmail.model.BatchModifyMessagesRequest batchModifyMessagesRequest) {
        this.batchModifyMessagesRequest = batchModifyMessagesRequest;
    }

    public com.google.api.services.gmail.model.Message getContent() {
        return content;
    }

    public void setContent(com.google.api.services.gmail.model.Message content) {
        this.content = content;
    }

    public java.lang.Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(java.lang.Boolean deleted) {
        this.deleted = deleted;
    }

    public java.lang.String getFormat() {
        return format;
    }

    public void setFormat(java.lang.String format) {
        this.format = format;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public java.lang.Boolean getIncludeSpamTrash() {
        return includeSpamTrash;
    }

    public void setIncludeSpamTrash(java.lang.Boolean includeSpamTrash) {
        this.includeSpamTrash = includeSpamTrash;
    }

    public java.lang.String getInternalDateSource() {
        return internalDateSource;
    }

    public void setInternalDateSource(java.lang.String internalDateSource) {
        this.internalDateSource = internalDateSource;
    }

    public java.util.List getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(java.util.List labelIds) {
        this.labelIds = labelIds;
    }

    public java.lang.Long getMaxResults() {
        return maxResults;
    }

    public void setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
    }

    public com.google.api.client.http.AbstractInputStreamContent getMediaContent() {
        return mediaContent;
    }

    public void setMediaContent(com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        this.mediaContent = mediaContent;
    }

    public java.util.List getMetadataHeaders() {
        return metadataHeaders;
    }

    public void setMetadataHeaders(java.util.List metadataHeaders) {
        this.metadataHeaders = metadataHeaders;
    }

    public com.google.api.services.gmail.model.ModifyMessageRequest getModifyMessageRequest() {
        return modifyMessageRequest;
    }

    public void setModifyMessageRequest(com.google.api.services.gmail.model.ModifyMessageRequest modifyMessageRequest) {
        this.modifyMessageRequest = modifyMessageRequest;
    }

    public java.lang.Boolean getNeverMarkSpam() {
        return neverMarkSpam;
    }

    public void setNeverMarkSpam(java.lang.Boolean neverMarkSpam) {
        this.neverMarkSpam = neverMarkSpam;
    }

    public java.lang.String getPageToken() {
        return pageToken;
    }

    public void setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
    }

    public java.lang.Boolean getProcessForCalendar() {
        return processForCalendar;
    }

    public void setProcessForCalendar(java.lang.Boolean processForCalendar) {
        this.processForCalendar = processForCalendar;
    }

    public java.lang.String getQ() {
        return q;
    }

    public void setQ(java.lang.String q) {
        this.q = q;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
