/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.exceptions;

import io.reactivex.rxjava3.annotations.NonNull;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    public CompositeException(Throwable ... exceptions) {
        this(exceptions == null ? Collections.singletonList(new NullPointerException("exceptions was null")) : Arrays.asList(exceptions));
    }

    public CompositeException(@NonNull Iterable<? extends Throwable> errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        if (errors != null) {
            for (Throwable throwable : errors) {
                if (throwable instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    deDupedExceptions.add(throwable);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException("Throwable was null!"));
            }
        } else {
            deDupedExceptions.add(new NullPointerException("errors was null"));
        }
        if (deDupedExceptions.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        ArrayList localExceptions = new ArrayList(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(localExceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    @NonNull
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NonNull
    public synchronized Throwable getCause() {
        if (this.cause == null) {
            String separator = System.getProperty("line.separator");
            if (this.exceptions.size() > 1) {
                IdentityHashMap<Throwable, Boolean> seenCauses = new IdentityHashMap<Throwable, Boolean>();
                StringBuilder aggregateMessage = new StringBuilder();
                aggregateMessage.append("Multiple exceptions (").append(this.exceptions.size()).append(")").append(separator);
                block0: for (Throwable inner : this.exceptions) {
                    int depth = 0;
                    while (inner != null) {
                        for (int i = 0; i < depth; ++i) {
                            aggregateMessage.append("  ");
                        }
                        aggregateMessage.append("|-- ");
                        aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
                        String innerMessage = inner.getMessage();
                        if (innerMessage != null && innerMessage.contains(separator)) {
                            aggregateMessage.append(separator);
                            for (String line : innerMessage.split(separator)) {
                                for (int i = 0; i < depth + 2; ++i) {
                                    aggregateMessage.append("  ");
                                }
                                aggregateMessage.append(line).append(separator);
                            }
                        } else {
                            aggregateMessage.append(innerMessage);
                            aggregateMessage.append(separator);
                        }
                        for (int i = 0; i < depth + 2; ++i) {
                            aggregateMessage.append("  ");
                        }
                        StackTraceElement[] st = inner.getStackTrace();
                        if (st.length > 0) {
                            aggregateMessage.append("at ").append(st[0]).append(separator);
                        }
                        if (!seenCauses.containsKey(inner)) {
                            seenCauses.put(inner, true);
                            inner = inner.getCause();
                            ++depth;
                            continue;
                        }
                        if ((inner = inner.getCause()) == null) continue block0;
                        for (int i = 0; i < depth + 2; ++i) {
                            aggregateMessage.append("  ");
                        }
                        aggregateMessage.append("|-- ");
                        aggregateMessage.append("(cause not expanded again) ");
                        aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
                        aggregateMessage.append(inner.getMessage());
                        aggregateMessage.append(separator);
                        continue block0;
                    }
                }
                this.cause = new ExceptionOverview(aggregateMessage.toString().trim());
            } else {
                this.cause = this.exceptions.get(0);
            }
        }
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    private void printStackTrace(PrintStreamOrWriter s) {
        StringBuilder b = new StringBuilder(128);
        b.append(this).append('\n');
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            b.append("\tat ").append(myStackElement).append('\n');
        }
        int i = 1;
        for (Throwable ex : this.exceptions) {
            b.append("  ComposedException ").append(i).append(" :\n");
            this.appendStackTrace(b, ex, "\t");
            ++i;
        }
        s.println(b.toString());
    }

    private void appendStackTrace(StringBuilder b, Throwable ex, String prefix) {
        b.append(prefix).append(ex).append('\n');
        for (StackTraceElement stackElement : ex.getStackTrace()) {
            b.append("\t\tat ").append(stackElement).append('\n');
        }
        if (ex.getCause() != null) {
            b.append("\tCaused by: ");
            this.appendStackTrace(b, ex.getCause(), "");
        }
    }

    public int size() {
        return this.exceptions.size();
    }

    static final class ExceptionOverview
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;

        ExceptionOverview(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }
    }

    static final class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }
    }

    static abstract class PrintStreamOrWriter {
        PrintStreamOrWriter() {
        }

        abstract void println(Object var1);
    }
}

