/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.net;

import java.util.List;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.distributedlog.net.DNSResolverForRacks;
import org.apache.distributedlog.net.NetUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNetUtils {
    @Test(timeout=20000L)
    public void testGetDNSResolverWithOverrides() throws Exception {
        DNSToSwitchMapping dnsResolver = NetUtils.getDNSResolver(DNSResolverForRacks.class, (String)"");
        Assert.assertEquals((String)("Should succeed to load " + DNSResolverForRacks.class), dnsResolver.getClass(), DNSResolverForRacks.class);
    }

    @Test(timeout=20000L)
    public void testGetDNSResolverWithDefaultConstructor() throws Exception {
        DNSToSwitchMapping dnsResolver = NetUtils.getDNSResolver(DNSResolverWithDefaultConstructor.class, (String)"");
        Assert.assertEquals((String)("Should succeed to load " + DNSResolverWithDefaultConstructor.class), dnsResolver.getClass(), DNSResolverWithDefaultConstructor.class);
    }

    @Test(timeout=20000L, expected=RuntimeException.class)
    public void testGetDNSResolverWithUnknownConstructor() throws Exception {
        NetUtils.getDNSResolver(DNSResolverWithUnknownConstructor.class, (String)"");
    }

    static class DNSResolverWithUnknownConstructor
    implements DNSToSwitchMapping {
        public DNSResolverWithUnknownConstructor(int var1, int var2, int var3) {
        }

        public List<String> resolve(List<String> list) {
            return list;
        }

        public void reloadCachedMappings() {
        }
    }

    static class DNSResolverWithDefaultConstructor
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> list) {
            return list;
        }

        public void reloadCachedMappings() {
        }
    }
}

