/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import java.util.Optional;
import org.apache.commons.cli.CommandLine;

public class CommandLineUtils {
    public static Optional<String> getOptionalStringArg(CommandLine cmdline, String arg) {
        if (cmdline.hasOption(arg)) {
            return Optional.of(cmdline.getOptionValue(arg));
        }
        return Optional.empty();
    }

    public static Optional<Boolean> getOptionalBooleanArg(CommandLine cmdline, String arg) {
        if (cmdline.hasOption(arg)) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    public static Optional<Integer> getOptionalIntegerArg(CommandLine cmdline, String arg) throws IllegalArgumentException {
        try {
            if (cmdline.hasOption(arg)) {
                return Optional.of(Integer.parseInt(cmdline.getOptionValue(arg)));
            }
            return Optional.empty();
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(arg + " is not a number");
        }
    }
}

