/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.bookkeeper.api.kv.impl.result.IncrementResultImpl;
import org.apache.bookkeeper.api.kv.impl.result.KeyValueFactory;
import org.apache.bookkeeper.api.kv.impl.result.PutResultImpl;
import org.apache.bookkeeper.api.kv.impl.result.ResultFactory;
import org.apache.bookkeeper.api.kv.impl.result.TxnResultImpl;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.CompareTarget;
import org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.RequestOp;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;

public final class KvUtils {
    private KvUtils() {
    }

    public static ByteString toProtoKey(ByteBuf key) {
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)key.nioBuffer());
    }

    public static KeyValue<ByteBuf, ByteBuf> fromProtoKeyValue(org.apache.bookkeeper.stream.proto.kv.KeyValue kv, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        return kvFactory.newKv().key((Object)Unpooled.wrappedBuffer((ByteBuffer)kv.getKey().asReadOnlyByteBuffer())).value((Object)Unpooled.wrappedBuffer((ByteBuffer)kv.getValue().asReadOnlyByteBuffer())).isNumber(kv.getIsNumber()).numberValue(kv.getNumberValue()).createRevision(kv.getCreateRevision()).modifiedRevision(kv.getModRevision()).version(kv.getVersion());
    }

    public static List<KeyValue<ByteBuf, ByteBuf>> fromProtoKeyValues(List<org.apache.bookkeeper.stream.proto.kv.KeyValue> kvs, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        return Lists.transform(kvs, kv -> KvUtils.fromProtoKeyValue(kv, kvFactory));
    }

    public static RangeRequest.Builder newRangeRequest(ByteBuf key, RangeOption<ByteBuf> option) {
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(KvUtils.toProtoKey(key)).setCountOnly(option.countOnly()).setKeysOnly(option.keysOnly()).setLimit(option.limit()).setMinCreateRevision(option.minCreateRev()).setMaxCreateRevision(option.maxCreateRev()).setMinModRevision(option.minModRev()).setMaxModRevision(option.maxModRev());
        if (null != option.endKey()) {
            builder = builder.setRangeEnd(KvUtils.toProtoKey((ByteBuf)option.endKey()));
        }
        return builder;
    }

    public static RangeResult<ByteBuf, ByteBuf> newRangeResult(RangeResponse response, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        return resultFactory.newRangeResult(-1L).count(response.getCount()).more(response.getMore()).kvs(KvUtils.fromProtoKeyValues(response.getKvsList(), kvFactory));
    }

    public static PutRequest.Builder newPutRequest(ByteBuf key, ByteBuf value, PutOption<ByteBuf> option) {
        return PutRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((ByteBuffer)key.nioBuffer())).setValue(UnsafeByteOperations.unsafeWrap((ByteBuffer)value.nioBuffer())).setPrevKv(option.prevKv());
    }

    public static PutResult<ByteBuf, ByteBuf> newPutResult(PutResponse response, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        PutResultImpl result = resultFactory.newPutResult(-1L);
        if (response.hasPrevKv()) {
            result.prevKv(KvUtils.fromProtoKeyValue(response.getPrevKv(), kvFactory));
        }
        return result;
    }

    public static IncrementRequest.Builder newIncrementRequest(ByteBuf key, long amount, IncrementOption<ByteBuf> option) {
        return IncrementRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((ByteBuffer)key.nioBuffer())).setAmount(amount).setGetTotal(option.getTotal());
    }

    public static IncrementResult<ByteBuf, ByteBuf> newIncrementResult(IncrementResponse response, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        IncrementResultImpl result = resultFactory.newIncrementResult(-1L).totalAmount(response.getTotalAmount());
        return result;
    }

    public static DeleteRangeRequest.Builder newDeleteRequest(ByteBuf key, DeleteOption<ByteBuf> option) {
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((ByteBuffer)key.nioBuffer())).setPrevKv(option.prevKv());
        if (null != option.endKey()) {
            builder = builder.setRangeEnd(UnsafeByteOperations.unsafeWrap((ByteBuffer)((ByteBuf)option.endKey()).nioBuffer()));
        }
        return builder;
    }

    public static DeleteResult<ByteBuf, ByteBuf> newDeleteResult(DeleteRangeResponse response, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        return resultFactory.newDeleteResult(-1L).numDeleted(response.getDeleted()).prevKvs(KvUtils.fromProtoKeyValues(response.getPrevKvsList(), kvFactory));
    }

    public static Compare.CompareTarget toProtoTarget(CompareTarget target) {
        switch (target) {
            case MOD: {
                return Compare.CompareTarget.MOD;
            }
            case VALUE: {
                return Compare.CompareTarget.VALUE;
            }
            case CREATE: {
                return Compare.CompareTarget.CREATE;
            }
            case VERSION: {
                return Compare.CompareTarget.VERSION;
            }
        }
        return Compare.CompareTarget.UNRECOGNIZED;
    }

    public static Compare.CompareResult toProtoResult(CompareResult result) {
        switch (result) {
            case LESS: {
                return Compare.CompareResult.LESS;
            }
            case EQUAL: {
                return Compare.CompareResult.EQUAL;
            }
            case GREATER: {
                return Compare.CompareResult.GREATER;
            }
            case NOT_EQUAL: {
                return Compare.CompareResult.NOT_EQUAL;
            }
        }
        return Compare.CompareResult.UNRECOGNIZED;
    }

    public static Compare.Builder toProtoCompare(CompareOp<ByteBuf, ByteBuf> cmp) {
        Compare.Builder builder = Compare.newBuilder().setTarget(KvUtils.toProtoTarget(cmp.target())).setResult(KvUtils.toProtoResult(cmp.result())).setKey(KvUtils.toProtoKey((ByteBuf)cmp.key()));
        switch (cmp.target()) {
            case VERSION: {
                builder.setVersion(cmp.revision());
                break;
            }
            case MOD: {
                builder.setModRevision(cmp.revision());
                break;
            }
            case CREATE: {
                builder.setCreateRevision(cmp.revision());
                break;
            }
            case VALUE: {
                ByteBuf value = (ByteBuf)cmp.value();
                if (null == value) {
                    value = Unpooled.wrappedBuffer((byte[])new byte[0]);
                }
                builder.setValue(KvUtils.toProtoKey(value));
                break;
            }
        }
        return builder;
    }

    public static PutRequest.Builder toProtoPutRequest(PutOp<ByteBuf, ByteBuf> op) {
        return PutRequest.newBuilder().setPrevKv(op.option().prevKv()).setKey(KvUtils.toProtoKey((ByteBuf)op.key())).setValue(KvUtils.toProtoKey((ByteBuf)op.value()));
    }

    public static DeleteRangeRequest.Builder toProtoDeleteRequest(DeleteOp<ByteBuf, ByteBuf> op) {
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(KvUtils.toProtoKey((ByteBuf)op.key())).setPrevKv(op.option().prevKv());
        if (null != op.option().endKey()) {
            builder.setRangeEnd(KvUtils.toProtoKey((ByteBuf)op.option().endKey()));
        }
        return builder;
    }

    public static RangeRequest.Builder toProtoRangeRequest(RangeOp<ByteBuf, ByteBuf> op) {
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(KvUtils.toProtoKey((ByteBuf)op.key())).setCountOnly(op.option().countOnly()).setKeysOnly(op.option().keysOnly()).setLimit(op.option().limit());
        if (null != op.option().endKey()) {
            builder.setRangeEnd(KvUtils.toProtoKey((ByteBuf)op.option().endKey()));
        }
        return builder;
    }

    public static RequestOp.Builder toProtoRequest(Op<ByteBuf, ByteBuf> op) {
        RequestOp.Builder reqBuilder = RequestOp.newBuilder();
        switch (op.type()) {
            case DELETE: {
                reqBuilder.setRequestDeleteRange(KvUtils.toProtoDeleteRequest((DeleteOp<ByteBuf, ByteBuf>)((DeleteOp)op)));
                break;
            }
            case RANGE: {
                reqBuilder.setRequestRange(KvUtils.toProtoRangeRequest((RangeOp<ByteBuf, ByteBuf>)((RangeOp)op)));
                break;
            }
            case PUT: {
                reqBuilder.setRequestPut(KvUtils.toProtoPutRequest((PutOp<ByteBuf, ByteBuf>)((PutOp)op)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Type '" + op.type() + "' is not supported in a txn yet.");
            }
        }
        return reqBuilder;
    }

    public static TxnResult<ByteBuf, ByteBuf> newKvTxnResult(TxnResponse txnResponse, ResultFactory<ByteBuf, ByteBuf> resultFactory, KeyValueFactory<ByteBuf, ByteBuf> kvFactory) {
        TxnResultImpl result = resultFactory.newTxnResult(-1L);
        result.isSuccess(txnResponse.getSucceeded());
        result.results(Lists.transform((List)txnResponse.getResponsesList(), op -> {
            switch (op.getResponseCase()) {
                case RESPONSE_PUT: {
                    return KvUtils.newPutResult(op.getResponsePut(), resultFactory, kvFactory);
                }
                case RESPONSE_RANGE: {
                    return KvUtils.newRangeResult(op.getResponseRange(), resultFactory, kvFactory);
                }
                case RESPONSE_DELETE_RANGE: {
                    return KvUtils.newDeleteResult(op.getResponseDeleteRange(), resultFactory, kvFactory);
                }
            }
            throw new IllegalArgumentException("Unknown response type '" + op.getResponseCase() + "'");
        }));
        return result;
    }
}

