/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.versioning;

import org.apache.bookkeeper.versioning.Version;

public class LongVersion
implements Version {
    protected long version;

    public LongVersion(long v) {
        this.version = v;
    }

    @Override
    public Version.Occurred compare(Version v) {
        if (null == v) {
            throw new NullPointerException("Version is not allowed to be null.");
        }
        if (v == Version.NEW) {
            return Version.Occurred.AFTER;
        }
        if (v == Version.ANY) {
            return Version.Occurred.CONCURRENTLY;
        }
        if (!(v instanceof LongVersion)) {
            throw new IllegalArgumentException("Invalid version type");
        }
        LongVersion zv = (LongVersion)v;
        int res = Long.compare(this.version, zv.version);
        if (res == 0) {
            return Version.Occurred.CONCURRENTLY;
        }
        if (res < 0) {
            return Version.Occurred.BEFORE;
        }
        return Version.Occurred.AFTER;
    }

    public long getLongVersion() {
        return this.version;
    }

    public LongVersion setLongVersion(long v) {
        this.version = v;
        return this;
    }

    public String toString() {
        return Long.toString(this.version, 10);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongVersion)) {
            return false;
        }
        LongVersion other = (LongVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.version == other.version;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.version;
        result = result * 59 + (int)($version >>> 32 ^ $version);
        return result;
    }
}

