/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigTest
extends ZKTestCase
implements AsyncCallback.DataCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigTest.class);
    private QuorumUtil qu;
    private ZooKeeper[] zkArr;
    private ZooKeeperAdmin[] zkAdminArr;

    @BeforeEach
    public void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ReconfigTest.closeAllHandles(this.zkArr, this.zkAdminArr);
        if (this.qu != null) {
            this.qu.tearDown();
        }
    }

    public static String reconfig(ZooKeeperAdmin zkAdmin, List<String> joiningServers, List<String> leavingServers, List<String> newMembers, long fromConfig) throws KeeperException, InterruptedException {
        byte[] config = null;
        String failure = null;
        LOG.info("reconfig initiated by the test");
        for (int j = 0; j < 30; ++j) {
            try {
                config = zkAdmin.reconfigure(joiningServers, leavingServers, newMembers, fromConfig, new Stat());
                failure = null;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                failure = "client could not connect to reestablished quorum: giving up after 30+ seconds.";
            }
            catch (KeeperException.ReconfigInProgress e) {
                failure = "reconfig still in progress: giving up after 30+ seconds.";
            }
            Thread.sleep(1000L);
        }
        if (failure != null) {
            Assertions.fail(failure);
        }
        String configStr = new String(config);
        List currentServerConfigs = Arrays.stream(configStr.split("\n")).map(String::trim).filter(s -> s.startsWith("server")).map(x$0 -> new ServerConfigLine((String)x$0)).collect(Collectors.toList());
        if (joiningServers != null) {
            for (String joiner : joiningServers) {
                ServerConfigLine joinerServerConfigLine = new ServerConfigLine(joiner);
                String errorMessage = String.format("expected joiner config \"%s\" not found in current config:\n%s", joiner, configStr);
                Assertions.assertTrue((boolean)currentServerConfigs.stream().anyMatch(c -> c.equals(joinerServerConfigLine)), (String)errorMessage);
            }
        }
        if (leavingServers != null) {
            for (String leaving : leavingServers) {
                String errorMessage = String.format("leaving server \"%s\" not removed from config: \n%s", leaving, configStr);
                Assertions.assertFalse((boolean)configStr.contains(String.format("server.%s=", leaving)), (String)errorMessage);
            }
        }
        return configStr;
    }

    public static String testServerHasConfig(ZooKeeper zk, List<String> joiningServers, List<String> leavingServers) throws KeeperException, InterruptedException {
        boolean testNodeExists = false;
        byte[] config = null;
        for (int j = 0; j < 30; ++j) {
            try {
                if (!testNodeExists) {
                    ReconfigTest.createZNode(zk, "/dummy", "dummy");
                    testNodeExists = true;
                }
                zk.setData("/dummy", "dummy".getBytes(), -1);
                config = zk.getConfig(false, new Stat());
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (j < 29) {
                    Thread.sleep(1000L);
                    continue;
                }
                Assertions.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
                continue;
            }
        }
        String configStr = new String(config);
        if (joiningServers != null) {
            for (String joiner : joiningServers) {
                Assertions.assertTrue((boolean)configStr.contains(joiner), (String)("Config:<" + configStr + ">\n" + joiner));
            }
        }
        if (leavingServers != null) {
            for (String leaving : leavingServers) {
                Assertions.assertFalse((boolean)configStr.contains("server.".concat(leaving)), (String)("Config:<" + configStr + ">\n" + leaving));
            }
        }
        return configStr;
    }

    public static void testNormalOperation(ZooKeeper writer, ZooKeeper reader) throws KeeperException, InterruptedException {
        ReconfigTest.testNormalOperation(writer, reader, true);
    }

    public static void testNormalOperation(ZooKeeper writer, ZooKeeper reader, boolean initTestNodes) throws KeeperException, InterruptedException {
        boolean createNodes = initTestNodes;
        for (int j = 0; j < 30; ++j) {
            try {
                if (createNodes) {
                    ReconfigTest.createZNode(writer, "/test", "test");
                    ReconfigTest.createZNode(reader, "/dummy", "dummy");
                    createNodes = false;
                }
                String data = "test" + j;
                writer.setData("/test", data.getBytes(), -1);
                reader.setData("/dummy", "dummy".getBytes(), -1);
                byte[] res = reader.getData("/test", null, new Stat());
                Assertions.assertEquals((Object)data, (Object)new String(res));
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (j < 29) {
                    Thread.sleep(1000L);
                    continue;
                }
                Assertions.fail((String)"client could not connect to reestablished quorum: giving up after 30+ seconds.");
                continue;
            }
        }
    }

    private static void createZNode(ZooKeeper zk, String path, String data) throws KeeperException, InterruptedException {
        try {
            zk.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    private int getLeaderId(QuorumUtil qu) {
        int leaderId = 1;
        while (qu.getPeer((int)leaderId).peer.leader == null) {
            ++leaderId;
        }
        return leaderId;
    }

    public static ZooKeeper[] createHandles(QuorumUtil qu) throws IOException {
        ZooKeeper[] zkArr = new ZooKeeper[qu.ALL + 1];
        zkArr[0] = null;
        for (int i = 1; i <= qu.ALL; ++i) {
            zkArr[i] = new ZooKeeper("127.0.0.1:" + qu.getPeer((int)i).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        }
        return zkArr;
    }

    public static ZooKeeperAdmin[] createAdminHandles(QuorumUtil qu) throws IOException {
        ZooKeeperAdmin[] zkAdminArr = new ZooKeeperAdmin[qu.ALL + 1];
        zkAdminArr[0] = null;
        for (int i = 1; i <= qu.ALL; ++i) {
            zkAdminArr[i] = new ZooKeeperAdmin("127.0.0.1:" + qu.getPeer((int)i).peer.getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
            zkAdminArr[i].addAuthInfo("digest", "super:test".getBytes());
        }
        return zkAdminArr;
    }

    public static void closeAllHandles(ZooKeeper[] zkArr, ZooKeeperAdmin[] zkAdminArr) throws InterruptedException {
        if (zkArr != null) {
            for (ZooKeeper zooKeeper : zkArr) {
                if (zooKeeper == null) continue;
                zooKeeper.close();
            }
        }
        if (zkAdminArr != null) {
            for (ZooKeeper zooKeeper : zkAdminArr) {
                if (zooKeeper == null) continue;
                zooKeeper.close();
            }
        }
    }

    @Test
    public void testRemoveAddOne() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderIndex = this.getLeaderId(this.qu);
        int leavingIndex = leaderIndex == 1 ? 2 : 1;
        for (int i = 0; i < 2; ++i) {
            ZooKeeper zk1 = leavingIndex == leaderIndex ? this.zkArr[leaderIndex] : this.zkArr[leaderIndex % this.qu.ALL + 1];
            ZooKeeper zk2 = leavingIndex == leaderIndex ? this.zkArr[leaderIndex % this.qu.ALL + 1] : this.zkArr[leaderIndex];
            ZooKeeperAdmin zkAdmin1 = leavingIndex == leaderIndex ? this.zkAdminArr[leaderIndex] : this.zkAdminArr[leaderIndex % this.qu.ALL + 1];
            ZooKeeperAdmin zkAdmin2 = leavingIndex == leaderIndex ? this.zkAdminArr[leaderIndex % this.qu.ALL + 1] : this.zkAdminArr[leaderIndex];
            leavingServers.add(Integer.toString(leavingIndex));
            joiningServers.add("server." + leavingIndex + "=localhost:" + this.qu.getPeer((int)leavingIndex).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)leavingIndex).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + this.qu.getPeer((int)leavingIndex).peer.getClientPort());
            String configStr = ReconfigTest.reconfig(zkAdmin1, null, leavingServers, null, -1L);
            ReconfigTest.testServerHasConfig(zk2, null, leavingServers);
            ReconfigTest.testNormalOperation(zk2, zk1);
            QuorumVerifier qv = this.qu.getPeer((int)1).peer.configFromString(configStr);
            long version = qv.getVersion();
            try {
                ReconfigTest.reconfig(zkAdmin2, joiningServers, null, null, version + 1L);
                Assertions.fail((String)"reconfig succeeded even though version condition was incorrect!");
            }
            catch (KeeperException.BadVersionException badVersionException) {
                // empty catch block
            }
            ReconfigTest.reconfig(zkAdmin2, joiningServers, null, null, version);
            ReconfigTest.testNormalOperation(zk1, zk2);
            ReconfigTest.testServerHasConfig(zk1, joiningServers, null);
            leavingIndex = leaderIndex = this.getLeaderId(this.qu);
            leavingServers.clear();
            joiningServers.clear();
        }
    }

    @Test
    public void testRemoveAddTwo() throws Exception {
        int stayingIndex1;
        int leaderIndex;
        this.qu = new QuorumUtil(2);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leavingIndex1 = leaderIndex = this.getLeaderId(this.qu);
        int leavingIndex2 = leaderIndex == 1 ? 2 : 1;
        int stayingIndex2 = 1;
        int stayingIndex3 = 1;
        for (stayingIndex1 = 1; stayingIndex1 == leavingIndex1 || stayingIndex1 == leavingIndex2; ++stayingIndex1) {
        }
        while (stayingIndex2 == leavingIndex1 || stayingIndex2 == leavingIndex2 || stayingIndex2 == stayingIndex1) {
            ++stayingIndex2;
        }
        while (stayingIndex3 == leavingIndex1 || stayingIndex3 == leavingIndex2 || stayingIndex3 == stayingIndex1 || stayingIndex3 == stayingIndex2) {
            ++stayingIndex3;
        }
        leavingServers.add(Integer.toString(leavingIndex1));
        leavingServers.add(Integer.toString(leavingIndex2));
        joiningServers.add("server." + leavingIndex1 + "=localhost:" + this.qu.getPeer((int)leavingIndex1).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)leavingIndex1).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + this.qu.getPeer((int)leavingIndex1).peer.getClientPort());
        joiningServers.add("server." + leavingIndex2 + "=localhost:" + this.qu.getPeer((int)leavingIndex2).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)leavingIndex2).peer.getElectionAddress().getAllPorts().get(0) + ":observer;localhost:" + this.qu.getPeer((int)leavingIndex2).peer.getClientPort());
        this.qu.shutdown(leavingIndex1);
        this.qu.shutdown(leavingIndex2);
        ReconfigTest.reconfig(this.zkAdminArr[stayingIndex2], null, leavingServers, null, -1L);
        this.qu.shutdown(stayingIndex2);
        ReconfigTest.testServerHasConfig(this.zkArr[stayingIndex1], null, leavingServers);
        ReconfigTest.testServerHasConfig(this.zkArr[stayingIndex3], null, leavingServers);
        ReconfigTest.testNormalOperation(this.zkArr[stayingIndex1], this.zkArr[stayingIndex3]);
        Thread.sleep(10000L);
        try {
            ReconfigTest.reconfig(this.zkAdminArr[stayingIndex1], joiningServers, null, null, -1L);
            Assertions.fail((String)"reconfig completed successfully even though there is no quorum up in new config!");
        }
        catch (KeeperException.NewConfigNoQuorum newConfigNoQuorum) {
            // empty catch block
        }
        this.qu.restart(stayingIndex2);
        ReconfigTest.reconfig(this.zkAdminArr[stayingIndex1], joiningServers, null, null, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[stayingIndex2], this.zkArr[stayingIndex3]);
        ReconfigTest.testServerHasConfig(this.zkArr[stayingIndex2], joiningServers, null);
        this.qu.restart(leavingIndex2);
        Assertions.assertTrue((this.qu.getPeer((int)leavingIndex2).peer.getPeerState() == QuorumPeer.ServerState.OBSERVING ? 1 : 0) != 0);
        ReconfigTest.testNormalOperation(this.zkArr[stayingIndex2], this.zkArr[leavingIndex2]);
        ReconfigTest.testServerHasConfig(this.zkArr[leavingIndex2], joiningServers, null);
    }

    @Test
    public void testBulkReconfig() throws Exception {
        this.qu = new QuorumUtil(3);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> newServers = new ArrayList<String>();
        for (int i = 1; i <= 5; ++i) {
            String server = "server." + i + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":" + (i == 4 || i == 5 ? "observer" : "participant") + ";localhost:" + this.qu.getPeer((int)i).peer.getClientPort();
            newServers.add(server);
        }
        this.qu.shutdown(3);
        this.qu.shutdown(6);
        this.qu.shutdown(7);
        ReconfigTest.reconfig(this.zkAdminArr[1], null, null, newServers, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
        ReconfigTest.testServerHasConfig(this.zkArr[1], newServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[2], newServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[4], newServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[5], newServers, null);
        this.qu.shutdown(5);
        this.qu.shutdown(4);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveOneAsynchronous() throws Exception {
        this.qu = new QuorumUtil(2);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        leavingServers.add(this.getLeaderId(this.qu) == 5 ? "4" : "5");
        LinkedList results = new LinkedList();
        this.zkAdminArr[1].reconfigure(null, leavingServers, null, -1L, (AsyncCallback.DataCallback)this, results);
        LinkedList linkedList = results;
        synchronized (linkedList) {
            while (results.size() < 1) {
                results.wait();
            }
        }
        Assertions.assertEquals((int)0, (int)((Integer)results.get(0)));
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
        for (int i = 1; i <= 5; ++i) {
            ReconfigTest.testServerHasConfig(this.zkArr[i], null, leavingServers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    @Test
    public void testRoleChange() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderIndex = this.getLeaderId(this.qu);
        int changingIndex = leaderIndex == 1 ? 2 : 1;
        String newRole = "observer";
        for (int i = 0; i < 4; ++i) {
            ZooKeeper zk1 = changingIndex == leaderIndex ? this.zkArr[leaderIndex] : this.zkArr[leaderIndex % this.qu.ALL + 1];
            ZooKeeperAdmin zkAdmin1 = changingIndex == leaderIndex ? this.zkAdminArr[leaderIndex] : this.zkAdminArr[leaderIndex % this.qu.ALL + 1];
            joiningServers.add("server." + changingIndex + "=localhost:" + this.qu.getPeer((int)changingIndex).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)changingIndex).peer.getElectionAddress().getAllPorts().get(0) + ":" + newRole + ";localhost:" + this.qu.getPeer((int)changingIndex).peer.getClientPort());
            ReconfigTest.reconfig(zkAdmin1, joiningServers, null, null, -1L);
            ReconfigTest.testNormalOperation(this.zkArr[changingIndex], zk1);
            if (newRole.equals("observer")) {
                Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.observer != null && this.qu.getPeer((int)changingIndex).peer.follower == null && this.qu.getPeer((int)changingIndex).peer.leader == null ? 1 : 0) != 0);
                Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.getPeerState() == QuorumPeer.ServerState.OBSERVING ? 1 : 0) != 0);
            } else {
                Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.observer == null && (this.qu.getPeer((int)changingIndex).peer.follower != null || this.qu.getPeer((int)changingIndex).peer.leader != null) ? 1 : 0) != 0);
                Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.getPeerState() == QuorumPeer.ServerState.FOLLOWING || this.qu.getPeer((int)changingIndex).peer.getPeerState() == QuorumPeer.ServerState.LEADING ? 1 : 0) != 0);
            }
            joiningServers.clear();
            if (newRole.equals("observer")) {
                newRole = "participant";
                continue;
            }
            newRole = "observer";
            changingIndex = leaderIndex = this.getLeaderId(this.qu);
        }
    }

    @Test
    public void testPortChange() throws Exception {
        int follower2;
        int i;
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderIndex = this.getLeaderId(this.qu);
        int followerIndex = leaderIndex == 1 ? 2 : 1;
        int quorumPort = (Integer)this.qu.getPeer((int)followerIndex).peer.getQuorumAddress().getAllPorts().get(0);
        int electionPort = (Integer)this.qu.getPeer((int)followerIndex).peer.getElectionAddress().getAllPorts().get(0);
        int oldClientPort = this.qu.getPeer((int)followerIndex).peer.getClientPort();
        int newClientPort = PortAssignment.unique();
        joiningServers.add("server." + followerIndex + "=localhost:" + quorumPort + ":" + electionPort + ":participant;localhost:" + newClientPort);
        ReconfigTest.testNormalOperation(this.zkArr[followerIndex], this.zkArr[leaderIndex]);
        ReconfigTest.reconfig(this.zkAdminArr[followerIndex], joiningServers, null, null, -1L);
        try {
            for (i = 0; i < 20; ++i) {
                Thread.sleep(1000L);
                this.zkArr[followerIndex].setData("/test", "teststr".getBytes(), -1);
            }
        }
        catch (KeeperException.ConnectionLossException e) {
            Assertions.fail((String)"Existing client disconnected when client port changed!");
        }
        this.zkArr[followerIndex].close();
        this.zkArr[followerIndex] = new ZooKeeper("127.0.0.1:" + oldClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        this.zkAdminArr[followerIndex].close();
        this.zkAdminArr[followerIndex] = new ZooKeeperAdmin("127.0.0.1:" + oldClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        this.zkAdminArr[followerIndex].addAuthInfo("digest", "super:test".getBytes());
        for (i = 0; i < 10; ++i) {
            try {
                Thread.sleep(1000L);
                this.zkArr[followerIndex].setData("/test", "teststr".getBytes(), -1);
                Assertions.fail((String)"New client connected to old client port!");
                continue;
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                // empty catch block
            }
        }
        this.zkArr[followerIndex].close();
        this.zkArr[followerIndex] = new ZooKeeper("127.0.0.1:" + newClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        this.zkAdminArr[followerIndex].close();
        this.zkAdminArr[followerIndex] = new ZooKeeperAdmin("127.0.0.1:" + newClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        this.zkAdminArr[followerIndex].addAuthInfo("digest", "super:test".getBytes());
        ReconfigTest.testNormalOperation(this.zkArr[followerIndex], this.zkArr[leaderIndex]);
        ReconfigTest.testServerHasConfig(this.zkArr[followerIndex], joiningServers, null);
        Assertions.assertEquals((int)newClientPort, (int)this.qu.getPeer((int)followerIndex).peer.getClientPort());
        joiningServers.clear();
        int newQuorumPort = PortAssignment.unique();
        joiningServers.add("server." + leaderIndex + "=localhost:" + newQuorumPort + ":" + this.qu.getPeer((int)leaderIndex).peer.getElectionAddress().getAllPorts().get(0) + ":participant;localhost:" + this.qu.getPeer((int)leaderIndex).peer.getClientPort());
        ReconfigTest.reconfig(this.zkAdminArr[leaderIndex], joiningServers, null, null, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[followerIndex], this.zkArr[leaderIndex]);
        Assertions.assertEquals((int)((Integer)this.qu.getPeer((int)leaderIndex).peer.getQuorumAddress().getAllPorts().get(0)), (int)newQuorumPort);
        joiningServers.clear();
        for (int i2 = 1; i2 <= 3; ++i2) {
            joiningServers.add("server." + i2 + "=localhost:" + this.qu.getPeer((int)i2).peer.getQuorumAddress().getAllPorts().get(0) + ":" + PortAssignment.unique() + ":participant;localhost:" + this.qu.getPeer((int)i2).peer.getClientPort());
        }
        ReconfigTest.reconfig(this.zkAdminArr[1], joiningServers, null, null, -1L);
        leaderIndex = this.getLeaderId(this.qu);
        int follower1 = leaderIndex == 1 ? 2 : 1;
        for (follower2 = 1; follower2 == leaderIndex || follower2 == follower1; ++follower2) {
        }
        this.qu.shutdown(this.getLeaderId(this.qu));
        ReconfigTest.testNormalOperation(this.zkArr[follower2], this.zkArr[follower1]);
        ReconfigTest.testServerHasConfig(this.zkArr[follower1], joiningServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[follower2], joiningServers, null);
    }

    @Test
    public void testPortChangeToBlockedPortFollower() throws Exception {
        this.testPortChangeToBlockedPort(false);
    }

    @Test
    public void testPortChangeToBlockedPortLeader() throws Exception {
        this.testPortChangeToBlockedPort(true);
    }

    private void testPortChangeToBlockedPort(boolean testLeader) throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderIndex = this.getLeaderId(this.qu);
        int followerIndex = leaderIndex == 1 ? 2 : 1;
        int serverIndex = testLeader ? leaderIndex : followerIndex;
        int reconfigIndex = testLeader ? followerIndex : leaderIndex;
        int quorumPort = (Integer)this.qu.getPeer((int)serverIndex).peer.getQuorumAddress().getAllPorts().get(0);
        int electionPort = (Integer)this.qu.getPeer((int)serverIndex).peer.getElectionAddress().getAllPorts().get(0);
        int oldClientPort = this.qu.getPeer((int)serverIndex).peer.getClientPort();
        int newClientPort = PortAssignment.unique();
        try (ServerSocket ss = new ServerSocket();){
            ss.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), newClientPort));
            joiningServers.add("server." + serverIndex + "=localhost:" + quorumPort + ":" + electionPort + ":participant;localhost:" + newClientPort);
            ReconfigTest.testNormalOperation(this.zkArr[followerIndex], this.zkArr[leaderIndex]);
            ReconfigTest.reconfig(this.zkAdminArr[reconfigIndex], joiningServers, null, null, -1L);
            Thread.sleep(1000L);
            this.zkArr[serverIndex].close();
            this.zkArr[serverIndex] = new ZooKeeper("127.0.0.1:" + newClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
            this.zkAdminArr[serverIndex].close();
            this.zkAdminArr[serverIndex] = new ZooKeeperAdmin("127.0.0.1:" + newClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
            try {
                Thread.sleep(1000L);
                this.zkArr[serverIndex].setData("/test", "teststr".getBytes(), -1);
                Assertions.fail((String)"New client connected to new client port!");
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException throwable) {
                // empty catch block
            }
            try (ServerSocket ss2 = new ServerSocket();){
                ss2.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), oldClientPort));
            }
            joiningServers.clear();
            joiningServers.add("server." + serverIndex + "=localhost:" + quorumPort + ":" + electionPort + ":participant;localhost:" + oldClientPort);
            ReconfigTest.reconfig(this.zkAdminArr[reconfigIndex], joiningServers, null, null, -1L);
            this.zkArr[serverIndex].close();
            this.zkArr[serverIndex] = new ZooKeeper("127.0.0.1:" + oldClientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
            ReconfigTest.testNormalOperation(this.zkArr[followerIndex], this.zkArr[leaderIndex]);
            ReconfigTest.testServerHasConfig(this.zkArr[serverIndex], joiningServers, null);
            Assertions.assertEquals((int)oldClientPort, (int)this.qu.getPeer((int)serverIndex).peer.getClientPort());
        }
    }

    @Test
    public void testUnspecifiedClientAddress() throws Exception {
        int[] ports = new int[]{PortAssignment.unique(), PortAssignment.unique(), PortAssignment.unique()};
        String server = "server.0=localhost:" + ports[0] + ":" + ports[1] + ";" + ports[2];
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, server);
        Assertions.assertEquals((Object)qs.clientAddr.getHostString(), (Object)"0.0.0.0");
        Assertions.assertEquals((int)qs.clientAddr.getPort(), (int)ports[2]);
    }

    @Test
    public void testQuorumSystemChange() throws Exception {
        int i;
        this.qu = new QuorumUtil(3);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> members = new ArrayList<String>();
        members.add("group.1=3:4:5");
        members.add("group.2=1:2");
        members.add("weight.1=0");
        members.add("weight.2=0");
        members.add("weight.3=1");
        members.add("weight.4=1");
        members.add("weight.5=1");
        for (i = 1; i <= 5; ++i) {
            members.add("server." + i + "=127.0.0.1:" + this.qu.getPeer((int)i).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)i).peer.getElectionAddress().getAllPorts().get(0) + ";127.0.0.1:" + this.qu.getPeer((int)i).peer.getClientPort());
        }
        ReconfigTest.reconfig(this.zkAdminArr[1], null, null, members, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[2], this.zkArr[3]);
        ReconfigTest.testNormalOperation(this.zkArr[4], this.zkArr[5]);
        for (i = 1; i <= 5; ++i) {
            if (this.qu.getPeer((int)i).peer.getQuorumVerifier() instanceof QuorumHierarchical) continue;
            Assertions.fail((String)("peer " + i + " doesn't think the quorum system is Hieararchical!"));
        }
        this.qu.shutdown(1);
        this.qu.shutdown(2);
        this.qu.shutdown(3);
        this.qu.shutdown(7);
        this.qu.shutdown(6);
        ReconfigTest.testNormalOperation(this.zkArr[4], this.zkArr[5]);
        this.qu.restart(1);
        this.qu.restart(2);
        members.clear();
        for (i = 1; i <= 3; ++i) {
            members.add("server." + i + "=127.0.0.1:" + this.qu.getPeer((int)i).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)i).peer.getElectionAddress().getAllPorts().get(0) + ";127.0.0.1:" + this.qu.getPeer((int)i).peer.getClientPort());
        }
        ReconfigTest.reconfig(this.zkAdminArr[1], null, null, members, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
        this.qu.shutdown(4);
        this.qu.shutdown(5);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
        for (i = 1; i <= 2; ++i) {
            if (this.qu.getPeer((int)i).peer.getQuorumVerifier() instanceof QuorumMaj) continue;
            Assertions.fail((String)("peer " + i + " doesn't think the quorum system is a majority quorum system!"));
        }
    }

    @Test
    public void testInitialConfigHasPositiveVersion() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[2]);
        for (int i = 1; i < 4; ++i) {
            String configStr = ReconfigTest.testServerHasConfig(this.zkArr[i], null, null);
            QuorumVerifier qv = this.qu.getPeer((int)i).peer.configFromString(configStr);
            long version = qv.getVersion();
            Assertions.assertTrue((version == 0x100000000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testJMXBeanAfterRemoveAddOne() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leavingIndex = 1;
        int replica2 = 2;
        QuorumPeer peer2 = this.qu.getPeer((int)replica2).peer;
        QuorumPeer.QuorumServer leavingQS2 = (QuorumPeer.QuorumServer)peer2.getView().get(leavingIndex);
        String remotePeerBean2 = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + replica2 + ",name1=replica." + leavingIndex;
        this.assertRemotePeerMXBeanAttributes(leavingQS2, remotePeerBean2);
        int replica3 = 3;
        QuorumPeer peer3 = this.qu.getPeer((int)replica3).peer;
        QuorumPeer.QuorumServer leavingQS3 = (QuorumPeer.QuorumServer)peer3.getView().get(leavingIndex);
        String remotePeerBean3 = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + replica3 + ",name1=replica." + leavingIndex;
        this.assertRemotePeerMXBeanAttributes(leavingQS3, remotePeerBean3);
        ZooKeeper zk = this.zkArr[leavingIndex];
        ZooKeeperAdmin zkAdmin = this.zkAdminArr[leavingIndex];
        leavingServers.add(Integer.toString(leavingIndex));
        joiningServers.add("server." + leavingIndex + "=127.0.0.1:" + this.qu.getPeer((int)leavingIndex).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)leavingIndex).peer.getElectionAddress().getAllPorts().get(0) + ":participant;127.0.0.1:" + this.qu.getPeer((int)leavingIndex).peer.getClientPort());
        ReconfigTest.reconfig(zkAdmin, null, leavingServers, null, -1L);
        QuorumPeer removedPeer = this.qu.getPeer((int)leavingIndex).peer;
        String localPeerBean = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + leavingIndex + ",name1=replica." + leavingIndex;
        this.assertLocalPeerMXBeanAttributes(removedPeer, localPeerBean, false);
        JMXEnv.ensureNone(remotePeerBean2);
        JMXEnv.ensureNone(remotePeerBean3);
        ReconfigTest.reconfig(zkAdmin, joiningServers, null, null, -1L);
        this.assertLocalPeerMXBeanAttributes(removedPeer, localPeerBean, true);
        leavingQS2 = (QuorumPeer.QuorumServer)peer2.getView().get(leavingIndex);
        this.assertRemotePeerMXBeanAttributes(leavingQS2, remotePeerBean2);
        leavingQS3 = (QuorumPeer.QuorumServer)peer3.getView().get(leavingIndex);
        this.assertRemotePeerMXBeanAttributes(leavingQS3, remotePeerBean3);
    }

    @Test
    public void testJMXBeanAfterRoleChange() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> joiningServers = new ArrayList<String>();
        int changingIndex = 1;
        int replica2 = 2;
        QuorumPeer peer2 = this.qu.getPeer((int)replica2).peer;
        QuorumPeer.QuorumServer changingQS2 = (QuorumPeer.QuorumServer)peer2.getView().get(changingIndex);
        String remotePeerBean2 = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + replica2 + ",name1=replica." + changingIndex;
        this.assertRemotePeerMXBeanAttributes(changingQS2, remotePeerBean2);
        int replica3 = 3;
        QuorumPeer peer3 = this.qu.getPeer((int)replica3).peer;
        QuorumPeer.QuorumServer changingQS3 = (QuorumPeer.QuorumServer)peer3.getView().get(changingIndex);
        String remotePeerBean3 = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + replica3 + ",name1=replica." + changingIndex;
        this.assertRemotePeerMXBeanAttributes(changingQS3, remotePeerBean3);
        String newRole = "observer";
        ZooKeeper zk = this.zkArr[changingIndex];
        ZooKeeperAdmin zkAdmin = this.zkAdminArr[changingIndex];
        joiningServers.add("server." + changingIndex + "=127.0.0.1:" + this.qu.getPeer((int)changingIndex).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)changingIndex).peer.getElectionAddress().getAllPorts().get(0) + ":" + newRole + ";127.0.0.1:" + this.qu.getPeer((int)changingIndex).peer.getClientPort());
        ReconfigTest.reconfig(zkAdmin, joiningServers, null, null, -1L);
        ReconfigTest.testNormalOperation(this.zkArr[changingIndex], zk);
        Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.observer != null && this.qu.getPeer((int)changingIndex).peer.follower == null && this.qu.getPeer((int)changingIndex).peer.leader == null ? 1 : 0) != 0);
        Assertions.assertTrue((this.qu.getPeer((int)changingIndex).peer.getPeerState() == QuorumPeer.ServerState.OBSERVING ? 1 : 0) != 0);
        QuorumPeer qp = this.qu.getPeer((int)changingIndex).peer;
        String localPeerBeanName = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + changingIndex + ",name1=replica." + changingIndex;
        this.assertLocalPeerMXBeanAttributes(qp, localPeerBeanName, true);
        changingQS2 = (QuorumPeer.QuorumServer)peer2.getView().get(changingIndex);
        this.assertRemotePeerMXBeanAttributes(changingQS2, remotePeerBean2);
        changingQS3 = (QuorumPeer.QuorumServer)peer3.getView().get(changingIndex);
        this.assertRemotePeerMXBeanAttributes(changingQS3, remotePeerBean3);
    }

    @Test
    public void testReconfigEnablemntWithRollingRestart() throws Exception {
        QuorumPeerConfig.setReconfigEnabled((boolean)false);
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        this.zkArr = ReconfigTest.createHandles(this.qu);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[1], true);
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        for (int i = 1; i < 4; ++i) {
            Assertions.assertFalse((boolean)this.qu.getPeer((int)i).peer.isReconfigEnabled(), (String)("dynamic reconfig was not disabled before stopping server " + i));
            this.qu.shutdown(i);
            this.qu.restart(i);
            Assertions.assertTrue((boolean)this.qu.getPeer((int)i).peer.isReconfigEnabled(), (String)("dynamic reconfig is not enabled for the restarted server " + i));
            ReconfigTest.testNormalOperation(this.zkArr[i], this.zkArr[i % 3 + 1], false);
        }
        ArrayList<String> leavingServers = new ArrayList<String>();
        ArrayList<String> joiningServers = new ArrayList<String>();
        leavingServers.add("2");
        joiningServers.add(String.format("server.2=localhost:%d:%d:participant;localhost:%d", this.qu.getPeer((int)2).peer.getQuorumAddress().getAllPorts().get(0), this.qu.getPeer((int)2).peer.getElectionAddress().getAllPorts().get(0), this.qu.getPeer((int)2).peer.getClientPort()));
        this.zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        String configStr = ReconfigTest.reconfig(this.zkAdminArr[1], null, leavingServers, null, -1L);
        ReconfigTest.testServerHasConfig(this.zkArr[3], null, leavingServers);
        ReconfigTest.testNormalOperation(this.zkArr[1], this.zkArr[3], false);
        QuorumVerifier qv = this.qu.getPeer((int)1).peer.configFromString(configStr);
        long version = qv.getVersion();
        ReconfigTest.reconfig(this.zkAdminArr[3], joiningServers, null, null, version);
        ReconfigTest.testServerHasConfig(this.zkArr[1], joiningServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[2], joiningServers, null);
        ReconfigTest.testServerHasConfig(this.zkArr[3], joiningServers, null);
        ReconfigTest.testNormalOperation(this.zkArr[3], this.zkArr[1], false);
    }

    private void assertLocalPeerMXBeanAttributes(QuorumPeer qp, String beanName, Boolean isPartOfEnsemble) throws Exception {
        Assertions.assertEquals((Object)qp.getLearnerType().name(), (Object)JMXEnv.ensureBeanAttribute(beanName, "LearnerType"), (String)"Mismatches LearnerType!");
        Assertions.assertEquals((Object)(qp.getClientAddress().getHostString() + ":" + qp.getClientAddress().getPort()), (Object)JMXEnv.ensureBeanAttribute(beanName, "ClientAddress"), (String)"Mismatches ClientAddress!");
        Assertions.assertEquals((Object)(qp.getElectionAddress().getOne().getHostString() + ":" + qp.getElectionAddress().getOne().getPort()), (Object)JMXEnv.ensureBeanAttribute(beanName, "ElectionAddress"), (String)"Mismatches LearnerType!");
        Assertions.assertEquals((Object)isPartOfEnsemble, (Object)JMXEnv.ensureBeanAttribute(beanName, "PartOfEnsemble"), (String)"Mismatches PartOfEnsemble!");
        Assertions.assertEquals((Object)qp.getQuorumVerifier().getVersion(), (Object)JMXEnv.ensureBeanAttribute(beanName, "ConfigVersion"), (String)"Mismatches ConfigVersion!");
        Assertions.assertEquals((Object)qp.getQuorumVerifier().toString(), (Object)JMXEnv.ensureBeanAttribute(beanName, "QuorumSystemInfo"), (String)"Mismatches QuorumSystemInfo!");
    }

    String getAddrPortFromBean(String beanName, String attribute) throws Exception {
        String name = (String)JMXEnv.ensureBeanAttribute(beanName, attribute);
        if (!name.contains(":")) {
            return name;
        }
        return this.getNumericalAddrPort(name);
    }

    String getNumericalAddrPort(String name) throws UnknownHostException {
        String port = name.split(":")[1];
        String addr = name.split(":")[0];
        addr = InetAddress.getByName(addr).getHostAddress();
        return addr + ":" + port;
    }

    private void assertRemotePeerMXBeanAttributes(QuorumPeer.QuorumServer qs, String beanName) throws Exception {
        Assertions.assertEquals((Object)qs.type.name(), (Object)JMXEnv.ensureBeanAttribute(beanName, "LearnerType"), (String)"Mismatches LearnerType!");
        Assertions.assertEquals((Object)this.getNumericalAddrPort(qs.clientAddr.getHostString() + ":" + qs.clientAddr.getPort()), (Object)this.getAddrPortFromBean(beanName, "ClientAddress"), (String)"Mismatches ClientAddress!");
        Assertions.assertEquals((Object)this.getNumericalAddrPort(qs.electionAddr.getOne().getHostString() + ":" + qs.electionAddr.getOne().getPort()), (Object)this.getAddrPortFromBean(beanName, "ElectionAddress"), (String)"Mismatches ElectionAddress!");
        Assertions.assertEquals((Object)this.getNumericalAddrPort(qs.addr.getOne().getHostString() + ":" + qs.addr.getOne().getPort()), (Object)this.getAddrPortFromBean(beanName, "QuorumAddress"), (String)"Mismatches QuorumAddress!");
    }

    private static class ServerConfigLine {
        private final int serverId;
        private Integer clientPort;
        private final Map<String, Set<Integer>> quorumPorts = new HashMap<String, Set<Integer>>();
        private final Map<String, Set<Integer>> electionPorts = new HashMap<String, Set<Integer>>();

        private ServerConfigLine(String configLine) {
            String[] parts = configLine.trim().split("=");
            this.serverId = Integer.parseInt(parts[0].split("\\.")[1]);
            String[] serverConfig = parts[1].split(";");
            String[] serverAddresses = serverConfig[0].split("\\|");
            if (serverConfig.length > 1) {
                String[] clientParts = serverConfig[1].split(":");
                this.clientPort = clientParts.length > 1 ? Integer.valueOf(Integer.parseInt(clientParts[1])) : Integer.valueOf(Integer.parseInt(clientParts[0]));
            }
            for (String addr : serverAddresses) {
                String[] ports;
                String serverHost;
                if (addr.contains("[")) {
                    serverHost = addr.substring(1, addr.indexOf("]"));
                    ports = addr.substring(addr.indexOf("]") + 2).split(":");
                } else {
                    serverHost = addr.substring(0, addr.indexOf(":"));
                    ports = addr.substring(addr.indexOf(":") + 1).split(":");
                }
                this.quorumPorts.computeIfAbsent(serverHost, k -> new HashSet()).add(Integer.parseInt(ports[0]));
                if (ports.length <= 1) continue;
                this.electionPorts.computeIfAbsent(serverHost, k -> new HashSet()).add(Integer.parseInt(ports[1]));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServerConfigLine that = (ServerConfigLine)o;
            return this.serverId == that.serverId && Objects.equals(this.clientPort, that.clientPort) && this.quorumPorts.equals(that.quorumPorts) && this.electionPorts.equals(that.electionPorts);
        }

        public int hashCode() {
            return Objects.hash(this.serverId, this.clientPort, this.quorumPorts, this.electionPorts);
        }
    }
}

