/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.utils.ListenableFutureRpcProcessor;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;

class TxnRequestProcessor<RespT>
extends ListenableFutureRpcProcessor<TxnRequest, TxnResponse, RespT> {
    private final TxnRequest request;
    private final Function<TxnResponse, RespT> responseFunc;

    public static <T> TxnRequestProcessor<T> of(TxnRequest request, Function<TxnResponse, T> responseFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        return new TxnRequestProcessor<T>(request, responseFunc, channel, executor, backoffPolicy);
    }

    private TxnRequestProcessor(TxnRequest request, Function<TxnResponse, RespT> respFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        super(channel, executor, backoffPolicy);
        this.request = request;
        this.responseFunc = respFunc;
    }

    @Override
    protected TxnRequest createRequest() {
        return this.request;
    }

    @Override
    protected ListenableFuture<TxnResponse> sendRPC(StorageServerChannel rsChannel, TxnRequest request) {
        return rsChannel.getTableService().txn(request);
    }

    @Override
    protected RespT processResponse(TxnResponse response) throws Exception {
        if (StatusCode.SUCCESS == response.getHeader().getCode()) {
            return this.responseFunc.apply(response);
        }
        throw new InternalServerException("Encountered internal server exception : code = " + (Object)((Object)response.getHeader().getCode()));
    }
}

