/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.SortedLogRecovery;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerLogger {
    private static final Logger log = LoggerFactory.getLogger(TabletServerLogger.class);
    private final AtomicLong logSizeEstimate = new AtomicLong();
    private final long maxSize;
    private final long maxAge;
    private final TabletServer tserver;
    private DfsLogger currentLog = null;
    private final SynchronousQueue<Object> nextLog = new SynchronousQueue();
    private ThreadPoolExecutor nextLogMaker;
    private final AtomicInteger logId = new AtomicInteger();
    private final ReentrantReadWriteLock logIdLock = new ReentrantReadWriteLock();
    private final AtomicLong syncCounter;
    private final AtomicLong flushCounter;
    private long createTime = 0L;
    private final Retry.RetryFactory createRetryFactory;
    private Retry createRetry = null;
    private final Retry.RetryFactory writeRetryFactory;

    private static void testLockAndRun(ReadWriteLock rwlock, TestCallWithWriteLock code) throws IOException {
        block7: {
            rwlock.readLock().lock();
            try {
                if (!code.test()) break block7;
                rwlock.readLock().unlock();
                rwlock.writeLock().lock();
                try {
                    if (code.test()) {
                        code.withWriteLock();
                    }
                }
                finally {
                    rwlock.readLock().lock();
                    rwlock.writeLock().unlock();
                }
            }
            finally {
                rwlock.readLock().unlock();
            }
        }
    }

    public TabletServerLogger(TabletServer tserver, long maxSize, AtomicLong syncCounter, AtomicLong flushCounter, Retry.RetryFactory createRetryFactory, Retry.RetryFactory writeRetryFactory, long maxAge) {
        this.tserver = tserver;
        this.maxSize = maxSize;
        this.syncCounter = syncCounter;
        this.flushCounter = flushCounter;
        this.createRetryFactory = createRetryFactory;
        this.createRetry = null;
        this.writeRetryFactory = writeRetryFactory;
        this.maxAge = maxAge;
    }

    private DfsLogger initializeLoggers(final AtomicInteger logIdOut) throws IOException {
        final AtomicReference result = new AtomicReference();
        TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                result.set(TabletServerLogger.this.currentLog);
                if (TabletServerLogger.this.currentLog != null) {
                    logIdOut.set(TabletServerLogger.this.logId.get());
                }
                return TabletServerLogger.this.currentLog == null;
            }

            @Override
            void withWriteLock() {
                TabletServerLogger.this.createLogger();
                result.set(TabletServerLogger.this.currentLog);
                if (TabletServerLogger.this.currentLog != null) {
                    logIdOut.set(TabletServerLogger.this.logId.get());
                } else {
                    logIdOut.set(-1);
                }
            }
        });
        return (DfsLogger)result.get();
    }

    public String getLogFile() {
        this.logIdLock.readLock().lock();
        try {
            if (this.currentLog == null) {
                String string = null;
                return string;
            }
            String string = this.currentLog.getFileName();
            return string;
        }
        finally {
            this.logIdLock.readLock().unlock();
        }
    }

    private synchronized void createLogger() {
        if (!this.logIdLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("createLoggers should be called with write lock held!");
        }
        if (this.currentLog != null) {
            throw new IllegalStateException("createLoggers should not be called when current log is set");
        }
        try {
            this.startLogMaker();
            Object next = this.nextLog.take();
            if (next instanceof Exception) {
                throw (Exception)next;
            }
            if (next instanceof DfsLogger) {
                this.currentLog = (DfsLogger)next;
                this.logId.incrementAndGet();
                log.info("Using next log {}", (Object)this.currentLog.getFileName());
                if (this.createRetry != null) {
                    this.createRetry = null;
                }
                this.createTime = System.currentTimeMillis();
                return;
            }
            throw new RuntimeException("Error: unexpected type seen: " + String.valueOf(next));
        }
        catch (Exception t) {
            if (this.createRetry == null) {
                this.createRetry = this.createRetryFactory.createRetry();
            }
            if (this.createRetry.canRetry()) {
                this.createRetry.useRetry();
                try {
                    this.createRetry.waitForNextAttempt(log, "create new WAL ");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            } else {
                Halt.halt((int)1, (String)"Experienced too many errors creating WALs, giving up", (Throwable)t);
            }
            throw new RuntimeException(t);
        }
    }

    private synchronized void startLogMaker() {
        if (this.nextLogMaker != null) {
            return;
        }
        this.nextLogMaker = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.TSERVER_WAL_CREATOR_POOL).numCoreThreads(1).build();
        this.nextLogMaker.execute(new Runnable(){

            @Override
            public void run() {
                DfsLogger.ServerResources conf = TabletServerLogger.this.tserver.getServerConfig();
                VolumeManager fs = conf.getVolumeManager();
                while (!TabletServerLogger.this.nextLogMaker.isShutdown()) {
                    log.debug("Creating next WAL");
                    DfsLogger alog = null;
                    try {
                        alog = new DfsLogger(TabletServerLogger.this.tserver.getContext(), conf, TabletServerLogger.this.syncCounter, TabletServerLogger.this.flushCounter);
                        alog.open(TabletServerLogger.this.tserver.getClientAddressString());
                    }
                    catch (Exception t) {
                        log.error("Failed to open WAL", (Throwable)t);
                        if (alog != null) {
                            try {
                                alog.close();
                            }
                            catch (Exception e) {
                                log.error("Failed to close WAL after it failed to open", (Throwable)e);
                            }
                            try {
                                Path path = alog.getPath();
                                if (fs.exists(path)) {
                                    fs.delete(path);
                                }
                            }
                            catch (Exception e) {
                                log.warn("Failed to delete a WAL that failed to open", (Throwable)e);
                            }
                        }
                        try {
                            TabletServerLogger.this.nextLog.offer(t, 12L, TimeUnit.HOURS);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            throw new Error("Next log maker thread interrupted", ex);
                        }
                    }
                    String fileName = alog.getFileName();
                    log.debug("Created next WAL {}", (Object)fileName);
                    try {
                        TabletServerLogger.this.tserver.addNewLogMarker(alog);
                    }
                    catch (Exception t) {
                        log.error("Failed to add new WAL marker for " + fileName, (Throwable)t);
                        try {
                            alog.close();
                        }
                        catch (Exception e) {
                            log.error("Failed to close WAL after it failed to open", (Throwable)e);
                        }
                        try {
                            TabletServerLogger.this.tserver.walogClosed(alog);
                        }
                        catch (Exception e) {
                            log.error("Failed to close WAL that failed to open: " + fileName, (Throwable)e);
                        }
                        try {
                            TabletServerLogger.this.nextLog.offer(t, 12L, TimeUnit.HOURS);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            throw new Error("Next log maker thread interrupted", ex);
                        }
                    }
                    try {
                        while (!TabletServerLogger.this.nextLog.offer(alog, 12L, TimeUnit.HOURS)) {
                            log.info("Our WAL was not used for 12 hours: {}", (Object)fileName);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new Error("Next log maker thread interrupted", e);
                    }
                }
            }
        });
    }

    private synchronized void close() throws IOException {
        block9: {
            if (!this.logIdLock.isWriteLockedByCurrentThread()) {
                throw new IllegalStateException("close should be called with write lock held!");
            }
            try {
                if (this.currentLog == null) break block9;
                try {
                    this.currentLog.close();
                }
                catch (DfsLogger.LogClosedException logClosedException) {
                }
                catch (Exception ex) {
                    log.error("Unable to cleanly close log " + this.currentLog.getFileName() + ": " + String.valueOf(ex), (Throwable)ex);
                }
                finally {
                    this.tserver.walogClosed(this.currentLog);
                    this.currentLog = null;
                    this.logSizeEstimate.set(0L);
                }
            }
            catch (Exception t) {
                throw new IOException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Collection<CommitSession> sessions, boolean mincFinish, Writer writer, Retry writeRetry) throws IOException {
        int currentLogId = this.logId.get();
        boolean success = false;
        while (!success) {
            Exception sawWriteFailure = null;
            try {
                AtomicInteger currentId = new AtomicInteger(-1);
                DfsLogger copy = this.initializeLoggers(currentId);
                currentLogId = currentId.get();
                if (currentLogId == this.logId.get()) {
                    for (CommitSession commitSession : sessions) {
                        if (!commitSession.beginUpdatingLogsUsed(copy, mincFinish)) continue;
                        try {
                            this.write(Collections.singletonList(commitSession), false, logger -> logger.defineTablet(commitSession), writeRetry);
                        }
                        finally {
                            commitSession.finishUpdatingLogsUsed();
                        }
                        KeyExtent extent = commitSession.getExtent();
                        boolean replicationEnabled = ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tserver.getTableConfiguration(extent));
                        if (!replicationEnabled) continue;
                        Replication.Status status = StatusUtil.openWithUnknownLength((long)System.currentTimeMillis());
                        log.debug("Writing " + ProtobufUtil.toString((GeneratedMessageV3)status) + " to metadata table for " + copy.getFileName());
                        ReplicationTableUtil.updateFiles((ClientContext)this.tserver.getContext(), (KeyExtent)commitSession.getExtent(), (String)copy.getFileName(), (Replication.Status)status);
                    }
                }
                if (currentLogId == this.logId.get()) {
                    DfsLogger.LoggerOperation lop = writer.write(copy);
                    lop.await();
                    success = currentLogId == this.logId.get();
                }
            }
            catch (ClosedChannelException | DfsLogger.LogClosedException ex) {
                writeRetry.logRetry(log, "Logs closed while writing", (Throwable)ex);
            }
            catch (Exception t) {
                writeRetry.logRetry(log, "Failed to write to WAL", (Throwable)t);
                sawWriteFailure = t;
                try {
                    writeRetry.waitForNextAttempt(log, "write to WAL");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            finally {
                writeRetry.useRetry();
            }
            final int finalCurrent = currentLogId;
            if (success) continue;
            ServiceLock tabletServerLock = this.tserver.getLock();
            if (sawWriteFailure != null) {
                log.info("WAL write failure, validating server lock in ZooKeeper", (Throwable)sawWriteFailure);
                if (tabletServerLock == null || !tabletServerLock.verifyLockAtSource()) {
                    Halt.halt((int)-1, (String)"Writing to WAL has failed and TabletServer lock does not exist", (Throwable)sawWriteFailure);
                }
            }
            TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

                @Override
                boolean test() {
                    return finalCurrent == TabletServerLogger.this.logId.get();
                }

                @Override
                void withWriteLock() throws IOException {
                    TabletServerLogger.this.close();
                }
            });
        }
        this.logSizeEstimate.addAndGet(12L);
        TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                return TabletServerLogger.this.logSizeEstimate.get() > TabletServerLogger.this.maxSize || System.currentTimeMillis() - TabletServerLogger.this.createTime > TabletServerLogger.this.maxAge;
            }

            @Override
            void withWriteLock() throws IOException {
                TabletServerLogger.this.close();
            }
        });
    }

    public void log(CommitSession commitSession, Mutation m, Durability durability) throws IOException {
        if (durability == Durability.DEFAULT || durability == Durability.NONE) {
            throw new IllegalArgumentException("Unexpected durability " + String.valueOf(durability));
        }
        this.write(Collections.singletonList(commitSession), false, logger -> logger.log(commitSession, m, durability), this.writeRetryFactory.createRetry());
        this.logSizeEstimate.addAndGet(m.numBytes());
    }

    public void logManyTablets(Map<CommitSession, TabletMutations> loggables) throws IOException {
        if (loggables.isEmpty()) {
            return;
        }
        this.write(loggables.keySet(), false, logger -> logger.logManyTablets(loggables.values()), this.writeRetryFactory.createRetry());
        for (TabletMutations entry : loggables.values()) {
            if (entry.getMutations().size() < 1) {
                throw new IllegalArgumentException("logManyTablets: logging empty mutation list");
            }
            for (Mutation m : entry.getMutations()) {
                this.logSizeEstimate.addAndGet(m.numBytes());
            }
        }
    }

    public void minorCompactionFinished(CommitSession commitSession, long walogSeq, Durability durability) throws IOException {
        this.write(Collections.singletonList(commitSession), true, logger -> logger.minorCompactionFinished(walogSeq, commitSession.getLogId(), durability), this.writeRetryFactory.createRetry());
    }

    public long minorCompactionStarted(CommitSession commitSession, long seq, String fullyQualifiedFileName, Durability durability) throws IOException {
        this.write(Collections.singletonList(commitSession), false, logger -> logger.minorCompactionStarted(seq, commitSession.getLogId(), fullyQualifiedFileName, durability), this.writeRetryFactory.createRetry());
        return seq;
    }

    public void recover(ServerContext context, KeyExtent extent, List<Path> recoveryDirs, Set<String> tabletFiles, MutationReceiver mr) throws IOException {
        try {
            SortedLogRecovery recovery = new SortedLogRecovery(context);
            recovery.recover(extent, recoveryDirs, tabletFiles, mr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static abstract class TestCallWithWriteLock {
        private TestCallWithWriteLock() {
        }

        abstract boolean test();

        abstract void withWriteLock() throws IOException;
    }

    static interface Writer {
        public DfsLogger.LoggerOperation write(DfsLogger var1) throws Exception;
    }
}

