/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.logging;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyRepo;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.StackOverflowException;
import org.apache.accumulo.core.fate.TStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateLogger {
    private static final String PREFIX = "org.apache.accumulo.fate.";
    private static final Logger storeLog = LoggerFactory.getLogger((String)"org.apache.accumulo.fate.store");

    public static <T> TStore<T> wrap(final TStore<T> store, final Function<Repo<T>, String> toLogString) {
        return new TStore<T>(){

            @Override
            public long reserve() {
                return store.reserve();
            }

            @Override
            public void reserve(long tid) {
                store.reserve(tid);
            }

            @Override
            public boolean tryReserve(long tid) {
                return store.tryReserve(tid);
            }

            @Override
            public void unreserve(long tid, long deferTime, TimeUnit deferTimeUnit) {
                store.unreserve(tid, deferTime, deferTimeUnit);
            }

            @Override
            public List<ReadOnlyRepo<T>> getStack(long tid) {
                return store.getStack(tid);
            }

            @Override
            public ReadOnlyTStore.TStatus getStatus(long tid) {
                return store.getStatus(tid);
            }

            @Override
            public ReadOnlyTStore.TStatus waitForStatusChange(long tid, EnumSet<ReadOnlyTStore.TStatus> expected) {
                return store.waitForStatusChange(tid, expected);
            }

            @Override
            public Serializable getTransactionInfo(long tid, Fate.TxInfo txInfo) {
                return store.getTransactionInfo(tid, txInfo);
            }

            @Override
            public List<Long> list() {
                return store.list();
            }

            @Override
            public long timeCreated(long tid) {
                return store.timeCreated(tid);
            }

            @Override
            public long create() {
                long tid = store.create();
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} created fate transaction", (Object)FateTxId.formatTid(tid));
                }
                return tid;
            }

            @Override
            public Repo<T> top(long tid) {
                return store.top(tid);
            }

            @Override
            public void push(long tid, Repo<T> repo) throws StackOverflowException {
                store.push(tid, repo);
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} pushed {}", (Object)FateTxId.formatTid(tid), toLogString.apply(repo));
                }
            }

            @Override
            public void pop(long tid) {
                store.pop(tid);
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} popped", (Object)FateTxId.formatTid(tid));
                }
            }

            @Override
            public void setStatus(long tid, ReadOnlyTStore.TStatus status) {
                store.setStatus(tid, status);
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} setStatus to {}", (Object)FateTxId.formatTid(tid), (Object)status);
                }
            }

            @Override
            public void setTransactionInfo(long tid, Fate.TxInfo txInfo, Serializable val) {
                store.setTransactionInfo(tid, txInfo, val);
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} setting {} to {}", new Object[]{FateTxId.formatTid(tid), txInfo, val});
                }
            }

            @Override
            public void delete(long tid) {
                store.delete(tid);
                if (storeLog.isTraceEnabled()) {
                    storeLog.trace("{} deleted fate transaction", (Object)FateTxId.formatTid(tid));
                }
            }
        };
    }
}

