/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WorkMaker {
    private static final Logger log = LoggerFactory.getLogger(WorkMaker.class);
    private final ServerContext context;
    private AccumuloClient client;
    private BatchWriter writer;

    public WorkMaker(ServerContext context, AccumuloClient client) {
        this.context = context;
        this.client = client;
    }

    public void run() {
        if (!ReplicationTable.isOnline((AccumuloClient)this.client)) {
            log.trace("Replication table is not yet online");
            return;
        }
        Span span = TraceUtil.startSpan(this.getClass(), (String)"replicationWorkMaker");
        try {
            Scope scope = span.makeCurrent();
            try {
                Scanner s;
                try {
                    s = ReplicationTable.getScanner((AccumuloClient)this.client);
                    if (this.writer == null) {
                        this.setBatchWriter(ReplicationTable.getBatchWriter((AccumuloClient)this.client));
                    }
                }
                catch (ReplicationTableOfflineException e) {
                    TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                    log.warn("Replication table was online, but not anymore");
                    this.writer = null;
                    if (scope != null) {
                        scope.close();
                    }
                    span.end();
                    return;
                }
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                Text file = new Text();
                for (Map.Entry entry : s) {
                    Replication.Status status;
                    ReplicationSchema.StatusSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                    TableId tableId = ReplicationSchema.StatusSection.getTableId((Key)((Key)entry.getKey()));
                    log.debug("Processing replication status record for {} on table {}", (Object)file, (Object)tableId);
                    try {
                        status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error("Could not parse protobuf for {} from table {}", (Object)file, (Object)tableId);
                        continue;
                    }
                    if (!this.shouldCreateWork(status)) {
                        log.debug("Not creating work: {}", (Object)status);
                        continue;
                    }
                    TableConfiguration tableConf = this.context.getTableConfiguration(tableId);
                    if (tableConf == null) continue;
                    Map<String, String> replicationTargets = this.getReplicationTargets(tableConf);
                    if (replicationTargets.isEmpty()) {
                        log.warn("No configured targets for table with ID {}", (Object)tableId);
                        continue;
                    }
                    Span childSpan = TraceUtil.startSpan(this.getClass(), (String)"createWorkMutations");
                    try {
                        Scope childScope = childSpan.makeCurrent();
                        try {
                            this.addWorkRecord(file, (Value)entry.getValue(), replicationTargets, tableId);
                        }
                        finally {
                            if (childScope == null) continue;
                            childScope.close();
                        }
                    }
                    catch (Exception e) {
                        TraceUtil.setException((Span)childSpan, (Throwable)e, (boolean)true);
                        throw e;
                    }
                    finally {
                        childSpan.end();
                    }
                }
            }
            finally {
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
    }

    protected void setBatchWriter(BatchWriter bw) {
        this.writer = bw;
    }

    protected Map<String, String> getReplicationTargets(TableConfiguration tableConf) {
        Map props = tableConf.getAllPropertiesWithPrefix(Property.TABLE_REPLICATION_TARGET);
        HashMap<String, String> targets = new HashMap<String, String>();
        int propKeyLength = Property.TABLE_REPLICATION_TARGET.getKey().length();
        for (Map.Entry prop : props.entrySet()) {
            targets.put(((String)prop.getKey()).substring(propKeyLength), (String)prop.getValue());
        }
        return targets;
    }

    protected boolean shouldCreateWork(Replication.Status status) {
        return StatusUtil.isWorkRequired((Replication.Status)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorkRecord(Text file, Value v, Map<String, String> targets, TableId sourceTableId) {
        log.info("Adding work records for {} to targets {}", (Object)file, targets);
        try {
            Mutation m = new Mutation(file);
            ReplicationTarget target = new ReplicationTarget();
            DataOutputBuffer buffer = new DataOutputBuffer();
            Text t = new Text();
            for (Map.Entry<String, String> entry : targets.entrySet()) {
                buffer.reset();
                target.setPeerName(entry.getKey());
                target.setRemoteIdentifier(entry.getValue());
                target.setSourceTableId(sourceTableId);
                target.write((DataOutput)buffer);
                t.set(buffer.getData(), 0, buffer.getLength());
                ReplicationSchema.WorkSection.add((Mutation)m, (Text)t, (Value)v);
            }
            try {
                this.writer.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.warn("Failed to serialize data to Text, will retry", (Throwable)e);
        }
        finally {
            try {
                this.writer.flush();
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
            }
        }
    }
}

