/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.server.metrics.NoopMetrics;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplicationMetrics
implements MetricsProducer {
    private static final Logger log = LoggerFactory.getLogger(ReplicationMetrics.class);
    private final Manager manager;
    private final ReplicationUtil replicationUtil;
    private final Map<Path, Long> pathModTimes;
    private Timer replicationQueueTimer = NoopMetrics.useNoopTimer();
    private AtomicLong pendingFiles;
    private AtomicInteger numPeers;
    private AtomicInteger maxReplicationThreads;

    ReplicationMetrics(Manager manager) {
        this.manager = manager;
        this.pathModTimes = new HashMap<Path, Long>();
        this.replicationUtil = new ReplicationUtil(manager.getContext());
    }

    protected void update() {
        if (TableState.ONLINE == this.manager.getContext().getTableState(ReplicationTable.ID) && !this.replicationUtil.getPeers().isEmpty()) {
            this.pendingFiles.set(this.getNumFilesPendingReplication());
            this.addReplicationQueueTimeMetrics();
        } else {
            this.pendingFiles.set(0L);
        }
        this.numPeers.set(this.getNumConfiguredPeers());
        this.maxReplicationThreads.set(this.getMaxReplicationThreads());
    }

    protected long getNumFilesPendingReplication() {
        Set allConfiguredTargets = this.replicationUtil.getReplicationTargets();
        Map targetCounts = this.replicationUtil.getPendingReplications();
        long filesPending = 0L;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (numFiles == null) continue;
            filesPending += numFiles.longValue();
        }
        return filesPending;
    }

    protected int getNumConfiguredPeers() {
        return this.replicationUtil.getPeers().size();
    }

    protected int getMaxReplicationThreads() {
        return this.replicationUtil.getMaxReplicationThreads(this.manager.getManagerMonitorInfo());
    }

    protected void addReplicationQueueTimeMetrics() {
        Set paths = this.replicationUtil.getPendingReplicationPaths();
        long currentTime = System.currentTimeMillis();
        for (Path path : paths) {
            if (this.pathModTimes.containsKey(path)) continue;
            try {
                this.pathModTimes.put(path, this.manager.getVolumeManager().getFileStatus(path).getModificationTime());
            }
            catch (IOException e) {
                log.trace("Failed to get file status for {}, file system is unavailable or it does not exist", (Object)path);
            }
        }
        HashSet<Path> deletedPaths = new HashSet<Path>(this.pathModTimes.keySet());
        deletedPaths.removeAll(paths);
        if (deletedPaths.isEmpty()) {
            return;
        }
        for (Path path : deletedPaths) {
            Long modTime = this.pathModTimes.remove(path);
            if (modTime == null) continue;
            long diff = Math.max(0L, currentTime - modTime);
            this.replicationQueueTimer.record(Duration.ofMillis(diff));
        }
    }

    public void registerMetrics(MeterRegistry registry) {
        this.replicationQueueTimer = registry.timer("accumulo.replication.queue", new String[0]);
        this.pendingFiles = (AtomicLong)registry.gauge("accumulo.replication.files.pending", (Number)new AtomicLong(0L));
        this.numPeers = (AtomicInteger)registry.gauge("accumulo.replication.peers", (Number)new AtomicInteger(0));
        this.maxReplicationThreads = (AtomicInteger)registry.gauge("accumulo.replication.threads", (Number)new AtomicInteger(0));
        ScheduledThreadPoolExecutor scheduler = ThreadPools.getServerThreadPools().createScheduledExecutorService(1, "replicationMetricsPoller");
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
        long minimumRefreshDelay = TimeUnit.SECONDS.toMillis(5L);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(this::update, minimumRefreshDelay, minimumRefreshDelay, TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }
}

