/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.JsonUtils;

class StateGrabber {
    StateGrabber() {
    }

    static String getAllPoolsJSON(CouchbaseMock mock) {
        HashMap<String, Object> retObj = new HashMap<String, Object>();
        ArrayList pools = new ArrayList();
        HashMap<String, String> defaultPool = new HashMap<String, String>();
        defaultPool.put("name", mock.getPoolName());
        defaultPool.put("uri", "/pools/" + mock.getPoolName());
        defaultPool.put("streamingUri", "/poolsStreaming/" + mock.getPoolName());
        pools.add(defaultPool);
        retObj.put("pools", pools);
        retObj.put("isAdminCreds", Boolean.TRUE);
        retObj.put("implementationVersion", "CouchbaseMock");
        return JsonUtils.encode(retObj);
    }

    static String getPoolInfoJSON(CouchbaseMock mock) {
        HashMap poolInfo = new HashMap();
        HashMap<String, String> buckets = new HashMap<String, String>();
        poolInfo.put("buckets", buckets);
        buckets.put("uri", "/pools/" + mock.getPoolName() + "/buckets");
        return JsonUtils.encode(poolInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getBucketJSON(Bucket bucket) {
        String ret;
        bucket.configReadLock();
        try {
            ret = bucket.getJSON();
        }
        finally {
            bucket.configReadUnlock();
        }
        return ret;
    }

    static String getAllBucketsJSON(List<Bucket> allowedBuckets) {
        ArrayList<Map<String, Object>> bucketsJSON = new ArrayList<Map<String, Object>>();
        for (Bucket bucket : allowedBuckets) {
            bucketsJSON.add(bucket.getConfigMap());
        }
        return JsonUtils.encode(bucketsJSON);
    }
}

