#!perl

use Test::More;
use Test::NoWarnings;

use autodie;
plan 'tests' => 2;

use Pg::Explain;

my $plan_source = q{
Limit  (cost=10000056579.95..10000056704.95 rows=50000 width=55)
  ->  Sort  (cost=10000056079.95..10000057001.78 rows=368730 width=55)
        Sort Key: product_uuid
        ->  Seq Scan on mv_out_product_variant mopv  (cost=10000000000.00..10000009383.30 rows=368730 width=55)
};

my $explain = Pg::Explain->new( 'source' => $plan_source );
$explain->parse_source;
isa_ok( $explain->top_node, 'Pg::Explain::Node' );

# This will warn if total_rows_removed hasn't been fixed (should be from 2.10)
my $q = $explain->top_node->sub_nodes->[ 0 ]->total_rows_removed();

exit;
