# Generated by default/object.tt
package Paws::SESv2::FailureInfo;
  use Moose;
  has ErrorMessage => (is => 'ro', isa => 'Str');
  has FailedRecordsS3Url => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::FailureInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::FailureInfo object:

  $service_obj->Method(Att1 => { ErrorMessage => $value, ..., FailedRecordsS3Url => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::FailureInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorMessage

=head1 DESCRIPTION

An object that contains the failure details about an import job.

=head1 ATTRIBUTES


=head2 ErrorMessage => Str

A message about why the import job failed.


=head2 FailedRecordsS3Url => Str

An Amazon S3 presigned URL that contains all the failed records and
related information.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

