# Generated by default/object.tt
package Paws::Transfer::ProtocolDetails;
  use Moose;
  has PassiveIp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::ProtocolDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::ProtocolDetails object:

  $service_obj->Method(Att1 => { PassiveIp => $value, ..., PassiveIp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::ProtocolDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->PassiveIp

=head1 DESCRIPTION

The protocol settings that are configured for your server.

This type is only valid in the C<UpdateServer> API.

=head1 ATTRIBUTES


=head2 PassiveIp => Str

Indicates passive mode, for FTP and FTPS protocols. Enter a single
dotted-quad IPv4 address, such as the external IP address of a
firewall, router, or load balancer. For example:

C<aws transfer update-server --protocol-details PassiveIp=I<0.0.0.0>>

Replace C< I<0.0.0.0> > in the example above with the actual IP address
you want to use.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

