/***************************************************************
 *			styles.c
 *
 * Please do not edit this file by hand: it has been
 * generated from styles.c.in through (GNU) m4 with option
 * --prefix-builtins
 * This file describes different languages : their words alphabet,
 * their keywords, their symbols, their special symbols,
 * their sequences type (eg. strings, comments), their exceptions
 * in the sequences, ...
 *
 * You can add new features to this program simply by modifying
 * this file.
 * All you have to do is to add a new item to the global
 * variable languages.
 *
 ****************************************************************/

/************************************************************************/
/*									*/
/* Description: Ascii to PostScript printer program.			*/
/* File: http://www.enst.fr/~demaille/a2ps.html				*/
/* Created: Oct, 20 1996, by  demaille@inf.enst.fr (Demaille Akim)	*/
/* Version: 4.6								*/
/*									*/
/* Edit history:							*/
/* Modified by Emmanuel Briot (Emmanuel.Briot@enst-bretagne.fr)         */
/*  1) Built the keyword highlight mode					*/
/*  2) Added C/C++, Perl, Ada and Caml modes				*/
/* Modified by Akim Demaille (demaille@inf.enst.fr)                     */
/*  3) Added eiffel, sh, claire, lace key word Highligting              */
/*  4) Adding description of the alphabet for the keywords		*/
/*  5) Added the symbol translation (-t, -nt)				*/
/*  6) Case sensitiveness according to the language			*/
/*  7) Added sdl, and distinguished c from c++				*/
/*  8) Added specials, double-set alphabet description, and zsh style	*/
/*  9) Added promela, mail and java style				*/
/* 10) Sequences now have three fonts (open, in, close)			*/
/* 11) Changed handling of lexical exceptions: verbatims and escapes	*/
/* 12) Added tcl, tk and o2c style					*/
/* 13) Keywords are now defined with their font type			*/
/* 14) Added Sather, python, postscript, html, modula3 styles		*/
/* 15) Added the invisible font, possibilities with sequences augmented	*/
/* 16) Description for languages, and automatic recognition		*/
/* 17) Added Pascal, used m4						*/
/* Modified by Denis Girou (Denis.Girou@idris.fr)			*/
/* 18) Added Fortran 90							*/
/*									*/
/************************************************************************/
#include "config.h"
#include "a2ps.h"
#include "styles.h"

const unsigned char * EMPTY [] = {
  UNULL
};

/*
 * Map of the file
 *
 * 1. Prescript
 * 2. Misceleanous
 *   mail, postscript, html
 * 3. Shell-scripts
 *   sh, zsh, perl
 * 4. Eiffel family
 *   eiffel, lace
 * 5. C family
 *   c, cpp, o2c
 * 6. TCL family
 *   tcl, tk
 * 7. Object-oriented languages
 *   claire, java, ada, sather, python
 * 8. Functional languages
 *   caml, clisp, scheme, coq
 * 9. Modula family
 *   pascal, modula3, oberon
 * 10. Specification languages
 *   promela, sdl
 * 11. Fortran
 * 12. Assembly languages
 *    M68000
 */


/************************************************************************/
/*									*/
/* 		Definition of the various styles			*/
/*									*/
/************************************************************************/
/*
 *		prescript
 */
const unsigned char* prescript_sequences [] = { 
  /* Skip portions not destined to a2ps, but only to LaTeX */
  (ustring)"%%prescript:skip\n", FONT_INVISIBLE, FONT_INVISIBLE, (ustring)"%%prescript:piks\n", FONT_INVISIBLE,
  (ustring)"%", FONT_INVISIBLE, FONT_INVISIBLE, (ustring)"\n", FONT_INVISIBLE, 

  /* lists */
  (ustring)"\\item[", FONT_INVISIBLE, FONT_BOLD, (ustring)"]", FONT_INVISIBLE,
  /* titles */
  (ustring)"\\section{", FONT_INVISIBLE, FONT_BOLD, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\subsection{", FONT_INVISIBLE, FONT_BOLD, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\subsubsection{", FONT_INVISIBLE, FONT_BOLD, (ustring)"}", FONT_INVISIBLE,
  /* change of font */
  (ustring)"\\textbf{", FONT_INVISIBLE, FONT_BOLD, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\textit{", FONT_INVISIBLE, FONT_ITALIC, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\textbi{", FONT_INVISIBLE, FONT_EMPH, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\textrm{", FONT_INVISIBLE, FONT_TIMES, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\textsy{", FONT_INVISIBLE, FONT_SYMBOL, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\texttt{", FONT_INVISIBLE, FONT_COURIER, (ustring)"}", FONT_INVISIBLE,
  /* change of font but invisible in LaTeX */
  (ustring)"\\magicbf{", FONT_INVISIBLE, FONT_BOLD, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\magicit{", FONT_INVISIBLE, FONT_ITALIC, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\magicbi{", FONT_INVISIBLE, FONT_EMPH, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\magicrm{", FONT_INVISIBLE, FONT_TIMES, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\magicsy{", FONT_INVISIBLE, FONT_SYMBOL, (ustring)"}", FONT_INVISIBLE,
  (ustring)"\\magictt{", FONT_INVISIBLE, FONT_COURIER, (ustring)"}", FONT_INVISIBLE,
  /* Verbatims */
  (ustring)"\\verb+", FONT_INVISIBLE, FONT_COURIER, (ustring)"+", FONT_INVISIBLE,
  (ustring)"\\verb!", FONT_INVISIBLE, FONT_COURIER, (ustring)"!", FONT_INVISIBLE,
  (ustring)"\\verb|", FONT_INVISIBLE, FONT_COURIER, (ustring)"|", FONT_INVISIBLE,
  (ustring)"\\verb#", FONT_INVISIBLE, FONT_COURIER, (ustring)"#", FONT_INVISIBLE,
  (ustring)"\\verb=", FONT_INVISIBLE, FONT_COURIER, (ustring)"=", FONT_INVISIBLE,
  UNULL
};
const unsigned char prescript_chars_1 [] = {
  '\\', '\\',
  '_', '_',
  '\0'
};
const unsigned char prescript_chars_2 [] = {
  '_', '_',
  '\0'
};
const unsigned char* prescript_symbols [] = {
  /* Characters from LaTeX */
  (ustring) "\\to", (ustring) "\256", FONT_SYMBOL,
  (ustring) "\\item", (ustring) "\267", FONT_SYMBOL,
  (ustring)"\\backslash", (ustring) "\\",	FONT_COURIER,
  /* Things that must disapear */
  (ustring) "\\begin{document}\n", UNULL, FONT_INVISIBLE,(ustring) "\\end{document}\n", UNULL, FONT_INVISIBLE,(ustring) "\\begin{itemize}\n", UNULL, FONT_INVISIBLE,(ustring) "\\end{itemize}\n", UNULL, FONT_INVISIBLE,(ustring) "\\begin{enumerate}\n", UNULL, FONT_INVISIBLE,(ustring) "\\end{enumerate}\n", UNULL, FONT_INVISIBLE,(ustring) "\\begin{description}\n", UNULL, FONT_INVISIBLE,(ustring) "\\end{description}\n", UNULL, FONT_INVISIBLE,

  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 34: universal */   	(ustring) "\\forall", (ustring) "\42", FONT_SYMBOL,
  /* 36: existential */ 	(ustring) "\\exists", (ustring) "\44", FONT_SYMBOL,
  /* 39: suchthat */    	(ustring) "\\suchthat", (ustring) "\47", FONT_SYMBOL,
  /* 64: congruent */   	(ustring) "\\cong", (ustring) "\100", FONT_SYMBOL,
  /* 65: Alpha */       	(ustring) "\\Alpha", (ustring) "\101", FONT_SYMBOL,
  /* 66: Beta */        	(ustring) "\\Beta", (ustring) "\102", FONT_SYMBOL,
  /* 67: Chi */ 		(ustring) "\\Chi", (ustring) "\103", FONT_SYMBOL,
  /* 68: Delta */       	(ustring) "\\Delta", (ustring) "\104", FONT_SYMBOL,
  /* 69: Epsilon */     	(ustring) "\\Epsilon", (ustring) "\105", FONT_SYMBOL,
  /* 70: Phi */ 		(ustring) "\\Phi", (ustring) "\106", FONT_SYMBOL,
  /* 71: Gamma */       	(ustring) "\\Gamma", (ustring) "\107", FONT_SYMBOL,
  /* 72: Eta */ 		(ustring) "\\Eta", (ustring) "\110", FONT_SYMBOL,
  /* 73: Iota */        	(ustring) "\\Iota", (ustring) "\111", FONT_SYMBOL,
  /* 74: theta1 */      	(ustring) "\\vartheta", (ustring) "\112", FONT_SYMBOL,
  /* 75: Kappa */       	(ustring) "\\Kappa", (ustring) "\113", FONT_SYMBOL,
  /* 76: Lambda */      	(ustring) "\\Lambda", (ustring) "\114", FONT_SYMBOL,
  /* 77: Mu */  		(ustring) "\\Mu", (ustring) "\115", FONT_SYMBOL,
  /* 78: Nu */  		(ustring) "\\Nu", (ustring) "\116", FONT_SYMBOL,
  /* 79: Omicron */     	(ustring) "\\Omicron", (ustring) "\117", FONT_SYMBOL,
  /* 80: Pi */  		(ustring) "\\Pi", (ustring) "\120", FONT_SYMBOL,
  /* 81: Theta */       	(ustring) "\\Theta", (ustring) "\121", FONT_SYMBOL,
  /* 82: Rho */ 		(ustring) "\\Rho", (ustring) "\122", FONT_SYMBOL,
  /* 83: Sigma */       	(ustring) "\\Sigma", (ustring) "\123", FONT_SYMBOL,
  /* 84: Tau */ 		(ustring) "\\Tau", (ustring) "\124", FONT_SYMBOL,
  /* 85: Upsilon */     	(ustring) "\\Upsilon", (ustring) "\125", FONT_SYMBOL,
  /* 86: sigma1 */      	(ustring) "\\varsigma", (ustring) "\126", FONT_SYMBOL,
  /* 87: Omega */       	(ustring) "\\Omega", (ustring) "\127", FONT_SYMBOL,
  /* 88: Xi */ 		 	(ustring) "\\Xi", (ustring) "\130", FONT_SYMBOL,
  /* 89: Psi */ 		(ustring) "\\Psi", (ustring) "\131", FONT_SYMBOL,
  /* 90: Zeta */        	(ustring) "\\Zeta", (ustring) "\132", FONT_SYMBOL,
  /* 92: therefore */   	(ustring) "\\therefore", (ustring) "\134", FONT_SYMBOL,
  /* 94: perpendicular */       (ustring) "\\perp", (ustring) "\136", FONT_SYMBOL,
  /* 96: radicalex */   	(ustring) "\\radicalex", (ustring) "\140", FONT_SYMBOL,
  /* 97: alpha */       	(ustring) "\\alpha", (ustring) "\141", FONT_SYMBOL,
  /* 98: beta */        	(ustring) "\\beta", (ustring) "\142", FONT_SYMBOL,
  /* 99: chi */ 	 	(ustring) "\\chi", (ustring) "\143", FONT_SYMBOL,
  /* 100: delta */      	(ustring) "\\delta", (ustring) "\144", FONT_SYMBOL,
  /* 101: epsilon */    	(ustring) "\\epsilon", (ustring) "\145", FONT_SYMBOL,
  /* 102: phi */        	(ustring) "\\phi", (ustring) "\146", FONT_SYMBOL,
  /* 103: gamma */      	(ustring) "\\gamma", (ustring) "\147", FONT_SYMBOL,
  /* 104: eta */        	(ustring) "\\eta", (ustring) "\150", FONT_SYMBOL,
  /* 105: iota */       	(ustring) "\\iota", (ustring) "\151", FONT_SYMBOL,
  /* 106: phi1 */       	(ustring) "\\phi", (ustring) "\152", FONT_SYMBOL,
  /* 107: kappa */      	(ustring) "\\kappa", (ustring) "\153", FONT_SYMBOL,
  /* 108: lambda */     	(ustring) "\\lambda", (ustring) "\154", FONT_SYMBOL,
  /* 109: mu */	 		(ustring) "\\mu", (ustring) "\155", FONT_SYMBOL,
  /* 110: nu */	 		(ustring) "\\nu", (ustring) "\156", FONT_SYMBOL,
  /* 111: omicron */    	(ustring) "\\omicron", (ustring) "\157", FONT_SYMBOL,
  /* 112: pi */	 		(ustring) "\\pi", (ustring) "\160", FONT_SYMBOL,
  /* 113: theta */      	(ustring) "\\theta", (ustring) "\161", FONT_SYMBOL,
  /* 114: rho */        	(ustring) "\\rho", (ustring) "\162", FONT_SYMBOL,
  /* 115: sigma */      	(ustring) "\\sigma", (ustring) "\163", FONT_SYMBOL,
  /* 116: tau */        	(ustring) "\\tau", (ustring) "\164", FONT_SYMBOL,
  /* 117: upsilon */    	(ustring) "\\upsilon", (ustring) "\165", FONT_SYMBOL,
  /* 118: omega1 */     	(ustring) "\\varpi", (ustring) "\166", FONT_SYMBOL,
  /* 119: omega */      	(ustring) "\\omega", (ustring) "\167", FONT_SYMBOL,
  /* 120: xi */	 		(ustring) "\\xi", (ustring) "\170", FONT_SYMBOL,
  /* 121: psi */        	(ustring) "\\psi", (ustring) "\171", FONT_SYMBOL,
  /* 122: zeta */       	(ustring) "\\zeta", (ustring) "\172", FONT_SYMBOL,
  /* 126: similar */    	(ustring) "\\sim", (ustring) "\176", FONT_SYMBOL,
  /* 161: Upsilon1 */   	(ustring) "\\varUpsilon", (ustring) "\241", FONT_SYMBOL,
  /* 162: minute */     	(ustring) "\\prime", (ustring) "\242", FONT_SYMBOL,
  /* 163: lessequal */  	(ustring) "\\leq", (ustring) "\243", FONT_SYMBOL,
  /* 165: infinity */   	(ustring) "\\infty", (ustring) "\245", FONT_SYMBOL,
  /* 166: florin **********/   	(ustring) "\\florin", (ustring) "\246", FONT_SYMBOL,
  /* 167: club */       	(ustring) "\\clubsuit", (ustring) "\247", FONT_SYMBOL,
  /* 168: diamond */    	(ustring) "\\diamondsuit", (ustring) "\250", FONT_SYMBOL,
  /* 169: heart */      	(ustring) "\\heartsuit", (ustring) "\251", FONT_SYMBOL,
  /* 170: spade */      	(ustring) "\\spadesuit", (ustring) "\252", FONT_SYMBOL,
  /* 171: arrowboth */  	(ustring) "\\leftrightarrow", (ustring) "\253", FONT_SYMBOL,
  /* 172: arrowleft */  	(ustring) "\\leftarrow", (ustring) "\254", FONT_SYMBOL,
  /* 173: arrowup */    	(ustring) "\\uparrow", (ustring) "\255", FONT_SYMBOL,
  /* 174: arrowright */ 	(ustring) "\\rightarrow", (ustring) "\256", FONT_SYMBOL,
  /* 175: arrowdown */  	(ustring) "\\downarrow", (ustring) "\257", FONT_SYMBOL,
  /* 176: degree ********/     	(ustring) "\\circ", (ustring) "\260", FONT_SYMBOL,
  /* 177: plusminus */		(ustring) "\\pm", (ustring) "\261", FONT_SYMBOL,
  /* 179: greaterequal */       (ustring) "\\geq", (ustring) "\263", FONT_SYMBOL,
  /* 180: multiply */   	(ustring) "\\times", (ustring) "\264", FONT_SYMBOL,
  /* 181: proportional */       (ustring) "\\propto", (ustring) "\265", FONT_SYMBOL,
  /* 182: partialdiff */        (ustring) "\\partial", (ustring) "\266", FONT_SYMBOL,
  /* 183: bullet */    		(ustring) "\\bullet", (ustring) "\267", FONT_SYMBOL,
  /* 184: divide */     	(ustring) "\\div", (ustring) "\270", FONT_SYMBOL,
  /* 185: notequal */   	(ustring) "\\neq", (ustring) "\271", FONT_SYMBOL,
  /* 186: equivalence */        (ustring) "\\equiv", (ustring) "\272", FONT_SYMBOL,
  /* 187: approxequal */        (ustring) "\\approx", (ustring) "\273", FONT_SYMBOL,
  /* 188: ellipsis */   	(ustring) "\\ldots", (ustring) "\274", FONT_SYMBOL,
  /* 190: arrowhorizex */	(ustring) "---", (ustring) "\276", FONT_SYMBOL,
  /* 191: carriagereturn */     (ustring) "\\carriagereturn", (ustring) "\277", FONT_SYMBOL,
  /* 192: aleph */      	(ustring) "\\aleph", (ustring) "\300", FONT_SYMBOL,
  /* 193: Ifraktur */   	(ustring) "\\Im", (ustring) "\301", FONT_SYMBOL,
  /* 194: Rfraktur */   	(ustring) "\\Re", (ustring) "\302", FONT_SYMBOL,
  /* 195: weierstrass */        (ustring) "\\wp", (ustring) "\303", FONT_SYMBOL,
  /* 196: circlemultiply */     (ustring) "\\otimes", (ustring) "\304", FONT_SYMBOL,
  /* 197: circleplus */ 	(ustring) "\\oplus", (ustring) "\305", FONT_SYMBOL,
  /* 198: emptyset */  		(ustring) "\\emptyset", (ustring) "\306", FONT_SYMBOL,
  /* 199: intersection */       (ustring) "\\cap", (ustring) "\307", FONT_SYMBOL,
  /* 200: union */      	(ustring) "\\cup", (ustring) "\310", FONT_SYMBOL,
  /* 201: propersuperset */     (ustring) "\\supset", (ustring) "\311", FONT_SYMBOL,
  /* 202: reflexsuperset */     (ustring) "\\supseteq", (ustring) "\312", FONT_SYMBOL,
  /* 203: notsubset */  	(ustring) "\\not\\subset", (ustring) "\313", FONT_SYMBOL,
  /* 204: propersubset */       (ustring) "\\subset", (ustring) "\314", FONT_SYMBOL,
  /* 205: reflexsubset */       (ustring) "\\subseteq", (ustring) "\315", FONT_SYMBOL,
  /* 206: element */    	(ustring) "\\in", (ustring) "\316", FONT_SYMBOL,
  /* 207: notelement */ 	(ustring) "\\not\\in", (ustring) "\317", FONT_SYMBOL,
  /* 208: angle */      	(ustring) "\\angle", (ustring) "\320", FONT_SYMBOL,
  /* 209: gradient */   	(ustring) "\\nabla", (ustring) "\321", FONT_SYMBOL,
  /* 210: registerserif *****/  (ustring) "\\register", (ustring) "\322", FONT_SYMBOL,
  /* 211: copyrightserif ****/  (ustring) "\\copyright", (ustring) "\323", FONT_SYMBOL,
  /* 212: trademarkserif ****/  (ustring) "\\trademark", (ustring) "\324", FONT_SYMBOL,
  /* 213: product */    	(ustring) "\\prod", (ustring) "\325", FONT_SYMBOL,
  /* 214: radical */    	(ustring) "\\surd", (ustring) "\326", FONT_SYMBOL,
  /* 215: dotmath */    	(ustring) "\\cdot", (ustring) "\327", FONT_SYMBOL,
  /* 216: logicalnot */ 	(ustring) "\\not", (ustring) "\330", FONT_SYMBOL,
  /* 217: logicaland */ 	(ustring) "\\wedge", (ustring) "\331", FONT_SYMBOL,
  /* 218: logicalor */  	(ustring) "\\vee", (ustring) "\332", FONT_SYMBOL,
  /* 219: arrowdblboth */       (ustring) "\\Leftrightarrow", (ustring) "\333", FONT_SYMBOL,
  /* 220: arrowdblleft */       (ustring) "\\Leftarrow", (ustring) "\334", FONT_SYMBOL,
  /* 221: arrowdblup */ 	(ustring) "\\Uparrow", (ustring) "\335", FONT_SYMBOL,
  /* 222: arrowdblright */      (ustring) "\\Rightarrow", (ustring) "\336", FONT_SYMBOL,
  /* 223: arrowdbldown */       (ustring) "\\Downarrow", (ustring) "\337", FONT_SYMBOL,
  /* 224: lozenge *****/	(ustring) "\\diamondsuit", (ustring) "\340", FONT_SYMBOL,
  /* 225: angleleft */  	(ustring) "\\langle", (ustring) "\341", FONT_SYMBOL,
  /* 226: registersans ****/   	(ustring) "\\register", (ustring) "\342", FONT_SYMBOL,
  /* 227: copyrightsans ****/  	(ustring) "\\copyright", (ustring) "\343", FONT_SYMBOL,
  /* 228: trademarksans ****/  	(ustring) "\\trademark", (ustring) "\344", FONT_SYMBOL,
  /* 229: summation */  	(ustring) "\\sum", (ustring) "\345", FONT_SYMBOL,
  /* 233: bracketlefttp */      (ustring) "\\lceil", (ustring) "\351", FONT_SYMBOL,
  /* 235: bracketleftbt */      (ustring) "\\lfloor", (ustring) "\353", FONT_SYMBOL,
  /* 240: .notdef */    	(ustring) "\\apple", (ustring) "\360", FONT_SYMBOL,
  /* 241: angleright */ 	(ustring) "\\rangle", (ustring) "\361", FONT_SYMBOL,
  /* 242: integral */   	(ustring) "\\int", (ustring) "\362", FONT_SYMBOL,
  /* 249: bracketrighttp */     (ustring) "\\rceil", (ustring) "\371", FONT_SYMBOL,
  /* 251: bracketrightbt */     (ustring) "\\rfloor", (ustring) "\373", FONT_SYMBOL,
  UNULL
};
const unsigned char* prescript_specials [] = {
  /* There is no mode math in prescript */
  (ustring) "\\$", 	(ustring) "$", 	FONT_COURIER,
  (ustring) "$", 		UNULL, 	FONT_INVISIBLE,
  (ustring) "\\_", 	(ustring) "_",	FONT_COURIER,
  (ustring) "\\%", 	(ustring) "%", 	FONT_COURIER,
  (ustring) "\\&", 	(ustring) "&", 	FONT_COURIER,
  (ustring) "\\#", 	(ustring) "#", 	FONT_COURIER,
  /*
   * This is taken from the correspondance between font symbol
   * and LaTeX commands
   */
  /* 35: numbersign   	(ustring) "\\#", (ustring) "\43", FONT_SYMBOL,*/
  /* 37: percent      	(ustring) "\\%", (ustring) "\45", FONT_SYMBOL,*/
  /* 38: ampersand   	(ustring) "\\&", (ustring) "\46", FONT_SYMBOL,*/
  /* 40 parenleft */   		(ustring) "\\(", (ustring) "\50", FONT_SYMBOL,
  /* 41 parenright */  		(ustring) "\\)", (ustring) "\51", FONT_SYMBOL,
  /* 91: bracketleft */ 	(ustring) "\\[", (ustring) "\133", FONT_SYMBOL,
  /* 93: bracketright */        (ustring) "\\]", (ustring) "\135", FONT_SYMBOL,
  /* 95: underscore */  	(ustring) "\\_", (ustring) "\137", FONT_SYMBOL,
  /* 123: braceleft */  	(ustring) "\\{", (ustring) "\173", FONT_SYMBOL,
  /* 124: bar */        	(ustring) "\\|", (ustring) "\174", FONT_SYMBOL,
  /* 125: braceright */ 	(ustring) "\\}", (ustring) "\175", FONT_SYMBOL,
  /* 189: arrowvertex */        (ustring) "\\|", (ustring) "\275", FONT_SYMBOL,
  UNULL
};
const char *  prescript_abbreviations[] = {
  "biftex", "bif", "pre", "ptf", "\0"
};
const unsigned char prescript_description [] = 
"This is prescript, a language of description of textual pages. "
"It provides by the use of LaTeX like commands, a way to describe the "
"pages that a2ps should produce. It can be a very good choice of "
"destination language for people who want to produce text to print "
"(e.g. pretty-printing, automating documentation etc.) "
"but who defenetely do not want to learn postscript, nor to require "
"the use of LaTeX."
"\n"
"It is also known as BifTeX (Basic Instruction From LaTeX), of ptf "
"(Poor Text Format)."
"\n"
"Symbol translation is always enabled in this mode.";
#define prescript_style { "prescript",  				\
  prescript_abbreviations, prescript_description, 			\
  CASE_SENSITIVE, prescript_chars_1, prescript_chars_2, EMPTY,		\
  prescript_symbols, prescript_specials, prescript_sequences, EMPTY, EMPTY }


/************************************************************************/
/*			Misceleanous				   	*/
/************************************************************************/
/*
 *		mail
 */
const unsigned char* mail_sequences [] = { 
  (ustring)"> ", FONT_COURIER, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"Subject:", FONT_BOLD, FONT_BOLD, (ustring)"\n", FONT_BOLD,
  (ustring)"X-Sun-Data-Name:", FONT_BOLD, FONT_BOLD, (ustring)"\n", FONT_BOLD,
  UNULL
};
const unsigned char mail_characters [] = {
  ':', ':',
  '_', '_',
  '-', '-',
  '\0'
};
const unsigned char * mail_keywords [] = {
  /* headers of big interest */
  (ustring)"From:", FONT_BOLD,
  (ustring)"To:", FONT_BOLD,
  (ustring)"Date:", FONT_BOLD,
  (ustring)"Date", FONT_BOLD,
  (ustring)"Lines:", FONT_BOLD,
  (ustring)"Organization:", FONT_BOLD,
  (ustring)"Address:", FONT_BOLD,


  /* headers of small interest */
  (ustring)"Return-Path:", FONT_ITALIC,
  (ustring)"Received:", FONT_ITALIC,
  (ustring)"Sender:", FONT_ITALIC,
  (ustring)"Message-Id:", FONT_ITALIC,
  (ustring)"Reply-To:", FONT_ITALIC,
  (ustring)"From", FONT_ITALIC,
  (ustring)"X-Mailer:", FONT_ITALIC,
  (ustring)"Status:", FONT_ITALIC,
  (ustring)"Content-Transfer-Encoding:", FONT_ITALIC,
  (ustring)"Path:", FONT_ITALIC,
  (ustring)"Via:", FONT_ITALIC,
  (ustring)"Sent:", FONT_ITALIC,
  (ustring)"Original", FONT_ITALIC,
  (ustring)"Phase", FONT_ITALIC,
  (ustring)"Fruit", FONT_ITALIC,
  (ustring)"Sun", FONT_ITALIC,
  (ustring)"Lat", FONT_ITALIC,
  (ustring)"Buzzword", FONT_ITALIC,
  (ustring)"Return", FONT_ITALIC,
  (ustring)"Posted", FONT_ITALIC,
  (ustring)"Telephone", FONT_ITALIC,
  (ustring)"Postal-Address", FONT_ITALIC,
  (ustring)"Origin", FONT_ITALIC,
  (ustring)"X-Sent-By-Nmail-V", FONT_ITALIC,
  (ustring)"Resent", FONT_ITALIC,
  (ustring)"X-Location", FONT_ITALIC,
  (ustring)"Source", FONT_ITALIC,
  (ustring)"Mood", FONT_ITALIC,
  (ustring)"Neuron", FONT_ITALIC,
  (ustring)"Libi", FONT_ITALIC,
  (ustring)"X-HPMAIL", FONT_ITALIC,
  (ustring)"Mmdf", FONT_ITALIC,
  (ustring)"Network-", FONT_ITALIC,
  (ustring)"Really-", FONT_ITALIC,
  (ustring)"Post", FONT_ITALIC,
  (ustring)"Message-", FONT_ITALIC,
  (ustring)"Relay-", FONT_ITALIC,
  (ustring)"Article-", FONT_ITALIC,
  (ustring)"Approved:", FONT_ITALIC,
  (ustring)"Xref:", FONT_ITALIC,
  (ustring)"Transport-Options:", FONT_ITALIC,
  (ustring)"Ua-Content-Id:", FONT_ITALIC,
  (ustring)"Email-Version:", FONT_ITALIC,
  (ustring)"Errors-To:", FONT_ITALIC,
  (ustring)"Autoforwarded:", FONT_ITALIC,
  (ustring)"Sensitivity:", FONT_ITALIC,
  (ustring)"Content-Identifier:", FONT_ITALIC,
  (ustring)"Content-Type:", FONT_ITALIC,


  /* X400 Headers */
  (ustring)"X400-received:", FONT_ITALIC,
  (ustring)"X400-Recipients:", FONT_ITALIC,
  (ustring)"X400-Mts-Identifiers:", FONT_ITALIC,
  (ustring)"X400-Content-Type:", FONT_ITALIC,


  /* X headers */
  (ustring)"X-Face", FONT_ITALIC,
  (ustring)"X-Filter:", FONT_ITALIC,
  (ustring)"X-How-To-Reach-Us:", FONT_ITALIC,
  (ustring)"X-Char-Esc:", FONT_ITALIC,
  (ustring)"X-Mts:", FONT_ITALIC,
  (ustring)"X-Comment:", FONT_ITALIC,
  (ustring)"X-Telephone:", FONT_ITALIC,
  (ustring)"X-Facsimile:", FONT_ITALIC,
  (ustring)"X-Sequence:", FONT_ITALIC,
  (ustring)"X-lines:", FONT_ITALIC,
  (ustring)"Organisation:", FONT_ITALIC,
  (ustring)"Phone:", FONT_ITALIC,
  (ustring)"Telefax:", FONT_ITALIC,
  (ustring)"Warnings-To:", FONT_ITALIC,
  (ustring)"X-VM-v5-Data:", FONT_ITALIC,
  (ustring)"X-Sun-Charset:", FONT_ITALIC,
  (ustring)"X-Sun-Data-Type:", FONT_ITALIC,
  (ustring)"X-Sun-Data-Description:", FONT_ITALIC,
  (ustring)"X-Sun-Content-Lines:", FONT_ITALIC,
  (ustring)"MIME-Version:", FONT_ITALIC,

  UNULL
};
const char * mail_abbreviations[]= {
  "mail", "\0"
};
const unsigned char  mail_description [] = 
  "To use from elm and others, it is better to specify -kmailfolder, "
  "since the file sent to printer is no longer trully a mailfolder. "
  "It can also be nice to use -u and -H to specify the name of the "
  "mail box owner.";
#define mail_style { "mailfolder",  					\
  mail_abbreviations, mail_description, 				\
  CASE_SENSITIVE, mail_characters, mail_characters, mail_keywords,	\
  EMPTY, EMPTY, mail_sequences, EMPTY, EMPTY }

/*
 *		Postscript
 */
const unsigned char* postscript_sequences [] = { 
  (ustring)"%!", FONT_ITALIC, FONT_EMPH, (ustring)"\n", FONT_ITALIC,
  (ustring)"%%", FONT_ITALIC, FONT_EMPH, (ustring)"\n", FONT_ITALIC,
  (ustring)"%", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"(", FONT_COURIER, FONT_COURIER, (ustring)")", FONT_COURIER,
  UNULL
};
const unsigned char postscript_characters [] = {
  '_', '_',
  '\\', '\\',
  '\0'
};
const unsigned char* postscript_keywords [] = {
  (ustring)"add", FONT_BOLD,
  (ustring)"arc", FONT_BOLD,
  (ustring)"begin", FONT_BOLD,
  (ustring)"bind", FONT_BOLD,
  (ustring)"clip", FONT_BOLD,
  (ustring)"charpath", FONT_BOLD,
  (ustring)"closepath", FONT_BOLD,
  (ustring)"currentdict", FONT_BOLD,
  (ustring)"curveto", FONT_BOLD,
  (ustring)"def", FONT_BOLD,
  (ustring)"dict", FONT_BOLD,
  (ustring)"div", FONT_BOLD,
  (ustring)"dup", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"exch", FONT_BOLD,
  (ustring)"fill", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"foreach", FONT_BOLD,
  (ustring)"findfont", FONT_BOLD,
  (ustring)"get", FONT_BOLD,
  (ustring)"grestore", FONT_BOLD,
  (ustring)"gsave", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"ifelse", FONT_BOLD,
  (ustring)"index", FONT_BOLD,
  (ustring)"length", FONT_BOLD,
  (ustring)"lineto", FONT_BOLD,
  (ustring)"moveto", FONT_BOLD,
  (ustring)"mul", FONT_BOLD,
  (ustring)"neg", FONT_BOLD,
  (ustring)"newpath", FONT_BOLD,
  (ustring)"pop", FONT_BOLD,
  (ustring)"put", FONT_BOLD,
  (ustring)"restore", FONT_BOLD,
  (ustring)"rlineto", FONT_BOLD,
  (ustring)"rmoveto", FONT_BOLD,
  (ustring)"rotate", FONT_BOLD,
  (ustring)"save", FONT_BOLD,
  (ustring)"scale", FONT_BOLD,
  (ustring)"scalefont", FONT_BOLD,
  (ustring)"setfont", FONT_BOLD,
  (ustring)"setgray", FONT_BOLD,
  (ustring)"setlinewidth", FONT_BOLD,
  (ustring)"show", FONT_BOLD,
  (ustring)"showpage", FONT_BOLD,
  (ustring)"stringwidth", FONT_BOLD,
  (ustring)"stroke", FONT_BOLD,
  (ustring)"sub", FONT_BOLD,
  (ustring)"translate", FONT_BOLD,


  (ustring)"true", FONT_ITALIC,
  (ustring)"false", FONT_ITALIC,

   UNULL
};
const unsigned char* postscript_symbols [] = {
#if 0
  (ustring)"&&", (ustring)"\331", FONT_SYMBOL,
  (ustring)"||", (ustring)"\332", FONT_SYMBOL,
  (ustring)"^^", (ustring)"\305", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
#endif
  (ustring)"eq", (ustring)"\272", FONT_SYMBOL,
  (ustring)"ne", (ustring)"\271", FONT_SYMBOL,
  UNULL
};
const char * postscript_abbreviations[]= {
  "PostScript", "ps", "\0"
};
const unsigned char  postscript_description [] = "";
#define postscript_style { "postscript",				\
  postscript_abbreviations, postscript_description,			\
  CASE_SENSITIVE, postscript_characters, postscript_characters,		\
  postscript_keywords, postscript_symbols, EMPTY, postscript_sequences, EMPTY, EMPTY }

#ifdef HTML_STYLE
/*
 *		HTML
 * note: this is almost a joke since it does not work very well.
 */
const unsigned char* html_sequences [] = { 
  (ustring)"<TITLE>", FONT_ITALIC, FONT_BOLD, (ustring)"</TITLE>", FONT_ITALIC,
  (ustring)"<TT>", FONT_ITALIC, FONT_COURIER, (ustring)"</TT>", FONT_ITALIC,
  (ustring)"%", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  UNULL
};
const unsigned char html_characters [] = {
  '_', '_',
  '/', '/',
  '<', '<',
  '>', '>',
  '\0'
};
const unsigned char* html_keywords [] = {
  (ustring)"<HTML>", FONT_ITALIC,
  (ustring)"</HTML>", FONT_ITALIC,
  (ustring)"<BODY>", FONT_ITALIC,
  (ustring)"</BODY>", FONT_ITALIC,

   UNULL
};
const char * html_abbreviations[]= {
  "\0"
};
const unsigned char  html_description[] = "";
#define html_style { "html", 				\
  html_abbreviations, html_description, 		\
  CASE_SENSITIVE, html_characters, html_characters,   	\
  html_keywords, EMPTY, EMPTY, html_sequences, EMPTY, EMPTY }
#endif

/************************************************************************/
/*				Shell-scripts			   	*/
/************************************************************************/
/*
 *		sh
 */
const unsigned char* sh_sequences [] = { 
  (ustring)"#", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char* sh_verbatims [] = {
  (ustring) "\\\\", (ustring) "\\\"", (ustring) "\\\'", UNULL
};
const unsigned char sh_characters [] = {
  '_', '_',
  '/', '/', 
  '$', '$', 
  '\0'
};
const unsigned char sh_following_characters [] = {
  '_', '_',
  '/', '/', 
  '$', '$', 
  '#', '#', /* to avoid $# be understood as the beginning of a comment */
  '\0'
};
const unsigned char* sh_keywords [] = {
  (ustring)"for", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"done", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"esac", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"elif", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"fi", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"cd", FONT_BOLD,
  (ustring)"echo", FONT_BOLD,
  (ustring)"eval", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"export", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"shift", FONT_BOLD,
  (ustring)"test", FONT_BOLD,
  (ustring)"times", FONT_BOLD,
  (ustring)"trap", FONT_BOLD,
  (ustring)"stop", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"umask", FONT_BOLD,
  (ustring)"unset", FONT_BOLD,
  (ustring)"wait", FONT_BOLD,

   UNULL
};
const char * sh_abbreviations[]= {
  "c-shell", "jsh", "csh", "ksh", "bash", "shell", "\0"
};
const unsigned char  sh_description[] = "";
#define sh_style { "sh",					\
  sh_abbreviations, sh_description, 				\
  CASE_SENSITIVE, sh_characters, sh_following_characters,   	\
  sh_keywords, EMPTY, EMPTY, sh_sequences, sh_verbatims, EMPTY }

/*
 *		zsh
 */
const unsigned char* zsh_symbols [] = {
  (ustring)"&&", (ustring)"\331", FONT_SYMBOL,
  (ustring)"||", (ustring)"\332", FONT_SYMBOL,
  (ustring)"^^", (ustring)"\305", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  UNULL
};
const unsigned char* zsh_specials [] = {
  (ustring)"!", (ustring)"\330", FONT_SYMBOL,
  UNULL
};
const unsigned char * zsh_keywords [] = {
   (ustring)"alias", FONT_BOLD,
  (ustring)"autoload", FONT_BOLD,
  (ustring)"bg", FONT_BOLD,
  (ustring)"bindkey", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"builtin", FONT_BOLD,
  (ustring)"bye", FONT_BOLD,
  (ustring)"cd", FONT_BOLD,
  (ustring)"chdir", FONT_BOLD,
  (ustring)"compctl", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"declare", FONT_BOLD,
  (ustring)"dirs", FONT_BOLD,
  (ustring)"disable", FONT_BOLD,
  (ustring)"disown", FONT_BOLD,
  (ustring)"echo", FONT_BOLD,
  (ustring)"echotc", FONT_BOLD,
  (ustring)"emulate", FONT_BOLD,
  (ustring)"enable", FONT_BOLD,
  (ustring)"eval", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"export", FONT_BOLD,
  (ustring)"false", FONT_BOLD,
  (ustring)"fc", FONT_BOLD,
  (ustring)"fg", FONT_BOLD,
  (ustring)"functions", FONT_BOLD,
  (ustring)"getln", FONT_BOLD,
  (ustring)"getopts", FONT_BOLD,
  (ustring)"hash", FONT_BOLD,
  (ustring)"history", FONT_BOLD,
  (ustring)"integer", FONT_BOLD,
  (ustring)"jobs", FONT_BOLD,
  (ustring)"kill", FONT_BOLD,
  (ustring)"let", FONT_BOLD,
  (ustring)"limit", FONT_BOLD,
  (ustring)"local", FONT_BOLD,
  (ustring)"log", FONT_BOLD,
  (ustring)"logout", FONT_BOLD,
  (ustring)"popd", FONT_BOLD,
  (ustring)"print", FONT_BOLD,
  (ustring)"pushd", FONT_BOLD,
  (ustring)"pushln", FONT_BOLD,
  (ustring)"pwd", FONT_BOLD,
  (ustring)"r", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"readonly", FONT_BOLD,
  (ustring)"rehash", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"sched", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"setopt", FONT_BOLD,
  (ustring)"shift", FONT_BOLD,
  (ustring)"source", FONT_BOLD,
  (ustring)"suspend", FONT_BOLD,
  (ustring)"test", FONT_BOLD,
  (ustring)"times", FONT_BOLD,
  (ustring)"trap", FONT_BOLD,
  (ustring)"true", FONT_BOLD,
  (ustring)"ttyctl", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"typeset", FONT_BOLD,
  (ustring)"ulimit", FONT_BOLD,
  (ustring)"umask", FONT_BOLD,
  (ustring)"inalias", FONT_BOLD,
  (ustring)"unfunction", FONT_BOLD,
  (ustring)"unhash", FONT_BOLD,
  (ustring)"unlimit", FONT_BOLD,
  (ustring)"unset", FONT_BOLD,
  (ustring)"unsetopt", FONT_BOLD,
  (ustring)"vared", FONT_BOLD,
  (ustring)"wait", FONT_BOLD,
  (ustring)"whence", FONT_BOLD,
  (ustring)"where", FONT_BOLD,
  (ustring)"which", FONT_BOLD,
  (ustring)"noglob", FONT_BOLD,
  (ustring)"nocorrect", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"command", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"elif", FONT_BOLD,
  (ustring)"fi", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"done", FONT_BOLD,
  (ustring)"foreach", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"repeat", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"esac", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"function", FONT_BOLD,
  (ustring)"time", FONT_BOLD,
  (ustring)"coproc", FONT_BOLD,

  UNULL
};
const char * zsh_abbreviations[]= {
  "\0"
};
const unsigned char  zsh_description[] = "";
#define zsh_style { "zsh",				     	  	\
  zsh_abbreviations, zsh_description, 					\
  CASE_SENSITIVE, sh_characters, sh_following_characters,	       	\
  zsh_keywords, zsh_symbols, zsh_specials, sh_sequences, sh_verbatims, EMPTY }

/*
 *		Perl
 */
const unsigned char* perl_sequences [] = {
  (ustring)"#", FONT_COURIER, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char perl_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* perl_keywords [] = {
   (ustring)"if", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"elsif", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"unless", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"foreach", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"die", FONT_BOLD,
  (ustring)"last", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"next", FONT_BOLD,
  (ustring)"redo", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"local", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"sub", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"dump", FONT_BOLD,
  (ustring)"use", FONT_BOLD,
  (ustring)"require", FONT_BOLD,
  (ustring)"package", FONT_BOLD,
  (ustring)"eval", FONT_BOLD,
  (ustring)"my", FONT_BOLD,
  (ustring)"BEGIN", FONT_BOLD,
  (ustring)"END", FONT_BOLD,
  (ustring)"CORE", FONT_BOLD,
  (ustring)"__FILE__", FONT_BOLD,
  (ustring)"__LINE__", FONT_BOLD,
  (ustring)"abs", FONT_BOLD,
  (ustring)"accept", FONT_BOLD,
  (ustring)"alarm", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"atan", FONT_BOLD,
  (ustring)"bind", FONT_BOLD,
  (ustring)"binmode", FONT_BOLD,
  (ustring)"bless", FONT_BOLD,
  (ustring)"caller", FONT_BOLD,
  (ustring)"chdir", FONT_BOLD,
  (ustring)"chmod", FONT_BOLD,
  (ustring)"chown", FONT_BOLD,
  (ustring)"chr", FONT_BOLD,
  (ustring)"chroot", FONT_BOLD,
  (ustring)"close", FONT_BOLD,
  (ustring)"closedir", FONT_BOLD,
  (ustring)"cmp", FONT_BOLD,
  (ustring)"connect", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"cos", FONT_BOLD,
  (ustring)"crypt", FONT_BOLD,
  (ustring)"dbmclose", FONT_BOLD,
  (ustring)"dbmopen", FONT_BOLD,
  (ustring)"die", FONT_BOLD,
  (ustring)"dump", FONT_BOLD,
  (ustring)"endgrent", FONT_BOLD,
  (ustring)"endhostent", FONT_BOLD,
  (ustring)"endnetent", FONT_BOLD,
  (ustring)"endprotoent", FONT_BOLD,
  (ustring)"endpwent", FONT_BOLD,
  (ustring)"endservent", FONT_BOLD,
  (ustring)"eof", FONT_BOLD,
  (ustring)"eq", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"exp", FONT_BOLD,
  (ustring)"fcntl", FONT_BOLD,
  (ustring)"fileno", FONT_BOLD,
  (ustring)"flock", FONT_BOLD,
  (ustring)"fork", FONT_BOLD,
  (ustring)"formline", FONT_BOLD,
  (ustring)"ge", FONT_BOLD,
  (ustring)"getc", FONT_BOLD,
  (ustring)"getgrent", FONT_BOLD,
  (ustring)"getgrgid", FONT_BOLD,
  (ustring)"getgrnam", FONT_BOLD,
  (ustring)"gethostbyaddr", FONT_BOLD,
  (ustring)"gethostbyname", FONT_BOLD,
  (ustring)"gethostent", FONT_BOLD,
  (ustring)"getlogin", FONT_BOLD,
  (ustring)"getnetbyaddr", FONT_BOLD,
  (ustring)"getnetbyname", FONT_BOLD,
  (ustring)"getnetent", FONT_BOLD,
  (ustring)"getpeername", FONT_BOLD,
  (ustring)"getpgrp", FONT_BOLD,
  (ustring)"getppid", FONT_BOLD,
  (ustring)"getpriority", FONT_BOLD,
  (ustring)"getprotobyname", FONT_BOLD,
  (ustring)"getprotobynumber", FONT_BOLD,
  (ustring)"getprotoent", FONT_BOLD,
  (ustring)"getpwent", FONT_BOLD,
  (ustring)"getpwnam", FONT_BOLD,
  (ustring)"getpwuid", FONT_BOLD,
  (ustring)"getservbyname", FONT_BOLD,
  (ustring)"getservbyport", FONT_BOLD,
  (ustring)"getservent", FONT_BOLD,
  (ustring)"getsockname", FONT_BOLD,
  (ustring)"getsockopt", FONT_BOLD,
  (ustring)"glob", FONT_BOLD,
  (ustring)"gmtime", FONT_BOLD,
  (ustring)"gt", FONT_BOLD,
  (ustring)"hex", FONT_BOLD,
  (ustring)"index", FONT_BOLD,
  (ustring)"int", FONT_BOLD,
  (ustring)"ioctl", FONT_BOLD,
  (ustring)"join", FONT_BOLD,
  (ustring)"kill", FONT_BOLD,
  (ustring)"lc", FONT_BOLD,
  (ustring)"lcfirst", FONT_BOLD,
  (ustring)"le", FONT_BOLD,
  (ustring)"length", FONT_BOLD,
  (ustring)"link", FONT_BOLD,
  (ustring)"listen", FONT_BOLD,
  (ustring)"localtime", FONT_BOLD,
  (ustring)"log", FONT_BOLD,
  (ustring)"lstat", FONT_BOLD,
  (ustring)"lt", FONT_BOLD,
  (ustring)"mkdir", FONT_BOLD,
  (ustring)"msgctl", FONT_BOLD,
  (ustring)"msgget", FONT_BOLD,
  (ustring)"msgrcv", FONT_BOLD,
  (ustring)"msgsnd", FONT_BOLD,
  (ustring)"ne", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"oct", FONT_BOLD,
  (ustring)"open", FONT_BOLD,
  (ustring)"opendir", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"ord", FONT_BOLD,
  (ustring)"pack", FONT_BOLD,
  (ustring)"pipe", FONT_BOLD,
  (ustring)"quotemeta", FONT_BOLD,
  (ustring)"rand", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"readdir", FONT_BOLD,
  (ustring)"readline", FONT_BOLD,
  (ustring)"readlink", FONT_BOLD,
  (ustring)"readpipe", FONT_BOLD,
  (ustring)"recv", FONT_BOLD,
  (ustring)"ref", FONT_BOLD,
  (ustring)"rename", FONT_BOLD,
  (ustring)"require", FONT_BOLD,
  (ustring)"reset", FONT_BOLD,
  (ustring)"reverse", FONT_BOLD,
  (ustring)"rewinddir", FONT_BOLD,
  (ustring)"rindex", FONT_BOLD,
  (ustring)"rmdir", FONT_BOLD,
  (ustring)"seek", FONT_BOLD,
  (ustring)"seekdir", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"semctl", FONT_BOLD,
  (ustring)"semget", FONT_BOLD,
  (ustring)"semop", FONT_BOLD,
  (ustring)"send", FONT_BOLD,
  (ustring)"setgrent", FONT_BOLD,
  (ustring)"sethostent", FONT_BOLD,
  (ustring)"setnetent", FONT_BOLD,
  (ustring)"setpgrp", FONT_BOLD,
  (ustring)"setpriority", FONT_BOLD,
  (ustring)"setprotoent", FONT_BOLD,
  (ustring)"setpwent", FONT_BOLD,
  (ustring)"setservent", FONT_BOLD,
  (ustring)"setsockopt", FONT_BOLD,
  (ustring)"shmctl", FONT_BOLD,
  (ustring)"shmget", FONT_BOLD,
  (ustring)"shmread", FONT_BOLD,
  (ustring)"shmwrite", FONT_BOLD,
  (ustring)"shutdown", FONT_BOLD,
  (ustring)"sin", FONT_BOLD,
  (ustring)"sleep", FONT_BOLD,
  (ustring)"socket", FONT_BOLD,
  (ustring)"socketpair", FONT_BOLD,
  (ustring)"sprintf", FONT_BOLD,
  (ustring)"sqrt", FONT_BOLD,
  (ustring)"srand", FONT_BOLD,
  (ustring)"stat", FONT_BOLD,
  (ustring)"substr", FONT_BOLD,
  (ustring)"symlink", FONT_BOLD,
  (ustring)"syscall", FONT_BOLD,
  (ustring)"sysread", FONT_BOLD,
  (ustring)"system", FONT_BOLD,
  (ustring)"syswrite", FONT_BOLD,
  (ustring)"tell", FONT_BOLD,
  (ustring)"telldir", FONT_BOLD,
  (ustring)"time", FONT_BOLD,
  (ustring)"times", FONT_BOLD,
  (ustring)"truncate", FONT_BOLD,
  (ustring)"uc", FONT_BOLD,
  (ustring)"ucfirst", FONT_BOLD,
  (ustring)"umask", FONT_BOLD,
  (ustring)"unlink", FONT_BOLD,
  (ustring)"unpack", FONT_BOLD,
  (ustring)"utime", FONT_BOLD,
  (ustring)"values", FONT_BOLD,
  (ustring)"vec", FONT_BOLD,
  (ustring)"wait", FONT_BOLD,
  (ustring)"waitpid", FONT_BOLD,
  (ustring)"wantarray", FONT_BOLD,
  (ustring)"warn", FONT_BOLD,
  (ustring)"write", FONT_BOLD,
  (ustring)"x", FONT_BOLD,
  (ustring)"xor", FONT_BOLD,
  (ustring)"print", FONT_BOLD,

   UNULL
};
const char * perl_abbreviations[]= {
  "pl", "pm", "\0"
};
const unsigned char  perl_description[] = "";
#define perl_style { "perl", 						\
  perl_abbreviations, perl_description, 				\
  CASE_SENSITIVE, perl_characters, perl_characters, perl_keywords,	\
  EMPTY, EMPTY, perl_sequences, sh_verbatims, EMPTY }


/************************************************************************/
/*			  Eiffel and eiffel-like	       	   	*/
/************************************************************************/
/*
 *		Eiffel
 */
const unsigned char* eiffel_sequences [] = {
  (ustring)"--", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char* eiffel_verbatims [] = {
  (ustring) "%%", (ustring) "%\"", (ustring) "%'", UNULL
};
const unsigned char eiffel_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* eiffel_symbols [] = {
  (ustring)"or else", (ustring)"or else", FONT_BOLD,
  (ustring)"and then", (ustring)"and then", FONT_BOLD,
  (ustring)"not", (ustring)"\330", FONT_SYMBOL, (ustring)"or", (ustring)"\332", FONT_SYMBOL, (ustring)"and", (ustring)"\331", FONT_SYMBOL, (ustring)"implies", (ustring)"\336", FONT_SYMBOL,
  UNULL
};
const unsigned char* eiffel_specials [] = {
  (ustring) ":=", (ustring) ":=",   FONT_COURIER,
  (ustring)"=", (ustring)"\272", FONT_SYMBOL,
  (ustring)"/=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  UNULL
};
const unsigned char* eiffel_keywords [] = {
  /* keywords */
  (ustring)"all", FONT_BOLD,
  (ustring)"alias", FONT_BOLD,
  (ustring)"as", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"check", FONT_BOLD,
  (ustring)"class", FONT_BOLD,
  (ustring)"current", FONT_BOLD,
  (ustring)"debug", FONT_BOLD,
  (ustring)"deferred", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"elseif", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"ensure", FONT_BOLD,
  (ustring)"expanded", FONT_BOLD,
  (ustring)"export", FONT_BOLD,
  (ustring)"external", FONT_BOLD,
  (ustring)"false", FONT_BOLD,
  (ustring)"feature", FONT_BOLD,
  (ustring)"from", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"implies", FONT_BOLD,
  (ustring)"indexing", FONT_BOLD,
  (ustring)"infix", FONT_BOLD,
  (ustring)"inherit", FONT_BOLD,
  (ustring)"inspect", FONT_BOLD,
  (ustring)"invariant", FONT_BOLD,
  (ustring)"is", FONT_BOLD,
  (ustring)"language", FONT_BOLD,
  (ustring)"like", FONT_BOLD,
  (ustring)"local", FONT_BOLD,
  (ustring)"loop", FONT_BOLD,
  (ustring)"none", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"creation", FONT_BOLD,
  (ustring)"obsolete", FONT_BOLD,
  (ustring)"old", FONT_BOLD,
  (ustring)"once", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"prefix", FONT_BOLD,
  (ustring)"redefine", FONT_BOLD,
  (ustring)"require", FONT_BOLD,
  (ustring)"rename", FONT_BOLD,
  (ustring)"rescue", FONT_BOLD,
  (ustring)"result", FONT_BOLD,
  (ustring)"retry", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"separate", FONT_BOLD,
  (ustring)"strip", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"true", FONT_BOLD,
  (ustring)"undefine", FONT_BOLD,
  (ustring)"unique", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"variant", FONT_BOLD,
  (ustring)"void", FONT_BOLD,
  (ustring)"when", FONT_BOLD,
  (ustring)"xor", FONT_BOLD,


   /* some basic types */
 (ustring)"bit", FONT_ITALIC,
  (ustring)"boolean", FONT_ITALIC,
  (ustring)"character", FONT_ITALIC,
  (ustring)"double", FONT_ITALIC,
  (ustring)"integer", FONT_ITALIC,
  (ustring)"pointer", FONT_ITALIC,
  (ustring)"real", FONT_ITALIC,
  (ustring)"string", FONT_ITALIC,

   UNULL
};
const char * eiffel_abbreviations[] = {
  "e", "\0"
};
const unsigned char  eiffel_description[] = "";
#define eiffel_style { "eiffel",					\
  eiffel_abbreviations, eiffel_description, 				\
  CASE_INSENSITIVE, eiffel_characters,	eiffel_characters,		\
  eiffel_keywords,                                                     	\
  eiffel_symbols, eiffel_specials, eiffel_sequences, eiffel_verbatims, EMPTY }

/*
 *		Language of Assembly for Classes of Eiffel
 */
const unsigned char* lace_keywords [] = { 
  /* keywords */
  (ustring)"end", FONT_BOLD,
  (ustring)"system", FONT_BOLD,
  (ustring)"root", FONT_BOLD,
  (ustring)"cluster", FONT_BOLD,
  (ustring)"use", FONT_BOLD,
  (ustring)"include", FONT_BOLD,
  (ustring)"precompiled", FONT_BOLD,
  (ustring)"exclude", FONT_BOLD,
  (ustring)"adapt", FONT_BOLD,
  (ustring)"ignore", FONT_BOLD,
  (ustring)"rename", FONT_BOLD,
  (ustring)"as", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"option", FONT_BOLD,
  (ustring)"collect", FONT_BOLD,
  (ustring)"assertion", FONT_BOLD,
  (ustring)"debug", FONT_BOLD,
  (ustring)"optimize", FONT_BOLD,
  (ustring)"trace", FONT_BOLD,
  (ustring)"yes", FONT_BOLD,
  (ustring)"no", FONT_BOLD,
  (ustring)"all", FONT_BOLD,
  (ustring)"require", FONT_BOLD,
  (ustring)"ensure", FONT_BOLD,
  (ustring)"invariant", FONT_BOLD,
  (ustring)"loop", FONT_BOLD,
  (ustring)"check", FONT_BOLD,
  (ustring)"external", FONT_BOLD,
  (ustring)"object", FONT_BOLD,
  (ustring)"make", FONT_BOLD,
  (ustring)"generate", FONT_BOLD,
  (ustring)"visible", FONT_BOLD,
  (ustring)"creation", FONT_BOLD,
  (ustring)"export", FONT_BOLD,


   /* Languages */
  (ustring)"eiffel", FONT_ITALIC,
  (ustring)"ada", FONT_ITALIC,
  (ustring)"pascal", FONT_ITALIC,
  (ustring)"fortran", FONT_ITALIC,
  (ustring)"c", FONT_ITALIC,

   UNULL
};
const char * lace_abbreviations[] = {
  "ace", "\0"
};
const unsigned char  lace_description[] = "";
#define lace_style { "lace", 						\
  lace_abbreviations, lace_description, 				\
  CASE_INSENSITIVE, eiffel_characters, eiffel_characters,		\
  lace_keywords, EMPTY, EMPTY, eiffel_sequences, eiffel_verbatims, EMPTY }

/************************************************************************/
/*				C and C-like			   	*/
/************************************************************************/
 
 
/*
 *		C
 */
const unsigned char* c_sequences [] = {
  (ustring)"/*", FONT_ITALIC, FONT_ITALIC, (ustring)"*/", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char c_characters [] = {
  '_', '_',
  '#', '%',
  '\0'
};
const unsigned char* c_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"&&", (ustring)"\331", FONT_SYMBOL,
  (ustring)"||", (ustring)"\332", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"!", (ustring)"\330", FONT_SYMBOL,
  UNULL
};
const unsigned char* c_keywords [] = {
  /* Preprocessor */
  (ustring)"#include", FONT_BOLD,
  (ustring)"#define", FONT_BOLD,
  (ustring)"#undef", FONT_BOLD,
  (ustring)"#pragma", FONT_BOLD,
  (ustring)"#if", FONT_BOLD,
  (ustring)"#ifdef", FONT_BOLD,
  (ustring)"#ifndef", FONT_BOLD,
  (ustring)"#elif", FONT_BOLD,
  (ustring)"#else", FONT_BOLD,
  (ustring)"#error", FONT_BOLD,
  (ustring)"#line", FONT_BOLD,
  (ustring)"#ex", FONT_BOLD,
  (ustring)"#endif", FONT_BOLD,
  (ustring)"defined", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# define", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# if", FONT_BOLD,
  (ustring)"# ifdef", FONT_BOLD,
  (ustring)"# endif", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  define", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  if", FONT_BOLD,
  (ustring)"#  ifdef", FONT_BOLD,
  (ustring)"#  endif", FONT_BOLD,


  /* simple types */
  (ustring)"double", FONT_ITALIC,
  (ustring)"enum", FONT_ITALIC,
  (ustring)"void", FONT_ITALIC,
  (ustring)"int", FONT_ITALIC,
  (ustring)"long", FONT_ITALIC,
  (ustring)"FILE", FONT_ITALIC,
  (ustring)"struct", FONT_ITALIC,
  (ustring)"char", FONT_ITALIC,
  (ustring)"signed", FONT_ITALIC,
  (ustring)"float", FONT_ITALIC,
  (ustring)"short", FONT_ITALIC,
  (ustring)"unsigned", FONT_ITALIC,


  /* core of the keywords */
  (ustring)"extern", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"register", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"auto", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"typedef", FONT_BOLD,
  (ustring)"union", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"sizeof", FONT_BOLD,
  (ustring)"volatile", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"static", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"NULL", FONT_BOLD,
  (ustring)"FILE", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"else", FONT_BOLD,

  UNULL 
}; 
const char * c_abbreviations[]= {
  "h", "i", "\0"
};
const unsigned char  c_description[] = "";
#define c_style {"c", 						\
  c_abbreviations, c_description, 				\
  CASE_SENSITIVE, c_characters, c_characters, c_keywords,	\
  EMPTY, c_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		c++
 */
const unsigned char* cpp_sequences [] = {
  (ustring)"/*", FONT_ITALIC, FONT_ITALIC, (ustring)"*/", FONT_ITALIC,
  (ustring)"//", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char* cpp_keywords [] = {
  /* Preprocessor */
  (ustring)"#include", FONT_BOLD,
  (ustring)"#define", FONT_BOLD,
  (ustring)"#undef", FONT_BOLD,
  (ustring)"#pragma", FONT_BOLD,
  (ustring)"#if", FONT_BOLD,
  (ustring)"#ifdef", FONT_BOLD,
  (ustring)"#ifndef", FONT_BOLD,
  (ustring)"#elif", FONT_BOLD,
  (ustring)"#else", FONT_BOLD,
  (ustring)"#error", FONT_BOLD,
  (ustring)"#line", FONT_BOLD,
  (ustring)"#ex", FONT_BOLD,
  (ustring)"#endif", FONT_BOLD,
  (ustring)"defined", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# define", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# if", FONT_BOLD,
  (ustring)"# ifdef", FONT_BOLD,
  (ustring)"# endif", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  define", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  if", FONT_BOLD,
  (ustring)"#  ifdef", FONT_BOLD,
  (ustring)"#  endif", FONT_BOLD,


  /* simple types */
  (ustring)"double", FONT_ITALIC,
  (ustring)"enum", FONT_ITALIC,
  (ustring)"void", FONT_ITALIC,
  (ustring)"int", FONT_ITALIC,
  (ustring)"long", FONT_ITALIC,
  (ustring)"FILE", FONT_ITALIC,
  (ustring)"struct", FONT_ITALIC,
  (ustring)"char", FONT_ITALIC,
  (ustring)"signed", FONT_ITALIC,
  (ustring)"float", FONT_ITALIC,
  (ustring)"short", FONT_ITALIC,
  (ustring)"unsigned", FONT_ITALIC,


  /* core of the keywords */
  (ustring)"extern", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"register", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"auto", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"typedef", FONT_BOLD,
  (ustring)"union", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"sizeof", FONT_BOLD,
  (ustring)"volatile", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"static", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"NULL", FONT_BOLD,
  (ustring)"FILE", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"else", FONT_BOLD,


  /* c++'s own keywords */
  (ustring)"new", FONT_BOLD,
  (ustring)"delete", FONT_BOLD,
  (ustring)"this", FONT_BOLD,
  (ustring)"operator", FONT_BOLD,
  (ustring)"class", FONT_BOLD,
  (ustring)"public", FONT_BOLD,
  (ustring)"protected", FONT_BOLD,
  (ustring)"private", FONT_BOLD,
  (ustring)"virtual", FONT_BOLD,
  (ustring)"friend", FONT_BOLD,
  (ustring)"inline", FONT_BOLD,
  (ustring)"template", FONT_BOLD,
  (ustring)"dynamic", FONT_BOLD,
  (ustring)"typeof", FONT_BOLD,
  (ustring)"all", FONT_BOLD,
  (ustring)"except", FONT_BOLD,
  (ustring)"exception", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"raises", FONT_BOLD,
  (ustring)"reraises", FONT_BOLD,
  (ustring)"try", FONT_BOLD,
  (ustring)"asm", FONT_BOLD,
  (ustring)"catch", FONT_BOLD,
  (ustring)"overload", FONT_BOLD,

   UNULL
};
const char * cpp_abbreviations[]= {
  "h++", "C", "H", "cc", "hh", "cpp", "hpp", "cxx", "hxx", "pdb", "\0"
};
const unsigned char  cpp_description[] = "";
#define cpp_style { "c++",						\
  cpp_abbreviations, cpp_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, cpp_keywords,		\
  EMPTY, c_specials, cpp_sequences, sh_verbatims, EMPTY }

/*
 *		o2c
 */
const unsigned char* o2c_sequences [] = {
  /* "real" sequences */
  (ustring)"/*", FONT_ITALIC, FONT_ITALIC, (ustring)"*/", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,

  /* Highlight special declarations */
  (ustring)"application", FONT_BOLD, FONT_BOLD, (ustring)"\n", FONT_COURIER,
  (ustring)"class", FONT_BOLD, FONT_BOLD, (ustring)"\n", FONT_COURIER,
  (ustring)"method body", FONT_BOLD, FONT_BOLD, (ustring)"in ", FONT_BOLD,
  (ustring)"transaction body", FONT_BOLD, FONT_BOLD, (ustring)"in ", FONT_BOLD,
  (ustring)"program body", FONT_BOLD, FONT_BOLD, (ustring)"in ", FONT_BOLD,
  (ustring)"program public", FONT_BOLD, FONT_BOLD, (ustring)"in ", FONT_BOLD,
  UNULL
};
const unsigned char* o2c_keywords [] = {
  /* Preprocessor */
  (ustring)"#include", FONT_BOLD,
  (ustring)"#define", FONT_BOLD,
  (ustring)"#undef", FONT_BOLD,
  (ustring)"#pragma", FONT_BOLD,
  (ustring)"#if", FONT_BOLD,
  (ustring)"#ifdef", FONT_BOLD,
  (ustring)"#ifndef", FONT_BOLD,
  (ustring)"#elif", FONT_BOLD,
  (ustring)"#else", FONT_BOLD,
  (ustring)"#error", FONT_BOLD,
  (ustring)"#line", FONT_BOLD,
  (ustring)"#ex", FONT_BOLD,
  (ustring)"#endif", FONT_BOLD,
  (ustring)"defined", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# define", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# if", FONT_BOLD,
  (ustring)"# ifdef", FONT_BOLD,
  (ustring)"# endif", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  define", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  if", FONT_BOLD,
  (ustring)"#  ifdef", FONT_BOLD,
  (ustring)"#  endif", FONT_BOLD,


  /* simple types */
  (ustring)"double", FONT_ITALIC,
  (ustring)"enum", FONT_ITALIC,
  (ustring)"void", FONT_ITALIC,
  (ustring)"int", FONT_ITALIC,
  (ustring)"long", FONT_ITALIC,
  (ustring)"FILE", FONT_ITALIC,
  (ustring)"struct", FONT_ITALIC,
  (ustring)"char", FONT_ITALIC,
  (ustring)"signed", FONT_ITALIC,
  (ustring)"float", FONT_ITALIC,
  (ustring)"short", FONT_ITALIC,
  (ustring)"unsigned", FONT_ITALIC,


  /* core of the keywords */
  (ustring)"extern", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"register", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"auto", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"typedef", FONT_BOLD,
  (ustring)"union", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"sizeof", FONT_BOLD,
  (ustring)"volatile", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"static", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"NULL", FONT_BOLD,
  (ustring)"FILE", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"else", FONT_BOLD,


  /* o2c's own keywords */
  (ustring)"class", FONT_BOLD,
  (ustring)"inherit", FONT_BOLD,
  (ustring)"public", FONT_BOLD,
  (ustring)"application", FONT_BOLD,
  (ustring)"public", FONT_BOLD,
  (ustring)"modify", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"program", FONT_BOLD,
  (ustring)"body", FONT_BOLD,
  (ustring)"method", FONT_BOLD,
  (ustring)"o2", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"new", FONT_BOLD,
  (ustring)"o2query", FONT_BOLD,
  (ustring)"name", FONT_BOLD,
  (ustring)"function", FONT_BOLD,
  (ustring)"abort", FONT_BOLD,
  (ustring)"commit", FONT_BOLD,
  (ustring)"quit", FONT_BOLD,
  (ustring)"validate", FONT_BOLD,
  (ustring)"schema", FONT_BOLD,
  (ustring)"base", FONT_BOLD,

  UNULL
};
const char * o2c_abbreviations[] = {
  "o2", "\0"
};
const unsigned char  o2c_description[] = "";
#define o2c_style { "o2c",						\
  o2c_abbreviations, o2c_description, 					\
  CASE_SENSITIVE, c_characters, c_characters, o2c_keywords,		\
    EMPTY, c_specials, o2c_sequences, sh_verbatims, EMPTY }


/************************************************************************/
/*				Tcl & Tk			   	*/
/************************************************************************/
/*
 * 		TCL
 */
const unsigned char* tcl_specials [] = {
  (ustring)"&&", (ustring)"\331", FONT_SYMBOL,
  (ustring)"||", (ustring)"\332", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"!", (ustring)"\330", FONT_SYMBOL,
  UNULL
};
const unsigned char tcl_characters [] = {
  '-', '.',
  '_', '_',
  '#', '%',
  '\0'
};
const unsigned char* tcl_sequences [] = { 
  (ustring)"#", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  UNULL
};
const unsigned char * tcl_keywords [] = {
  (ustring)"append", FONT_BOLD,
  (ustring)"array", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"catch", FONT_BOLD,
  (ustring)"cd", FONT_BOLD,
  (ustring)"close", FONT_BOLD,
  (ustring)"concat", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"eof", FONT_BOLD,
  (ustring)"error", FONT_BOLD,
  (ustring)"eval", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"expr", FONT_BOLD,
  (ustring)"file", FONT_BOLD,
  (ustring)"flush", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"foreach", FONT_BOLD,
  (ustring)"format", FONT_BOLD,
  (ustring)"gets", FONT_BOLD,
  (ustring)"glob", FONT_BOLD,
  (ustring)"global", FONT_BOLD,
  (ustring)"history", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"incr", FONT_BOLD,
  (ustring)"info", FONT_BOLD,
  (ustring)"join", FONT_BOLD,
  (ustring)"lappend", FONT_BOLD,
  (ustring)"library", FONT_BOLD,
  (ustring)"lindex", FONT_BOLD,
  (ustring)"linsert", FONT_BOLD,
  (ustring)"list", FONT_BOLD,
  (ustring)"llength", FONT_BOLD,
  (ustring)"lrange", FONT_BOLD,
  (ustring)"lreplace", FONT_BOLD,
  (ustring)"lsearch", FONT_BOLD,
  (ustring)"lsort", FONT_BOLD,
  (ustring)"open", FONT_BOLD,
  (ustring)"pid", FONT_BOLD,
  (ustring)"proc", FONT_BOLD,
  (ustring)"puts", FONT_BOLD,
  (ustring)"pwd", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"regexp", FONT_BOLD,
  (ustring)"regsub", FONT_BOLD,
  (ustring)"rename", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"scan", FONT_BOLD,
  (ustring)"seek", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"source", FONT_BOLD,
  (ustring)"split", FONT_BOLD,
  (ustring)"string", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"tell", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"time", FONT_BOLD,
  (ustring)"trace", FONT_BOLD,
  (ustring)"unknown", FONT_BOLD,
  (ustring)"unset", FONT_BOLD,
  (ustring)"uplevel", FONT_BOLD,
  (ustring)"upvar", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"elseif", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"default", FONT_BOLD,

  UNULL
};
const char * tcl_abbreviations[]= {
  "tclscript", "\0"
};
const unsigned char  tcl_description[] = "";
#define tcl_style { "tcl", 						\
  tcl_abbreviations, tcl_description, 					\
  CASE_SENSITIVE, tcl_characters, tcl_characters, tcl_keywords, 	\
  EMPTY, tcl_specials, tcl_sequences, sh_verbatims, EMPTY }

/*
 * 		tk
 */
const unsigned char* tk_keywords [] = {
  (ustring)"append", FONT_BOLD,
  (ustring)"array", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"catch", FONT_BOLD,
  (ustring)"cd", FONT_BOLD,
  (ustring)"close", FONT_BOLD,
  (ustring)"concat", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"eof", FONT_BOLD,
  (ustring)"error", FONT_BOLD,
  (ustring)"eval", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"expr", FONT_BOLD,
  (ustring)"file", FONT_BOLD,
  (ustring)"flush", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"foreach", FONT_BOLD,
  (ustring)"format", FONT_BOLD,
  (ustring)"gets", FONT_BOLD,
  (ustring)"glob", FONT_BOLD,
  (ustring)"global", FONT_BOLD,
  (ustring)"history", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"incr", FONT_BOLD,
  (ustring)"info", FONT_BOLD,
  (ustring)"join", FONT_BOLD,
  (ustring)"lappend", FONT_BOLD,
  (ustring)"library", FONT_BOLD,
  (ustring)"lindex", FONT_BOLD,
  (ustring)"linsert", FONT_BOLD,
  (ustring)"list", FONT_BOLD,
  (ustring)"llength", FONT_BOLD,
  (ustring)"lrange", FONT_BOLD,
  (ustring)"lreplace", FONT_BOLD,
  (ustring)"lsearch", FONT_BOLD,
  (ustring)"lsort", FONT_BOLD,
  (ustring)"open", FONT_BOLD,
  (ustring)"pid", FONT_BOLD,
  (ustring)"proc", FONT_BOLD,
  (ustring)"puts", FONT_BOLD,
  (ustring)"pwd", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"regexp", FONT_BOLD,
  (ustring)"regsub", FONT_BOLD,
  (ustring)"rename", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"scan", FONT_BOLD,
  (ustring)"seek", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"source", FONT_BOLD,
  (ustring)"split", FONT_BOLD,
  (ustring)"string", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"tell", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"time", FONT_BOLD,
  (ustring)"trace", FONT_BOLD,
  (ustring)"unknown", FONT_BOLD,
  (ustring)"unset", FONT_BOLD,
  (ustring)"uplevel", FONT_BOLD,
  (ustring)"upvar", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"elseif", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"after", FONT_BOLD,
  (ustring)"bind", FONT_BOLD,
  (ustring)"button", FONT_BOLD,
  (ustring)"canvas", FONT_BOLD,
  (ustring)"checkbutton", FONT_BOLD,
  (ustring)"destroy", FONT_BOLD,
  (ustring)"dialog", FONT_BOLD,
  (ustring)"entry", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"focus", FONT_BOLD,
  (ustring)"frame", FONT_BOLD,
  (ustring)"grab", FONT_BOLD,
  (ustring)"label", FONT_BOLD,
  (ustring)"lbSingSel", FONT_BOLD,
  (ustring)"listbox", FONT_BOLD,
  (ustring)"lower", FONT_BOLD,
  (ustring)"menu", FONT_BOLD,
  (ustring)"menubar", FONT_BOLD,
  (ustring)"menubutton", FONT_BOLD,
  (ustring)"message", FONT_BOLD,
  (ustring)"option", FONT_BOLD,
  (ustring)"options", FONT_BOLD,
  (ustring)"pack", FONT_BOLD,
  (ustring)"place", FONT_BOLD,
  (ustring)"radiobutton", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"scale", FONT_BOLD,
  (ustring)"scrollbar", FONT_BOLD,
  (ustring)"selection", FONT_BOLD,
  (ustring)"send", FONT_BOLD,
  (ustring)"text", FONT_BOLD,
  (ustring)"tkerror", FONT_BOLD,
  (ustring)"tkwait", FONT_BOLD,
  (ustring)"toplevel", FONT_BOLD,
  (ustring)"update", FONT_BOLD,
  (ustring)"winfo", FONT_BOLD,
  (ustring)"wm", FONT_BOLD,

   UNULL
};
const char * tk_abbreviations[]= {
  "wish", "\0"
};
const unsigned char  tk_description[] = "";
#define tk_style { "tk",  						\
  tk_abbreviations, tk_description, 					\
  CASE_SENSITIVE, tcl_characters, tcl_characters, tk_keywords, 		\
  EMPTY, c_specials, tcl_sequences, sh_verbatims, EMPTY }


/************************************************************************/
/*			Object-oriented languages		   	*/
/************************************************************************/
/*
 *		Claire
 */
const unsigned char* claire_sequences [] = {
  (ustring)";;", FONT_COURIER, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"//*", FONT_ITALIC, FONT_EMPH, (ustring)"*//", FONT_ITALIC,
  (ustring)"//", FONT_COURIER, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char claire_first_characters [] = {
  '!', '!', 
  '%', '&',
  '*', '+',
  '-', '-',
  '/', '/',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const unsigned char claire_following_characters [] = {
  '!', '!', 
  '%', '\'', /* ' may be used like x' := x + 1 */
  '*', '+',
  '-', '-',
  '/', '/',
  '^', '_',
  '<', '>',
  '|', '|', 
  '\0'
};
const unsigned char* claire_symbols [] = {
  (ustring) "forall", (ustring) "\"", FONT_SYMBOL,
  (ustring) "exists", (ustring) "$", FONT_SYMBOL,
  (ustring) "%", (ustring) "\316", FONT_SYMBOL,
  (ustring) ":=", (ustring) ":=",   FONT_COURIER,
  (ustring)"=", (ustring)"\272", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"=>", (ustring)"\336", FONT_SYMBOL,
  (ustring) "U", (ustring) "\310", FONT_SYMBOL,
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
  UNULL
};
const unsigned char* claire_specials [] = {
  (ustring) "{}", (ustring) "\306", FONT_SYMBOL,	/* empty set */
  UNULL
};
const unsigned char* claire_keywords [] = {
  (ustring)"forall", FONT_BOLD,
  (ustring)"none", FONT_BOLD,
  (ustring)"catch", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"as", FONT_BOLD,
  (ustring)"printf", FONT_BOLD,
  (ustring)"assert", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"trace", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"let", FONT_BOLD,
  (ustring)"when", FONT_BOLD,
  (ustring)"try", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"Zif", FONT_BOLD,
  (ustring)"exists", FONT_BOLD,
  (ustring)"<:", FONT_BOLD,
  (ustring)"=>", FONT_BOLD,
  (ustring)"->", FONT_BOLD,
  (ustring)"::", FONT_BOLD,

  UNULL
};
const char * claire_abbreviations[]= {
  "cl", "\0"
};
const unsigned char  claire_description[] =
"CLAIRE is a high-level functional and object-oriented language with advanced rule processing capabilities. It is intended to allow the programmer to express complex algorithms with fewer lines and in an elegant and readable manner. \n"
"To provide a high degree of expressivity, CLAIRE uses: \n"
" - A very rich type system including type intervals and second-order types (with dual static/dynamic typing),\n"
" - Parametric classes and methods, \n"
" - An object-oriented logic with set extensions, \n"
" - Dynamic versioning that supports easy exploration of search spaces. \n"
" To achieve its goal of readability, CLAIRE uses \n"
" - set-based programming with an intuitive syntax, \n"
" - simple-minded object-oriented programming, \n"
" - truly polymorphic and parametric functional programming, \n"
" - a powerful-yet-readable extension of DATALOG to express logical conditions, \n"
" - an entity-relation approach with explicit relations, inverses, unknown values and relational\n"
" - operations. \n"
"More information on claire can be found on:\n"
"http://www.ens.fr/~laburthe/claire.html\n";
#define claire_style {"claire", 				\
  claire_abbreviations, claire_description, 		\
  CASE_SENSITIVE, claire_first_characters, 			\
  claire_following_characters,	claire_keywords,		\
  claire_symbols, claire_specials, claire_sequences, sh_verbatims, EMPTY }

/*
 *		Java
 */
const unsigned char java_characters_1 [] = {
  '_', '_',
  '#', '%',
  '\0'
};
const unsigned char java_characters_2 [] = {
  '.', '.', 
  '_', '_',
  '#', '%',
  '\0'
};
const unsigned char* java_sequences [] = {
  /* doc. comments */
  (ustring)"/**", FONT_ITALIC, FONT_EMPH, (ustring)"*/", FONT_ITALIC,
  (ustring)"/*", FONT_ITALIC, FONT_ITALIC, (ustring)"*/", FONT_ITALIC,
  (ustring)"//", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  UNULL
};
const unsigned char* java_keywords [] = {
  (ustring)"one", FONT_BOLD,
  (ustring)"of", FONT_BOLD,
  (ustring)"abstract", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"private", FONT_BOLD,
  (ustring)"throw", FONT_BOLD,
  (ustring)"boolean", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"implements", FONT_BOLD,
  (ustring)"protected", FONT_BOLD,
  (ustring)"throws", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"double", FONT_BOLD,
  (ustring)"import", FONT_BOLD,
  (ustring)"public", FONT_BOLD,
  (ustring)"transient", FONT_BOLD,
  (ustring)"byte", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"instanceof", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"try", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"extends", FONT_BOLD,
  (ustring)"int", FONT_BOLD,
  (ustring)"short", FONT_BOLD,
  (ustring)"void", FONT_BOLD,
  (ustring)"catch", FONT_BOLD,
  (ustring)"final", FONT_BOLD,
  (ustring)"interface", FONT_BOLD,
  (ustring)"static", FONT_BOLD,
  (ustring)"volatile", FONT_BOLD,
  (ustring)"char", FONT_BOLD,
  (ustring)"finally", FONT_BOLD,
  (ustring)"long", FONT_BOLD,
  (ustring)"super", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"class", FONT_BOLD,
  (ustring)"float", FONT_BOLD,
  (ustring)"native", FONT_BOLD,
  (ustring)"switch", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"new", FONT_BOLD,
  (ustring)"synchronized", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"package", FONT_BOLD,
  (ustring)"this", FONT_BOLD,

  UNULL
};
const char * java_abbreviations[]= {
  "\0"
};
const unsigned char  java_description[] = "";
#define java_style {"java",						\
  java_abbreviations, java_description,			 		\
  CASE_SENSITIVE, java_characters_1, java_characters_2,	java_keywords,	\
  EMPTY, c_specials, java_sequences, sh_verbatims, EMPTY }


/*
 *		Ada
 */
const unsigned char* ada_sequences [] = {
  (ustring)"--", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char* ada_verbatims [] = {
  (ustring) "\'\'\'", UNULL
};
const unsigned char* ada_escapes [] = {
  (ustring) "\"\"", (ustring) "\\\\", (ustring) "\\\'", UNULL
};
const unsigned char ada_1_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char ada_2_characters [] = {
  '_', '_',
  '\'', '\'',           /*  L'First  is not opening in ada */
  '\0'
};
const unsigned char* ada_symbols [] = {
#if 0	/* most people do not want them */
  "and then", "and then", FONT_BOLD,	/* protect these two */
  "or else", "or else", FONT_BOLD,
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
#endif
  UNULL
};
const unsigned char* ada_specials [] = {
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"=>", (ustring)"\336", FONT_SYMBOL,
  UNULL
};
const unsigned char* ada_keywords [] = {
  (ustring)"abort", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"new", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"abs", FONT_BOLD,
  (ustring)"elsif", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"reverse", FONT_BOLD,
  (ustring)"abstract", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"null", FONT_BOLD,
  (ustring)"accept", FONT_BOLD,
  (ustring)"entry", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"access", FONT_BOLD,
  (ustring)"exception", FONT_BOLD,
  (ustring)"separate", FONT_BOLD,
  (ustring)"aliased", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"of", FONT_BOLD,
  (ustring)"subtype", FONT_BOLD,
  (ustring)"all", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"others", FONT_BOLD,
  (ustring)"tagged", FONT_BOLD,
  (ustring)"array", FONT_BOLD,
  (ustring)"function", FONT_BOLD,
  (ustring)"out", FONT_BOLD,
  (ustring)"task", FONT_BOLD,
  (ustring)"at", FONT_BOLD,
  (ustring)"terminate", FONT_BOLD,
  (ustring)"generic", FONT_BOLD,
  (ustring)"package", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"begin", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"pragma", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"body", FONT_BOLD,
  (ustring)"private", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"procedure", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"protected", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"constant", FONT_BOLD,
  (ustring)"is", FONT_BOLD,
  (ustring)"use", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"declare", FONT_BOLD,
  (ustring)"range", FONT_BOLD,
  (ustring)"when", FONT_BOLD,
  (ustring)"delay", FONT_BOLD,
  (ustring)"limited", FONT_BOLD,
  (ustring)"record", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"delta", FONT_BOLD,
  (ustring)"loop", FONT_BOLD,
  (ustring)"rem", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"digits", FONT_BOLD,
  (ustring)"renames", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"mod", FONT_BOLD,
  (ustring)"requeue", FONT_BOLD,
  (ustring)"xor", FONT_BOLD,

   UNULL 
}; 
const char * ada_abbreviations[]= {
  "adb", "ads", "\0"
};
const unsigned char  ada_description[] = "";
#define ada_style { "ada",						\
  ada_abbreviations, ada_description, 					\
  CASE_SENSITIVE, ada_1_characters, ada_2_characters, ada_keywords,	\
  ada_symbols, ada_specials, ada_sequences, ada_verbatims, ada_escapes }

/*
 *		Sather
 */
const unsigned char* sather_sequences [] = {
  (ustring)"--", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char sather_1_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char sather_2_characters [] = {
  '_', '_',
  '!', '!',
  '\0'
};
const unsigned char* sather_keywords [] = {
  /* keywords */
  (ustring)"abstract", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"any", FONT_BOLD,
  (ustring)"assert", FONT_BOLD,
  (ustring)"attr", FONT_BOLD,
  (ustring)"bind", FONT_BOLD,
  (ustring)"break!", FONT_BOLD,
  (ustring)"builtin", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"class", FONT_BOLD,
  (ustring)"clusters", FONT_BOLD,
  (ustring)"clusters!", FONT_BOLD,
  (ustring)"cohort", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"elsif", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"exception", FONT_BOLD,
  (ustring)"external", FONT_BOLD,
  (ustring)"false", FONT_BOLD,
  (ustring)"far", FONT_BOLD,
  (ustring)"fork", FONT_BOLD,
  (ustring)"guard", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"immutable", FONT_BOLD,
  (ustring)"inout", FONT_BOLD,
  (ustring)"include", FONT_BOLD,
  (ustring)"initial", FONT_BOLD,
  (ustring)"is", FONT_BOLD,
  (ustring)"ITER", FONT_BOLD,
  (ustring)"lock", FONT_BOLD,
  (ustring)"loop", FONT_BOLD,
  (ustring)"near", FONT_BOLD,
  (ustring)"new", FONT_BOLD,
  (ustring)"once", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"out", FONT_BOLD,
  (ustring)"par", FONT_BOLD,
  (ustring)"parloop", FONT_BOLD,
  (ustring)"post", FONT_BOLD,
  (ustring)"pre", FONT_BOLD,
  (ustring)"private", FONT_BOLD,
  (ustring)"protect", FONT_BOLD,
  (ustring)"quit", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"readonly", FONT_BOLD,
  (ustring)"result", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"ROUT", FONT_BOLD,
  (ustring)"SAME", FONT_BOLD,
  (ustring)"self", FONT_BOLD,
  (ustring)"shared", FONT_BOLD,
  (ustring)"sync", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"true", FONT_BOLD,
  (ustring)"typecase", FONT_BOLD,
  (ustring)"unlock", FONT_BOLD,
  (ustring)"until!", FONT_BOLD,
  (ustring)"void", FONT_BOLD,
  (ustring)"when", FONT_BOLD,
  (ustring)"while!", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"yield", FONT_BOLD,


  /* Built-in classes */
 (ustring)"BOOL", FONT_ITALIC,
  (ustring)"CHAR", FONT_ITALIC,
  (ustring)"STR", FONT_ITALIC,
  (ustring)"INT", FONT_ITALIC,
  (ustring)"INTI", FONT_ITALIC,
  (ustring)"FLT", FONT_ITALIC,
  (ustring)"FLTD", FONT_ITALIC,
  (ustring)"FLTI", FONT_ITALIC,


  /* Interfacing with fortran */
  (ustring)"F_REAL", FONT_ITALIC,
  (ustring)"F_DOUBLE", FONT_ITALIC,
  (ustring)"F_INTEGER", FONT_ITALIC,
  (ustring)"F_COMPLEX", FONT_ITALIC,
  (ustring)"F_DOUBLE_COMPLEX", FONT_ITALIC,
  (ustring)"F_LOGICAL", FONT_ITALIC,
  (ustring)"F_CHARACTER", FONT_ITALIC,
  (ustring)"F_REAL_ARR", FONT_ITALIC,
  (ustring)"F_DOUBLE_ARR", FONT_ITALIC,
  (ustring)"F_INTEGER_ARR", FONT_ITALIC,
  (ustring)"F_COMPEX_ARR", FONT_ITALIC,
  (ustring)"F_DOUBLE_COMPLEX_ARR", FONT_ITALIC,
  (ustring)"F_LOGICAL_ARR", FONT_ITALIC,


  /* Interfacing with ANSI C */
  (ustring)"C_CHAR", FONT_ITALIC,
  (ustring)"C_UNSIGNED_CHAR_PTR", FONT_ITALIC,
  (ustring)"C_UNSIGNED_CHAR", FONT_ITALIC,
  (ustring)"C_SIGNED_CHAR_PTR", FONT_ITALIC,
  (ustring)"C_SIGNED_CHAR", FONT_ITALIC,
  (ustring)"C_SHORT_PTR", FONT_ITALIC,
  (ustring)"C_SHORT", FONT_ITALIC,
  (ustring)"C_INT_PTR", FONT_ITALIC,
  (ustring)"C_INT", FONT_ITALIC,
  (ustring)"C_LONG_PTR", FONT_ITALIC,
  (ustring)"C_LONG", FONT_ITALIC,
  (ustring)"C_UNSIGNED_SHORT_PTR", FONT_ITALIC,
  (ustring)"C_UNSIGNED_SHORT", FONT_ITALIC,
  (ustring)"C_UNSIGNED_INT_PTR", FONT_ITALIC,
  (ustring)"C_UNSIGNED_INT", FONT_ITALIC,
  (ustring)"C_UNSIGNED_LONG_PTR", FONT_ITALIC,
  (ustring)"C_UNSIGNED_LONG", FONT_ITALIC,
  (ustring)"C_FLOAT_PTR", FONT_ITALIC,
  (ustring)"C_FLOAT", FONT_ITALIC,
  (ustring)"C_DOUBLE_PTR", FONT_ITALIC,
  (ustring)"C_DOUBLE", FONT_ITALIC,
  (ustring)"C_LONG_DOUBLE_PTR", FONT_ITALIC,
  (ustring)"C_LONG_DOUBLE", FONT_ITALIC,
  (ustring)"C_SIZE_T", FONT_ITALIC,
  (ustring)"C_PTR", FONT_ITALIC,
  (ustring)"C_PTRDIFF_T", FONT_ITALIC,
  (ustring)"C_CHAR_PTR", FONT_ITALIC,

  UNULL 
}; 
const unsigned char* sather_symbols [] = {
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* sather_specials [] = {
  (ustring)"/=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  UNULL
};
const char * sather_abbreviations[]= {
  "sa", "\0"
};
const unsigned char  sather_description[] = "";
#define sather_style { "sather", 					\
  sather_abbreviations, sather_description, 				\
  CASE_SENSITIVE, sather_1_characters, sather_2_characters, sather_keywords, \
  sather_symbols, sather_specials, sather_sequences, sh_verbatims, EMPTY }

/*
 *		Python
 */
const unsigned char* python_sequences [] = {
  (ustring)"#", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_ITALIC,
  (ustring)"\"\"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"\"\"", FONT_COURIER,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char python_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* python_symbols [] = {
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* python_specials [] = {
  (ustring)"<>", (ustring)"\271", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  UNULL
};
const unsigned char* python_keywords [] = {
 (ustring)"and", FONT_BOLD,
  (ustring)"elif", FONT_BOLD,
  (ustring)"from", FONT_BOLD,
  (ustring)"lambda", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"global", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"try", FONT_BOLD,
  (ustring)"class", FONT_BOLD,
  (ustring)"except", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"exec", FONT_BOLD,
  (ustring)"import", FONT_BOLD,
  (ustring)"pass", FONT_BOLD,
  (ustring)"def", FONT_BOLD,
  (ustring)"finally", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"print", FONT_BOLD,
  (ustring)"del", FONT_BOLD,
  (ustring)"is", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"for", FONT_BOLD,

  UNULL 
}; 
const char * python_abbreviations[]= {
  "pythonscript", "py", "\0"
};
const unsigned char  python_description[] = "";
#define python_style { "python", 					\
  python_abbreviations, python_description, 				\
  CASE_SENSITIVE, python_characters, python_characters, python_keywords, \
  python_symbols, python_specials, python_sequences, sh_verbatims, EMPTY }

/************************************************************************/
/*			Functional languages			   	*/
/************************************************************************/
/*
 *		caml
 */
const unsigned char* caml_sequences [] = {
  (ustring)"(*", FONT_COURIER, FONT_ITALIC, (ustring)"*)", FONT_COURIER,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  /* (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,*/
  UNULL
};
const unsigned char caml_characters_1 [] = {
  '_', '_',
  '!', '!',
  '\0'
};
const unsigned char caml_characters_2 [] = {
  '_', '_',
  '\'', '\'',
  '!', '!',
  '\0'
};
const unsigned char* caml_symbols [] = {
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* caml_specials [] = {
  (ustring)"<>", (ustring)"\271", FONT_SYMBOL,
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  UNULL
};
const unsigned char* caml_keywords [] = {
  (ustring)"and", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"as", FONT_BOLD,
  (ustring)"begin", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"done", FONT_BOLD,
  (ustring)"downto", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"exception", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"fun", FONT_BOLD,
  (ustring)"function", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"let", FONT_BOLD,
  (ustring)"match", FONT_BOLD,
  (ustring)"mutable", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"of", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"prefix", FONT_BOLD,
  (ustring)"rec", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"to", FONT_BOLD,
  (ustring)"try", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"value", FONT_BOLD,
  (ustring)"where", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"int", FONT_BOLD,
  (ustring)"char", FONT_BOLD,
  (ustring)"string", FONT_BOLD,
  (ustring)"float", FONT_BOLD,
  (ustring)"unit", FONT_BOLD,
  (ustring)"list", FONT_BOLD,
  (ustring)"raise", FONT_BOLD,
  (ustring)"bool", FONT_BOLD,
  (ustring)"vect", FONT_BOLD,

   UNULL
};
const char * caml_abbreviations[]= {
  "ml", "mli", "mll", "\0"
};
const unsigned char  caml_description[] =
  "This style should also suit other versions of ML (caml light, SML etc.)\n";
#define caml_style { "caml", 					\
  caml_abbreviations, caml_description, CASE_INSENSITIVE,	\
  caml_characters_1, caml_characters_2, caml_keywords,		\
  caml_symbols, caml_specials, caml_sequences, sh_verbatims, EMPTY }

/*
 *		common-lisp
 */
const unsigned char* clisp_sequences [] = {
  /* comments */
  (ustring)";", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_COURIER,
  /* function declaration */
  (ustring)"(defun ", FONT_BOLD, FONT_EMPH, (ustring)" ", FONT_COURIER,
  /* strings*/
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  UNULL
};
const unsigned char clisp_characters [] = {
  '_', '_',
  '-', '-',
  '\0'
};
const unsigned char* clisp_symbols [] = {
  (ustring) "lambda", (ustring) "l", FONT_SYMBOL,
  UNULL
};
const unsigned char* clisp_keywords [] = {
  (ustring)"or", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"cond", FONT_BOLD,
  (ustring)"let", FONT_BOLD,
  (ustring)"when", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"unless", FONT_BOLD,
  (ustring)"defvar", FONT_BOLD,
  (ustring)"setf", FONT_BOLD,
  (ustring)"progn", FONT_BOLD,

   UNULL
};
const char * clisp_abbreviations[]= {
  "el", "l", "lisp", "lsp", "clisp", "\0"
};
const unsigned char  clisp_description[] = "";
#define clisp_style { "common-lisp",					\
  clisp_abbreviations, clisp_description, 				\
  CASE_INSENSITIVE, clisp_characters, clisp_characters, clisp_keywords,	\
  clisp_symbols, EMPTY, clisp_sequences, sh_verbatims, EMPTY }

/*
 *		Scheme as defined at 
 * http://www-swiss.ai.mit.edu/emacs-html.local/scheme_toc.html
 */
const unsigned char* scheme_sequences [] = {
  /* comments */
  (ustring)";", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_COURIER,
  /* multiple line comments */
  (ustring)"#|", FONT_ITALIC, FONT_ITALIC, (ustring)"|#", FONT_COURIER,
  /* strings*/
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  UNULL
};
const unsigned char scheme_characters [] = {
  '!', '!',
  '#', '&',	/* # $ % & */
  '*', '+', 	/* * + */
  '-', '/',	/* - . / */
  '<', '@', 	/* < = > ? @ */
  '_', '_',
  '\0'
};
const unsigned char* scheme_symbols [] = {
  (ustring) "lambda", (ustring) "l", FONT_SYMBOL,
  UNULL
};
const unsigned char* scheme_keywords [] = {
  (ustring)"access", FONT_BOLD,
  (ustring)"define-syntax", FONT_BOLD,
  (ustring)"macro", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"delay", FONT_BOLD,
  (ustring)"make-environment", FONT_BOLD,
  (ustring)"begin", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"named-lambda", FONT_BOLD,
  (ustring)"bkpt", FONT_BOLD,
  (ustring)"fluid-let", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"quasiquote", FONT_BOLD,
  (ustring)"cond", FONT_BOLD,
  (ustring)"in-package", FONT_BOLD,
  (ustring)"quote", FONT_BOLD,
  (ustring)"cons-stream", FONT_BOLD,
  (ustring)"lambda", FONT_BOLD,
  (ustring)"scode-quote", FONT_BOLD,
  (ustring)"declare", FONT_BOLD,
  (ustring)"let", FONT_BOLD,
  (ustring)"sequence", FONT_BOLD,
  (ustring)"default-object?", FONT_BOLD,
  (ustring)"let*", FONT_BOLD,
  (ustring)"set!", FONT_BOLD,
  (ustring)"define", FONT_BOLD,
  (ustring)"let-syntax", FONT_BOLD,
  (ustring)"the-environment", FONT_BOLD,
  (ustring)"define-integrable", FONT_BOLD,
  (ustring)"letrec", FONT_BOLD,
  (ustring)"unassigned?", FONT_BOLD,
  (ustring)"define-macro", FONT_BOLD,
  (ustring)"local-declare", FONT_BOLD,
  (ustring)"using-syntax", FONT_BOLD,
  (ustring)"define-structure", FONT_BOLD,

  /* truth values */
  (ustring)"#f", FONT_EMPH,
  (ustring)"#t", FONT_EMPH,

   UNULL
};
const char * scheme_abbreviations[]= {
  "scm", "\0"
};
const unsigned char  scheme_description[] = "";
#define scheme_style { "scheme", 					\
  scheme_abbreviations, scheme_description, 				\
  CASE_INSENSITIVE, scheme_characters, scheme_characters, scheme_keywords,\
  scheme_symbols, EMPTY, scheme_sequences, sh_verbatims, EMPTY }

/*
 *		coq 5.10
 */
const unsigned char* coq_sequences [] = {
  (ustring)"(*", FONT_COURIER, FONT_ITALIC, (ustring)"*)", FONT_COURIER,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  /*  "\'", "\'", FONT_COURIER, FONT_TIMES, "\'", "\'", FONT_COURIER,*/
  /* Definition of the section is emphasized */
  (ustring)"Section", FONT_BOLD, FONT_EMPH, (ustring)".", FONT_COURIER,
  (ustring)"End", FONT_BOLD, FONT_EMPH, (ustring)".", FONT_COURIER,
  UNULL
};
const unsigned char coq_characters [] = {
  '_', '_',
  '!', '!',
  '\0'
};
const unsigned char* coq_symbols [] = {
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* coq_specials [] = {
  (ustring)"<>", (ustring)"\271", FONT_SYMBOL,
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  UNULL
};
const unsigned char * coq_keywords [] = {
  (ustring)"Require", FONT_BOLD,
  (ustring)"Declare", FONT_BOLD,


  (ustring)"with", FONT_ITALIC,

  
  (ustring)"Variable", FONT_BOLD,
  (ustring)"Inductive", FONT_BOLD,
  (ustring)"CoInductive", FONT_BOLD,
  (ustring)"Fixpoint", FONT_BOLD,
  (ustring)"CoFixpoint", FONT_BOLD,
  (ustring)"Definition", FONT_BOLD,
  (ustring)"Lemma", FONT_BOLD,
  (ustring)"Theorem", FONT_BOLD,
  (ustring)"Axiom", FONT_BOLD,
  (ustring)"Local", FONT_BOLD,
  (ustring)"Save", FONT_BOLD,
  (ustring)"Grammar", FONT_BOLD,
  (ustring)"Syntax", FONT_BOLD,

  /* Tactics */
  (ustring)"Intro", FONT_BOLD,
  (ustring)"Trivial", FONT_BOLD,
  (ustring)"Qed", FONT_BOLD,
  (ustring)"Intros", FONT_BOLD,
  (ustring)"Symmetry", FONT_BOLD,
  (ustring)"Simpl", FONT_BOLD,
  (ustring)"Rewrite", FONT_BOLD,
  (ustring)"Apply", FONT_BOLD,
  (ustring)"Elim", FONT_BOLD,
  (ustring)"Assumption", FONT_BOLD,
  (ustring)"Left", FONT_BOLD,
  (ustring)"Cut", FONT_BOLD,
  (ustring)"Case", FONT_BOLD,
  (ustring)"Auto", FONT_BOLD,
  (ustring)"Unfold", FONT_BOLD,
  (ustring)"Exact", FONT_BOLD,
  (ustring)"Right", FONT_BOLD,

  /* Types */
  (ustring)"Set", FONT_ITALIC,

   UNULL
};
const char * coq_abbreviations[] = {
  "coq", "v", "\0"
};
const unsigned char coq_description[] =
"This style is devoted to the Coq v 5.10 vernacular language.";
#define coq_style { "coq-vernacular", 				\
  coq_abbreviations, coq_description, 				\
  CASE_SENSITIVE, coq_characters, coq_characters, coq_keywords,	\
  coq_symbols, coq_specials, coq_sequences, sh_verbatims, EMPTY }

/************************************************************************/
/*			  Modula              			   	*/
/************************************************************************/
/*
 *		Pascal
 */
const unsigned char* pascal_sequences [] = {
  /* comments */
  (ustring)"(*", FONT_COURIER, FONT_ITALIC, (ustring)"*)", FONT_COURIER, 
  (ustring)"{", FONT_COURIER, FONT_ITALIC, (ustring)"}", FONT_COURIER, 
  /* char and strings litteral */
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  /* Sections in the source file */
  (ustring)"unit ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"interface", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"implementation", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"program ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  UNULL
};
const unsigned char pascal_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* pascal_symbols [] = {
  (ustring) "in", (ustring) "\316", FONT_SYMBOL,
  (ustring)"not", (ustring)"\330", FONT_SYMBOL,
  (ustring)"and", (ustring)"\331", FONT_SYMBOL,
  (ustring)"or", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* pascal_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring) ":=", (ustring) ":=",   FONT_COURIER,	/* to avoid the change of = in := */
  (ustring)"<>", (ustring)"\271", FONT_SYMBOL,
  (ustring)"=", (ustring)"\272", FONT_SYMBOL,
  UNULL
};
const unsigned char* pascal_keywords [] = {
  /* Pascal keywords */
  (ustring)"and", FONT_BOLD,
  (ustring)"array", FONT_BOLD,
  (ustring)"begin", FONT_BOLD,
  (ustring)"constructor", FONT_BOLD,
  (ustring)"const", FONT_BOLD,
  (ustring)"dec", FONT_BOLD,
  (ustring)"downto", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)"false", FONT_BOLD,
  (ustring)"file", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"function", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"halt", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"inc", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"label", FONT_BOLD,
  (ustring)"nil", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"object", FONT_BOLD,
  (ustring)"of", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"packed", FONT_BOLD,
  (ustring)"procedure", FONT_BOLD,
  (ustring)"readln", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"record", FONT_BOLD,
  (ustring)"repeat", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"shl", FONT_BOLD,
  (ustring)"shr", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"to", FONT_BOLD,
  (ustring)"true", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"until", FONT_BOLD,
  (ustring)"uses", FONT_BOLD,
  (ustring)"var", FONT_BOLD,
  (ustring)"while", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"write", FONT_BOLD,
  (ustring)"writeln", FONT_BOLD,
  (ustring)"xor", FONT_BOLD,

  /* Pascal reserved identifiers */
  (ustring)"abs", FONT_ITALIC,
  (ustring)"boolean", FONT_ITALIC,
  (ustring)"byte", FONT_ITALIC,
  (ustring)"div", FONT_ITALIC,
  (ustring)"integer", FONT_ITALIC,
  (ustring)"length", FONT_ITALIC,
  (ustring)"mod", FONT_ITALIC,
  (ustring)"odd", FONT_ITALIC,
  (ustring)"pointer", FONT_ITALIC,
  (ustring)"real", FONT_ITALIC,
  (ustring)"registers", FONT_ITALIC,
  (ustring)"string", FONT_ITALIC,
  (ustring)"text", FONT_ITALIC,
  (ustring)"trunc", FONT_ITALIC,
  (ustring)"word", FONT_ITALIC,

  UNULL
};
const char * pascal_abbreviations[]= {
  "pas", "p", "\0"
};
const unsigned char  pascal_description[] =
  "The standard Pascal is covered by this style. But some extension have been "
  "added too, hence modern Pascal programs should be correctly handled.";
#define pascal_style { "pascal",					\
  pascal_abbreviations, pascal_description, 				\
  CASE_INSENSITIVE, pascal_characters, pascal_characters, pascal_keywords, \
  pascal_symbols, pascal_specials, pascal_sequences, sh_verbatims, EMPTY }

/*
 *		Modula-3
 */
const unsigned char* modula3_sequences [] = {
  /* comments */
  (ustring)"(*", FONT_COURIER, FONT_ITALIC, (ustring)"*)", FONT_COURIER, 
  /* strings litteral */
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  /* char litteral */
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char modula3_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* modula3_symbols [] = {
  (ustring) "IN", (ustring) "\316", FONT_SYMBOL, 	/* is member of */
  (ustring)"NOT", (ustring)"\330", FONT_SYMBOL,
  (ustring)"AND", (ustring)"\331", FONT_SYMBOL,
  (ustring)"OR", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* modula3_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring) ":=", (ustring) ":=",   FONT_COURIER,	/* to avoid the change of = in := */
  (ustring)"#", (ustring)"\271", FONT_SYMBOL,
  (ustring)"=", (ustring)"\272", FONT_SYMBOL,
  UNULL
};
const unsigned char* modula3_keywords [] = {
  /* Modula 3 keywords */
  (ustring)"AND", FONT_BOLD,
  (ustring)"DO", FONT_BOLD,
  (ustring)"FROM", FONT_BOLD,
  (ustring)"NOT", FONT_BOLD,
  (ustring)"REPEAT", FONT_BOLD,
  (ustring)"UNTIL", FONT_BOLD,
  (ustring)"ANY", FONT_BOLD,
  (ustring)"ELSE", FONT_BOLD,
  (ustring)"GENERIC", FONT_BOLD,
  (ustring)"OBJECT", FONT_BOLD,
  (ustring)"RETURN", FONT_BOLD,
  (ustring)"UNTRACED", FONT_BOLD,
  (ustring)"ARRAY", FONT_BOLD,
  (ustring)"ELSIF", FONT_BOLD,
  (ustring)"IF", FONT_BOLD,
  (ustring)"OF", FONT_BOLD,
  (ustring)"REVEAL", FONT_BOLD,
  (ustring)"VALUE", FONT_BOLD,
  (ustring)"AS", FONT_BOLD,
  (ustring)"END", FONT_BOLD,
  (ustring)"IMPORT", FONT_BOLD,
  (ustring)"OR", FONT_BOLD,
  (ustring)"ROOT", FONT_BOLD,
  (ustring)"VAR", FONT_BOLD,
  (ustring)"BEGIN", FONT_BOLD,
  (ustring)"EVAL", FONT_BOLD,
  (ustring)"IN", FONT_BOLD,
  (ustring)"OVERRIDES", FONT_BOLD,
  (ustring)"SET", FONT_BOLD,
  (ustring)"WHILE", FONT_BOLD,
  (ustring)"BITS", FONT_BOLD,
  (ustring)"EXCEPT", FONT_BOLD,
  (ustring)"INTERFACE", FONT_BOLD,
  (ustring)"PROCEDURE", FONT_BOLD,
  (ustring)"THEN", FONT_BOLD,
  (ustring)"WITH", FONT_BOLD,
  (ustring)"BRANDED", FONT_BOLD,
  (ustring)"EXCEPTION", FONT_BOLD,
  (ustring)"LOCK", FONT_BOLD,
  (ustring)"RAISE", FONT_BOLD,
  (ustring)"TO", FONT_BOLD,
  (ustring)"BY", FONT_BOLD,
  (ustring)"EXIT", FONT_BOLD,
  (ustring)"LOOP", FONT_BOLD,
  (ustring)"RAISES", FONT_BOLD,
  (ustring)"TRY", FONT_BOLD,
  (ustring)"CASE", FONT_BOLD,
  (ustring)"EXPORTS", FONT_BOLD,
  (ustring)"METHODS", FONT_BOLD,
  (ustring)"READONLY", FONT_BOLD,
  (ustring)"TYPE", FONT_BOLD,
  (ustring)"CONST", FONT_BOLD,
  (ustring)"FINALLY", FONT_BOLD,
  (ustring)"MOD", FONT_BOLD,
  (ustring)"RECORD", FONT_BOLD,
  (ustring)"TYPECASE", FONT_BOLD,
  (ustring)"DIV", FONT_BOLD,
  (ustring)"FOR", FONT_BOLD,
  (ustring)"MODULE", FONT_BOLD,
  (ustring)"REF", FONT_BOLD,
  (ustring)"UNSAFE", FONT_BOLD,

  /* Modula 3 reserved identifiers */
  (ustring)"ABS", FONT_ITALIC,
  (ustring)"BYTESIZE", FONT_ITALIC,
  (ustring)"EXTENDED", FONT_ITALIC,
  (ustring)"INTEGER", FONT_ITALIC,
  (ustring)"MIN", FONT_ITALIC,
  (ustring)"NUMBER", FONT_ITALIC,
  (ustring)"TEXT", FONT_ITALIC,
  (ustring)"ADDRESS", FONT_ITALIC,
  (ustring)"CARDINAL", FONT_ITALIC,
  (ustring)"FALSE", FONT_ITALIC,
  (ustring)"ISTYPE", FONT_ITALIC,
  (ustring)"MUTEX", FONT_ITALIC,
  (ustring)"ORD", FONT_ITALIC,
  (ustring)"TRUE", FONT_ITALIC,
  (ustring)"ADR", FONT_ITALIC,
  (ustring)"CEILING", FONT_ITALIC,
  (ustring)"FIRST", FONT_ITALIC,
  (ustring)"LAST", FONT_ITALIC,
  (ustring)"NARROW", FONT_ITALIC,
  (ustring)"REAL", FONT_ITALIC,
  (ustring)"TRUNC", FONT_ITALIC,
  (ustring)"ADRSIZE", FONT_ITALIC,
  (ustring)"CHAR", FONT_ITALIC,
  (ustring)"FLOAT", FONT_ITALIC,
  (ustring)"LONGREAL", FONT_ITALIC,
  (ustring)"NEW", FONT_ITALIC,
  (ustring)"REFANY", FONT_ITALIC,
  (ustring)"TYPECODE", FONT_ITALIC,
  (ustring)"BITSIZE", FONT_ITALIC,
  (ustring)"DEC", FONT_ITALIC,
  (ustring)"FLOOR", FONT_ITALIC,
  (ustring)"LOOPHOLE", FONT_ITALIC,
  (ustring)"NIL", FONT_ITALIC,
  (ustring)"ROUND", FONT_ITALIC,
  (ustring)"VAL", FONT_ITALIC,
  (ustring)"BOOLEAN", FONT_ITALIC,
  (ustring)"DISPOSE", FONT_ITALIC,
  (ustring)"INC", FONT_ITALIC,
  (ustring)"MAX", FONT_ITALIC,
  (ustring)"NULL", FONT_ITALIC,
  (ustring)"SUBARRAY", FONT_ITALIC,

  UNULL
};
const char * modula3_abbreviations[]= {
  "m3", "\0"
};
const unsigned char  modula3_description[] = "";
#define modula3_style { "modula-3",					\
  modula3_abbreviations, modula3_description, 				\
  CASE_SENSITIVE, modula3_characters, modula3_characters, modula3_keywords, \
  modula3_symbols, modula3_specials, modula3_sequences, sh_verbatims, EMPTY }

/*
 *		Oberon
 */
const unsigned char* oberon_sequences [] = {
  /* comments */
  (ustring)"(*", FONT_COURIER, FONT_ITALIC, (ustring)"*)", FONT_COURIER, 
  /* strings litteral */
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  /* char litteral */
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  UNULL
};
const unsigned char oberon_characters [] = {
  '\0'
};
const unsigned char* oberon_symbols [] = {
  (ustring) "IN", (ustring) "\316", FONT_SYMBOL,
  (ustring)"NOT", (ustring)"\330", FONT_SYMBOL,
  (ustring)"AND", (ustring)"\331", FONT_SYMBOL,
  (ustring)"OR", (ustring)"\332", FONT_SYMBOL,
  UNULL
};
const unsigned char* oberon_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring) ":=", (ustring) ":=",   FONT_COURIER,	/* to avoid the change of = in := */
  (ustring)"#", (ustring)"\271", FONT_SYMBOL,
  (ustring)"=", (ustring)"\272", FONT_SYMBOL,
  UNULL
};
const unsigned char* oberon_keywords [] = {

  (ustring)"ARRAY", FONT_BOLD,
  (ustring)"IS", FONT_BOLD,
  (ustring)"TO", FONT_BOLD,
  (ustring)"BEGIN", FONT_BOLD,
  (ustring)"LOOP", FONT_BOLD,
  (ustring)"TYPE", FONT_BOLD,
  (ustring)"CASE", FONT_BOLD,
  (ustring)"MOD", FONT_BOLD,
  (ustring)"UNTIL", FONT_BOLD,
  (ustring)"CONST", FONT_BOLD,
  (ustring)"MODULE", FONT_BOLD,
  (ustring)"VAR", FONT_BOLD,
  (ustring)"DIV", FONT_BOLD,
  (ustring)"NIL", FONT_BOLD,
  (ustring)"WHILE", FONT_BOLD,
  (ustring)"DO", FONT_BOLD,
  (ustring)"OF", FONT_BOLD,
  (ustring)"WITH", FONT_BOLD,
  (ustring)"ELSE", FONT_BOLD,
  (ustring)"OR", FONT_BOLD,
  (ustring)"ELSIF", FONT_BOLD,
  (ustring)"POINTER", FONT_BOLD,
  (ustring)"END", FONT_BOLD,
  (ustring)"PROCEDURE", FONT_BOLD,
  (ustring)"EXIT", FONT_BOLD,
  (ustring)"RECORD", FONT_BOLD,
  (ustring)"IF", FONT_BOLD,
  (ustring)"REPEAT", FONT_BOLD,
  (ustring)"IMPORT", FONT_BOLD,
  (ustring)"RETURN", FONT_BOLD,
  (ustring)"IN", FONT_BOLD,
  (ustring)"THEN", FONT_BOLD,

  /* builtins */
  (ustring)"ABS", FONT_ITALIC,
  (ustring)"LEN", FONT_ITALIC,
  (ustring)"ASH", FONT_ITALIC,
  (ustring)"LONG", FONT_ITALIC,
  (ustring)"BOOLEAN", FONT_ITALIC,
  (ustring)"LONGINT", FONT_ITALIC,
  (ustring)"BYTE", FONT_ITALIC,
  (ustring)"LONGREAL", FONT_ITALIC,
  (ustring)"CAP", FONT_ITALIC,
  (ustring)"MAX", FONT_ITALIC,
  (ustring)"CHAR", FONT_ITALIC,
  (ustring)"MIN", FONT_ITALIC,
  (ustring)"CHR", FONT_ITALIC,
  (ustring)"NEW", FONT_ITALIC,
  (ustring)"DEC", FONT_ITALIC,
  (ustring)"ODD", FONT_ITALIC,
  (ustring)"ENTIER", FONT_ITALIC,
  (ustring)"ORD", FONT_ITALIC,
  (ustring)"EXCL", FONT_ITALIC,
  (ustring)"REAL", FONT_ITALIC,
  (ustring)"FALSE", FONT_ITALIC,
  (ustring)"SET", FONT_ITALIC,
  (ustring)"HALT", FONT_ITALIC,
  (ustring)"SHORT", FONT_ITALIC,
  (ustring)"INC", FONT_ITALIC,
  (ustring)"SHORTINT", FONT_ITALIC,
  (ustring)"INCL", FONT_ITALIC,
  (ustring)"SIZE", FONT_ITALIC,
  (ustring)"INTEGER", FONT_ITALIC,
  (ustring)"TRUE", FONT_ITALIC,

  UNULL
};
const char * oberon_abbreviations[]= {
  "\0"
};
const unsigned char  oberon_description[] = "";
#define oberon_style { "oberon",					\
  oberon_abbreviations, oberon_description, 				\
  CASE_SENSITIVE, oberon_characters, oberon_characters, oberon_keywords, \
  oberon_symbols, oberon_specials, oberon_sequences, sh_verbatims, EMPTY }
     


/************************************************************************/
/*			Specification languages			   	*/
/************************************************************************/
/*
 *		Promela
 */
const unsigned char* promela_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"&&", (ustring)"\331", FONT_SYMBOL,
  (ustring)"||", (ustring)"\332", FONT_SYMBOL,
  (ustring)"!=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  /* ! cannot be translated as not, since it is used for "send" */
  UNULL
};
const unsigned char* promela_keywords [] = {
  (ustring)"active", FONT_BOLD,
  (ustring)"assert", FONT_BOLD,
  (ustring)"atomic", FONT_BOLD,
  (ustring)"bit", FONT_BOLD,
  (ustring)"bool", FONT_BOLD,
  (ustring)"break", FONT_BOLD,
  (ustring)"byte", FONT_BOLD,
  (ustring)"chan", FONT_BOLD,
  (ustring)"d_step", FONT_BOLD,
  (ustring)"progress", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"empty", FONT_BOLD,
  (ustring)"enabled", FONT_BOLD,
  (ustring)"fi", FONT_BOLD,
  (ustring)"full", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"hidden", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"init", FONT_BOLD,
  (ustring)"int", FONT_BOLD,
  (ustring)"len", FONT_BOLD,
  (ustring)"accept", FONT_BOLD,
  (ustring)"mtype", FONT_BOLD,
  (ustring)"nempty", FONT_BOLD,
  (ustring)"never", FONT_BOLD,
  (ustring)"nfull", FONT_BOLD,
  (ustring)"od", FONT_BOLD,
  (ustring)"of", FONT_BOLD,
  (ustring)"pc_value", FONT_BOLD,
  (ustring)"printf", FONT_BOLD,
  (ustring)"proctype", FONT_BOLD,
  (ustring)"run", FONT_BOLD,
  (ustring)"short", FONT_BOLD,
  (ustring)"skip", FONT_BOLD,
  (ustring)"timeout", FONT_BOLD,
  (ustring)"typedef", FONT_BOLD,
  (ustring)"unless", FONT_BOLD,
  (ustring)"xr", FONT_BOLD,
  (ustring)"xs", FONT_BOLD,
  (ustring)"priority", FONT_BOLD,

  /* Preprocessor */
  (ustring)"#define", FONT_BOLD,
  (ustring)"#if", FONT_BOLD,
  (ustring)"#endif", FONT_BOLD,

   UNULL
};
const char * promela_abbreviations[]= {
  "pml", "\0"
};
const unsigned char  promela_description[] =
  "There is no way for a2ps to highlight send and receive primitives.";
#define promela_style { "promela", 					\
  promela_abbreviations, promela_description, 				\
  CASE_INSENSITIVE, c_characters, c_characters,	promela_keywords,	\
  EMPTY, promela_specials, c_sequences, sh_verbatims, EMPTY }

/*
 *		SDL 88
 */
const unsigned char* sdl_sequences [] = {
  (ustring)"/*", FONT_ITALIC, FONT_ITALIC, (ustring)"*/", FONT_ITALIC,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  (ustring)"(.", FONT_COURIER, FONT_COURIER, (ustring)".)", FONT_COURIER,
  (ustring)"<<", FONT_COURIER, FONT_COURIER, (ustring)">>", FONT_COURIER,
  UNULL
};
const unsigned char sdl_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* sdl_specials [] = {
  (ustring)"->", (ustring)"\256", FONT_SYMBOL,
  (ustring)"=>", (ustring)"\336", FONT_SYMBOL,
  (ustring)"/=", (ustring)"\271", FONT_SYMBOL,
  (ustring)"==", (ustring)"\272", FONT_SYMBOL,
  (ustring)"<=", (ustring)"\243", FONT_SYMBOL,
  (ustring)">=", (ustring)"\263", FONT_SYMBOL,
  (ustring)"!", (ustring)"\330", FONT_SYMBOL,
  UNULL
};
const unsigned char* sdl_keywords [] = {
  (ustring)"active", FONT_BOLD,
  (ustring)"adding", FONT_BOLD,
  (ustring)"all", FONT_BOLD,
  (ustring)"alternative", FONT_BOLD,
  (ustring)"any", FONT_BOLD,
  (ustring)"as", FONT_BOLD,
  (ustring)"atleast", FONT_BOLD,
  (ustring)"axioms", FONT_BOLD,
  (ustring)"block", FONT_BOLD,
  (ustring)"call", FONT_BOLD,
  (ustring)"channel", FONT_BOLD,
  (ustring)"comment", FONT_BOLD,
  (ustring)"connect", FONT_BOLD,
  (ustring)"connection", FONT_BOLD,
  (ustring)"constant", FONT_BOLD,
  (ustring)"constants", FONT_BOLD,
  (ustring)"create", FONT_BOLD,
  (ustring)"dcl", FONT_BOLD,
  (ustring)"decision", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"endalternative", FONT_BOLD,
  (ustring)"endblock", FONT_BOLD,
  (ustring)"endchannel", FONT_BOLD,
  (ustring)"endconnection", FONT_BOLD,
  (ustring)"enddecision", FONT_BOLD,
  (ustring)"endgenerator", FONT_BOLD,
  (ustring)"endnewtype", FONT_BOLD,
  (ustring)"endoperator", FONT_BOLD,
  (ustring)"endpackage", FONT_BOLD,
  (ustring)"endprocedure", FONT_BOLD,
  (ustring)"endprocess", FONT_BOLD,
  (ustring)"endrefinement", FONT_BOLD,
  (ustring)"endselect", FONT_BOLD,
  (ustring)"endservice", FONT_BOLD,
  (ustring)"endstate", FONT_BOLD,
  (ustring)"endsubstructure", FONT_BOLD,
  (ustring)"endsyntype", FONT_BOLD,
  (ustring)"endsystem", FONT_BOLD,
  (ustring)"enum", FONT_BOLD,
  (ustring)"env", FONT_BOLD,
  (ustring)"error", FONT_BOLD,
  (ustring)"export", FONT_BOLD,
  (ustring)"exported", FONT_BOLD,
  (ustring)"external", FONT_BOLD,
  (ustring)"fi", FONT_BOLD,
  (ustring)"finalized", FONT_BOLD,
  (ustring)"for", FONT_BOLD,
  (ustring)"fpar", FONT_BOLD,
  (ustring)"from", FONT_BOLD,
  (ustring)"gate", FONT_BOLD,
  (ustring)"generator", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"import", FONT_BOLD,
  (ustring)"imported", FONT_BOLD,
  (ustring)"in", FONT_BOLD,
  (ustring)"inherits", FONT_BOLD,
  (ustring)"input", FONT_BOLD,
  (ustring)"interface", FONT_BOLD,
  (ustring)"join", FONT_BOLD,
  (ustring)"literal", FONT_BOLD,
  (ustring)"literals", FONT_BOLD,
  (ustring)"map", FONT_BOLD,
  (ustring)"nameclass", FONT_BOLD,
  (ustring)"newtype", FONT_BOLD,
  (ustring)"nextstate", FONT_BOLD,
  (ustring)"nodelay", FONT_BOLD,
  (ustring)"noequality", FONT_BOLD,
  (ustring)"none", FONT_BOLD,
  (ustring)"now", FONT_BOLD,
  (ustring)"offspring", FONT_BOLD,
  (ustring)"operator", FONT_BOLD,
  (ustring)"operators", FONT_BOLD,
  (ustring)"ordering", FONT_BOLD,
  (ustring)"out", FONT_BOLD,
  (ustring)"output", FONT_BOLD,
  (ustring)"package", FONT_BOLD,
  (ustring)"parent", FONT_BOLD,
  (ustring)"priority", FONT_BOLD,
  (ustring)"procedure", FONT_BOLD,
  (ustring)"process", FONT_BOLD,
  (ustring)"provided", FONT_BOLD,
  (ustring)"redefined", FONT_BOLD,
  (ustring)"referenced", FONT_BOLD,
  (ustring)"refinement", FONT_BOLD,
  (ustring)"remote", FONT_BOLD,
  (ustring)"reset", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"returns", FONT_BOLD,
  (ustring)"revealed", FONT_BOLD,
  (ustring)"reverse", FONT_BOLD,
  (ustring)"save", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"self", FONT_BOLD,
  (ustring)"sender", FONT_BOLD,
  (ustring)"service", FONT_BOLD,
  (ustring)"set", FONT_BOLD,
  (ustring)"signal", FONT_BOLD,
  (ustring)"signallist", FONT_BOLD,
  (ustring)"signalroute", FONT_BOLD,
  (ustring)"signalset", FONT_BOLD,
  (ustring)"spelling", FONT_BOLD,
  (ustring)"start", FONT_BOLD,
  (ustring)"state", FONT_BOLD,
  (ustring)"stop", FONT_BOLD,
  (ustring)"struct", FONT_BOLD,
  (ustring)"substructure", FONT_BOLD,
  (ustring)"synonym", FONT_BOLD,
  (ustring)"syntype", FONT_BOLD,
  (ustring)"system", FONT_BOLD,
  (ustring)"task", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)"this", FONT_BOLD,
  (ustring)"timer", FONT_BOLD,
  (ustring)"to", FONT_BOLD,
  (ustring)"type", FONT_BOLD,
  (ustring)"use", FONT_BOLD,
  (ustring)"variant", FONT_BOLD,
  (ustring)"varstruct", FONT_BOLD,
  (ustring)"via", FONT_BOLD,
  (ustring)"view", FONT_BOLD,
  (ustring)"viewed", FONT_BOLD,
  (ustring)"virtual", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"or", FONT_BOLD,
  (ustring)"xor", FONT_BOLD,
  (ustring)"and", FONT_BOLD,
  (ustring)"mod", FONT_BOLD,
  (ustring)"rem", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"start", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"macrodefinition", FONT_BOLD,
  (ustring)"system", FONT_BOLD,
  (ustring)"priority", FONT_BOLD,
  (ustring)"=>", FONT_BOLD,
  (ustring)"/=", FONT_BOLD,
  (ustring)">", FONT_BOLD,
  (ustring)">=", FONT_BOLD,
  (ustring)"<", FONT_BOLD,
  (ustring)"<=", FONT_BOLD,
  (ustring)"+", FONT_BOLD,
  (ustring)"-", FONT_BOLD,
  (ustring)"//", FONT_BOLD,
  (ustring)"==>", FONT_BOLD,
  (ustring)"==", FONT_BOLD,
  (ustring)"->", FONT_BOLD,
  (ustring)":=", FONT_BOLD,
  (ustring)"*", FONT_BOLD,
  (ustring)":", FONT_BOLD,
  (ustring)"/", FONT_BOLD,
  (ustring)"=", FONT_BOLD,
  (ustring)"!", FONT_BOLD,

   UNULL
};
const char * sdl_abbreviations[]= {
  "pr", "sdl", "\0"
};
const unsigned char  sdl_description[] = "";
#define sdl_style { "sdl-88",						\
  sdl_abbreviations, sdl_description, 					\
  CASE_INSENSITIVE, sdl_characters, sdl_characters, sdl_keywords,	\
  EMPTY, sdl_specials, sdl_sequences, sh_verbatims, EMPTY }

/************************************************************************/
/*			         Fortran      			   	*/
/************************************************************************/
/*
 *		Fortran (Fortran 90 - with some keywords of HPF)
 *
 * For comments, we support only the free format (! anywhere on the line,
 * and not the old fixed format ^[cC*]).
 *
 */
/* Denis GIROU (CNRS/IDRIS - France) <Denis.Girou@idris.fr> - 10 Oct. 1996 */

const unsigned char* fortran_sequences [] = {
  /* comments */
  (ustring)"!", FONT_ITALIC, FONT_ITALIC, (ustring)"\n", FONT_COURIER,
  /* char and strings litteral */
  (ustring)"\'", FONT_COURIER, FONT_TIMES, (ustring)"\'", FONT_COURIER,
  (ustring)"\"", FONT_COURIER, FONT_TIMES, (ustring)"\"", FONT_COURIER,
  /* Sections in the source file */
  (ustring)"program ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"end program ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"subroutine ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"end subroutine ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"function ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"end function ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"module ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"end module ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"interface ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  (ustring)"end interface ", FONT_EMPH, FONT_EMPH, (ustring)"\n", FONT_EMPH,
  UNULL
};
const unsigned char fortran_characters [] = {
  '_', '_',
  '\0'
};
const unsigned char* fortran_specials []  = {
  /* boolean operations */
  (ustring)".not.", (ustring)"\330", FONT_SYMBOL,
  (ustring)".or.", (ustring)"\331", FONT_SYMBOL,
  (ustring)".and.", (ustring)"\332", FONT_SYMBOL,
  /* comparatives */
  (ustring)".ge.", (ustring)"\263", FONT_SYMBOL,
  (ustring) ".gt.", (ustring) ">", FONT_SYMBOL,
  (ustring)".eq.", (ustring)"\272", FONT_SYMBOL,
  (ustring)".ne.", (ustring)"\271", FONT_SYMBOL,
  (ustring) ".lt.", (ustring) "<", FONT_SYMBOL,
  (ustring)".le.", (ustring)"\243", FONT_SYMBOL,
	/* ad: je ne vois pas ce que c'est */
  (ustring) ".eqv.", (ustring) ".eqv.", FONT_BOLD,	
  (ustring) ".neqv.", (ustring) ".neqv.", FONT_BOLD,

  /* Are those really usefull
  "(/", "(/", FONT_SYMBOL,		
  "/)", "/)", FONT_SYMBOL,
  "=", "=", FONT_SYMBOL,
  (ustring)"=>", (ustring)"\336", FONT_SYMBOL,
  "::", "::", FONT_SYMBOL,
  ";", ";", FONT_SYMBOL,	*/
  UNULL
};
const unsigned char* fortran_keywords [] = {
  /* Fortran keywords */
  (ustring)"access", FONT_BOLD,
  (ustring)"align", FONT_BOLD,
  (ustring)"allocate", FONT_BOLD,
  (ustring)"assign", FONT_BOLD,
  (ustring)"backspace", FONT_BOLD,
  (ustring)"blanck", FONT_BOLD,
  (ustring)"block", FONT_BOLD,
  (ustring)"call", FONT_BOLD,
  (ustring)"case", FONT_BOLD,
  (ustring)"close", FONT_BOLD,
  (ustring)"common", FONT_BOLD,
  (ustring)"continue", FONT_BOLD,
  (ustring)"cycle", FONT_BOLD,
  (ustring)"cyclic", FONT_BOLD,
  (ustring)"data", FONT_BOLD,
  (ustring)"deallocate", FONT_BOLD,
  (ustring)"default", FONT_BOLD,
  (ustring)"define", FONT_BOLD,
  (ustring)"distribute", FONT_BOLD,
  (ustring)"doall", FONT_BOLD,
  (ustring)"do", FONT_BOLD,
  (ustring)"dynamic", FONT_BOLD,
  (ustring)"elseif", FONT_BOLD,
  (ustring)"elsewhere", FONT_BOLD,
  (ustring)"else", FONT_BOLD,
  (ustring)"endfile", FONT_BOLD,
  (ustring)"enddo", FONT_BOLD,
  (ustring)"endif", FONT_BOLD,
  (ustring)"end", FONT_BOLD,
  (ustring)"entry", FONT_BOLD,
  (ustring)"equivalence", FONT_BOLD,
  (ustring)"err", FONT_BOLD,
  (ustring)"exit", FONT_BOLD,
  (ustring)".false.", FONT_BOLD,
  (ustring)"file", FONT_BOLD,
  (ustring)"find", FONT_BOLD,
  (ustring)"forall", FONT_BOLD,
  (ustring)"form", FONT_BOLD,
  (ustring)"format", FONT_BOLD,
  (ustring)"goto", FONT_BOLD,
  (ustring)"hpf", FONT_BOLD,
  (ustring)"if", FONT_BOLD,
  (ustring)"include", FONT_BOLD,
  (ustring)"independent", FONT_BOLD,
  (ustring)"inherit", FONT_BOLD,
  (ustring)"inquire", FONT_BOLD,
  (ustring)"iostat", FONT_BOLD,
  (ustring)"mask", FONT_BOLD,
  (ustring)"namelist", FONT_BOLD,
  (ustring)"new", FONT_BOLD,
  (ustring)"no", FONT_BOLD,
  (ustring)"nullify", FONT_BOLD,
  (ustring)"onto", FONT_BOLD,
  (ustring)"pause", FONT_BOLD,
  (ustring)"private", FONT_BOLD,
  (ustring)"processors", FONT_BOLD,
  (ustring)"pure", FONT_BOLD,
  (ustring)"read", FONT_BOLD,
  (ustring)"realign", FONT_BOLD,
  (ustring)"recl", FONT_BOLD,
  (ustring)"recursive", FONT_BOLD,
  (ustring)"redistribute", FONT_BOLD,
  (ustring)"result", FONT_BOLD,
  (ustring)"return", FONT_BOLD,
  (ustring)"rewind", FONT_BOLD,
  (ustring)"select", FONT_BOLD,
  (ustring)"status", FONT_BOLD,
  (ustring)"stop", FONT_BOLD,
  (ustring)"template", FONT_BOLD,
  (ustring)"then", FONT_BOLD,
  (ustring)".true.", FONT_BOLD,
  (ustring)"unit", FONT_BOLD,
  (ustring)"where", FONT_BOLD,
  (ustring)"with", FONT_BOLD,
  (ustring)"write", FONT_BOLD,


  /* Fortran intrinsic functions */
  (ustring)"abs", FONT_BOLD,
  (ustring)"achar", FONT_BOLD,
  (ustring)"acos", FONT_BOLD,
  (ustring)"ajustl", FONT_BOLD,
  (ustring)"ajustr", FONT_BOLD,
  (ustring)"aimag", FONT_BOLD,
  (ustring)"aint", FONT_BOLD,
  (ustring)"all", FONT_BOLD,
  (ustring)"allocated", FONT_BOLD,
  (ustring)"anint", FONT_BOLD,
  (ustring)"any", FONT_BOLD,
  (ustring)"asin", FONT_BOLD,
  (ustring)"associated", FONT_BOLD,
  (ustring)"atan", FONT_BOLD,
  (ustring)"atan2", FONT_BOLD,
  (ustring)"bit_size", FONT_BOLD,
  (ustring)"btest", FONT_BOLD,
  (ustring)"ceiling", FONT_BOLD,
  (ustring)"char", FONT_BOLD,
  (ustring)"cmplx", FONT_BOLD,
  (ustring)"conjg", FONT_BOLD,
  (ustring)"cos", FONT_BOLD,
  (ustring)"cosh", FONT_BOLD,
  (ustring)"count", FONT_BOLD,
  (ustring)"cshift", FONT_BOLD,
  (ustring)"date_and_time", FONT_BOLD,
  (ustring)"dble", FONT_BOLD,
  (ustring)"digits", FONT_BOLD,
  (ustring)"dim", FONT_BOLD,
  (ustring)"dot_product", FONT_BOLD,
  (ustring)"dprod", FONT_BOLD,
  (ustring)"eoshift", FONT_BOLD,
  (ustring)"epsilon", FONT_BOLD,
  (ustring)"exp", FONT_BOLD,
  (ustring)"exponent", FONT_BOLD,
  (ustring)"floor", FONT_BOLD,
  (ustring)"fraction", FONT_BOLD,
  (ustring)"huge", FONT_BOLD,
  (ustring)"iachar", FONT_BOLD,
  (ustring)"iand", FONT_BOLD,
  (ustring)"ibclr", FONT_BOLD,
  (ustring)"ibits", FONT_BOLD,
  (ustring)"ibset", FONT_BOLD,
  (ustring)"ichar", FONT_BOLD,
  (ustring)"ieor", FONT_BOLD,
  (ustring)"index", FONT_BOLD,
  (ustring)"int", FONT_BOLD,
  (ustring)"ior", FONT_BOLD,
  (ustring)"ishft", FONT_BOLD,
  (ustring)"ishftc", FONT_BOLD,
  (ustring)"lbound", FONT_BOLD,
  (ustring)"len", FONT_BOLD,
  (ustring)"len_trim", FONT_BOLD,
  (ustring)"lge", FONT_BOLD,
  (ustring)"lgt", FONT_BOLD,
  (ustring)"lle", FONT_BOLD,
  (ustring)"llt", FONT_BOLD,
  (ustring)"log", FONT_BOLD,
  (ustring)"log10", FONT_BOLD,
  (ustring)"matmul", FONT_BOLD,
  (ustring)"max", FONT_BOLD,
  (ustring)"maxexponent", FONT_BOLD,
  (ustring)"maxloc", FONT_BOLD,
  (ustring)"maxval", FONT_BOLD,
  (ustring)"merge", FONT_BOLD,
  (ustring)"min", FONT_BOLD,
  (ustring)"minexponent", FONT_BOLD,
  (ustring)"minloc", FONT_BOLD,
  (ustring)"minval", FONT_BOLD,
  (ustring)"mod", FONT_BOLD,
  (ustring)"modulo", FONT_BOLD,
  (ustring)"mvbits", FONT_BOLD,
  (ustring)"nearest", FONT_BOLD,
  (ustring)"nint", FONT_BOLD,
  (ustring)"not", FONT_BOLD,
  (ustring)"pack", FONT_BOLD,
  (ustring)"precision", FONT_BOLD,
  (ustring)"present", FONT_BOLD,
  (ustring)"product", FONT_BOLD,
  (ustring)"radix", FONT_BOLD,
  (ustring)"random_number", FONT_BOLD,
  (ustring)"random_seed", FONT_BOLD,
  (ustring)"range", FONT_BOLD,
  (ustring)"repeat", FONT_BOLD,
  (ustring)"reshape", FONT_BOLD,
  (ustring)"rrspacing", FONT_BOLD,
  (ustring)"scale", FONT_BOLD,
  (ustring)"scan", FONT_BOLD,
  (ustring)"set_exponent", FONT_BOLD,
  (ustring)"shape", FONT_BOLD,
  (ustring)"sign", FONT_BOLD,
  (ustring)"sin", FONT_BOLD,
  (ustring)"sinh", FONT_BOLD,
  (ustring)"size", FONT_BOLD,
  (ustring)"spacing", FONT_BOLD,
  (ustring)"spread", FONT_BOLD,
  (ustring)"sqrt", FONT_BOLD,
  (ustring)"sum", FONT_BOLD,
  (ustring)"system_clock", FONT_BOLD,
  (ustring)"tan", FONT_BOLD,
  (ustring)"tanh", FONT_BOLD,
  (ustring)"tiny", FONT_BOLD,
  (ustring)"transfer", FONT_BOLD,
  (ustring)"transpose", FONT_BOLD,
  (ustring)"trim", FONT_BOLD,
  (ustring)"ubound", FONT_BOLD,
  (ustring)"unpack", FONT_BOLD,
  (ustring)"verify", FONT_BOLD,


  /* Fortran keywords for declarations */
  (ustring)"character", FONT_ITALIC,
  (ustring)"complex", FONT_ITALIC,
  (ustring)"double", FONT_ITALIC,
  (ustring)"integer", FONT_ITALIC,
  (ustring)"logical", FONT_ITALIC,
  (ustring)"real", FONT_ITALIC,
  (ustring)"allocatable", FONT_ITALIC,
  (ustring)"assignment", FONT_ITALIC,
  (ustring)"dimension", FONT_ITALIC,
  (ustring)"entry", FONT_ITALIC,
  (ustring)"external", FONT_ITALIC,
  (ustring)"implicit", FONT_ITALIC,
  (ustring)"in", FONT_ITALIC,
  (ustring)"inout", FONT_ITALIC,
  (ustring)"intent", FONT_ITALIC,
  (ustring)"intrinsic", FONT_ITALIC,
  (ustring)"kind", FONT_ITALIC,
  (ustring)"none", FONT_ITALIC,
  (ustring)"only", FONT_ITALIC,
  (ustring)"operator", FONT_ITALIC,
  (ustring)"optional", FONT_ITALIC,
  (ustring)"out", FONT_ITALIC,
  (ustring)"parameter", FONT_ITALIC,
  (ustring)"pointer", FONT_ITALIC,
  (ustring)"precision", FONT_ITALIC,
  (ustring)"private", FONT_ITALIC,
  (ustring)"public", FONT_ITALIC,
  (ustring)"recursive", FONT_ITALIC,
  (ustring)"result", FONT_ITALIC,
  (ustring)"save", FONT_ITALIC,
  (ustring)"selected_int_kind", FONT_ITALIC,
  (ustring)"selected_real_kind", FONT_ITALIC,
  (ustring)"target", FONT_ITALIC,
  (ustring)"type", FONT_ITALIC,
  (ustring)"use", FONT_ITALIC,

  UNULL
};
const char * fortran_abbreviations[]= {
  "f90", "f9", "f", "\0"
};
const unsigned char  fortran_description[] =
"For comments, we support only the free format (! anywhere on the line,"
"* and not the old fixed format ^[cC*]).\n"
"This style is to check.\n"
"Please report changes needed to Denis.Girou@idris.fr";
#define fortran_style { "fortran",					\
  fortran_abbreviations, fortran_description, 				\
  CASE_INSENSITIVE, fortran_characters, fortran_characters, fortran_keywords, \
  EMPTY, fortran_specials, fortran_sequences, sh_verbatims, EMPTY }

/************************************************************************/
/*			Assembly languages			   	*/
/************************************************************************/
/*
 *		Motorola 68000
 */
const unsigned char m68000_characters [] = {
  '.', '.',
  '\0'
};
const unsigned char* m68000_keywords [] = {
  /* Preprocessor */
  /* Preprocessor */
  (ustring)"#include", FONT_BOLD,
  (ustring)"#define", FONT_BOLD,
  (ustring)"#undef", FONT_BOLD,
  (ustring)"#pragma", FONT_BOLD,
  (ustring)"#if", FONT_BOLD,
  (ustring)"#ifdef", FONT_BOLD,
  (ustring)"#ifndef", FONT_BOLD,
  (ustring)"#elif", FONT_BOLD,
  (ustring)"#else", FONT_BOLD,
  (ustring)"#error", FONT_BOLD,
  (ustring)"#line", FONT_BOLD,
  (ustring)"#ex", FONT_BOLD,
  (ustring)"#endif", FONT_BOLD,
  (ustring)"defined", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# define", FONT_BOLD,
  (ustring)"# include", FONT_BOLD,
  (ustring)"# if", FONT_BOLD,
  (ustring)"# ifdef", FONT_BOLD,
  (ustring)"# endif", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  define", FONT_BOLD,
  (ustring)"#  include", FONT_BOLD,
  (ustring)"#  if", FONT_BOLD,
  (ustring)"#  ifdef", FONT_BOLD,
  (ustring)"#  endif", FONT_BOLD,


  (ustring)".data", FONT_BOLD,
  (ustring)".globl", FONT_BOLD,
  (ustring)".long", FONT_BOLD,
  (ustring)".skip", FONT_BOLD,
  (ustring)".text", FONT_BOLD,


  (ustring)"addw", FONT_BOLD,
  (ustring)"beq", FONT_BOLD,
  (ustring)"bgt", FONT_BOLD,
  (ustring)"ble", FONT_BOLD,
  (ustring)"bne", FONT_BOLD,
  (ustring)"bra", FONT_BOLD,
  (ustring)"bset", FONT_BOLD,
  (ustring)"btst", FONT_BOLD,
  (ustring)"clrl", FONT_BOLD,
  (ustring)"cmpl", FONT_BOLD,
  (ustring)"jmp", FONT_BOLD,
  (ustring)"jsr", FONT_BOLD,
  (ustring)"movel", FONT_BOLD,
  (ustring)"moveb", FONT_BOLD,
  (ustring)"moveml", FONT_BOLD,
  (ustring)"movew", FONT_BOLD,
  (ustring)"movw", FONT_BOLD,
  (ustring)"rte", FONT_BOLD,
  (ustring)"rts", FONT_BOLD,
  (ustring)"subw", FONT_BOLD,
  (ustring)"subql", FONT_BOLD,
  (ustring)"tstl", FONT_BOLD,

   UNULL
};
const unsigned char* m68000_sequences [] = {
  /* comments */
  (ustring)"|#", FONT_COURIER, FONT_EMPH, (ustring)"\n", FONT_COURIER,
  (ustring)"|*", FONT_COURIER, FONT_EMPH, (ustring)"\n", FONT_COURIER,
  (ustring)"|", FONT_COURIER, FONT_ITALIC, (ustring)"\n", FONT_COURIER,
  UNULL
};
const char * m68000_abbreviations[]= {
  "68000", "S", "s", "\0"
};
const unsigned char m68000_description[] =
  "This style is devoted to the assembly language of the Motorola 68000. "
  "It is still experimental. Send comments to demaille@inf.enst.fr";
#define m68000_style { "68000", 					\
  m68000_abbreviations, m68000_description, 				\
  CASE_INSENSITIVE, m68000_characters, m68000_characters, m68000_keywords,\
  EMPTY, EMPTY, m68000_sequences, sh_verbatims, EMPTY }

/************************************************************************/
/*									*/
/* 		Definition of the struct for the styles			*/
/*									*/
/************************************************************************/
/*
 * Note: HTML can be included, but works badly
 */
/* #ifdef HTML_STYLE
 *   html
 * #endif
 */

struct struct_for_highlight languages [] =
{
  ada_style,
  c_style,
  cpp_style,
  caml_style,
  claire_style,
  coq_style,
  clisp_style,
  eiffel_style,
  fortran_style,
  java_style,
  lace_style,
  m68000_style,
  mail_style,
  modula3_style,
  o2c_style,
  oberon_style,
  pascal_style,
  perl_style,
  postscript_style,
  prescript_style,
  promela_style,
  python_style,
  sather_style,
  scheme_style,
  sdl_style,
  sh_style,
  tcl_style,
  tk_style,
  zsh_style
};

int NBR_LANGUAGES = sizeof(languages) / sizeof(languages[0]);
