# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191016;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"772338", "Bozanbai\/Molodezhnyi",
"771532", "Smirnovo",
"771439", "Torgai",
"772642", "Moiynkum",
"7816", "Veliky\ Novgorod",
"772838", "Balpyk\ bi",
"771544", "Presnovka",
"772436", "Terenozek",
"7811", "Pskov",
"772634", "Zhanatas",
"772252", "Karaul",
"772154", "Botakara",
"771635", "Zhaksy",
"772545", "Ikan",
"7847", "Republic\ of\ Kalmykia",
"771135", "Zhanibek",
"7867", "Republic\ of\ North\ Ossetia",
"771459", "Kostanai\ Region",
"740", "Kaliningrad",
"772644", "Karatau",
"7843", "Republic\ of\ Tatarstan",
"77272956", "Talgar",
"772144", "Kiyevka",
"771534", "Sergeyevka",
"772779", "Narynkol",
"7863", "Rostov",
"772632", "Merke",
"771449", "Taranovskoye",
"772132", "Nurinsky\ District",
"771235", "Dossor",
"772348", "Kokpekty",
"7848", "Tolyatti",
"771542", "Kishkenekol",
"771039", "Priozersk",
"772437", "Zhosaly",
"7475", "Tambov",
"7812", "St\ Petersburg",
"772535", "Shardara",
"7494", "Kostroma",
"771145", "Karatobe\ District",
"771645", "Stepnogorsk",
"77242", "Kyzylorda",
"772935", "Zhetybai",
"772544", "Shaulder",
"771838", "Koktobe",
"77102", "Zhezkazgan",
"771134", "Zhympity",
"771430", "Arkalyk",
"7384", "Kemerovo",
"7821", "Komi\ Republic",
"771436", "Taranovskoye",
"771037", "Aktogai",
"772532", "Abai",
"771142", "Taipak",
"772439", "Aralsky\ District",
"771642", "Egendykol",
"772932", "Beineu",
"7471", "Kursk",
"771447", "Karabalyksky\ District",
"772635", "Bauyrzhan\ Mamyshuly",
"771232", "Atyrau\ Region",
"772777", "Kegen",
"771040", "Zhairem\ \(GOK\)",
"771545", "Zhambylsky\ District",
"771456", "Kachar",
"771632", "Zerenda",
"7834", "Republic\ of\ Mordovia",
"772542", "Asykata",
"772770", "Uzynagash",
"771348", "Shalkarsky\ District",
"771457", "Dzhangildinsky\ District",
"771132", "Fyodorovka",
"772776", "Shelek",
"771644", "Arshaly",
"771440", "Amangeldy",
"7815", "Murmansk",
"7472", "Belgorod",
"771446", "Uzunkolsky\ District",
"7424", "Sakhalin\ Region",
"772934", "Zhanaozen",
"772534", "Zhetysai",
"771144", "Kaztalovka",
"771036", "Balkhash",
"771535", "Novoishimski",
"771030", "Atasu",
"772725", "Otegen\ Batyra",
"77142", "Kostanai",
"771234", "Indernborski",
"771437", "Kamysty",
"772752", "Otegen\ Batyra",
"772638", "Tole\ bi",
"7818", "Arkhangelsk",
"772138", "Gabidena\ Mustafina",
"772342", "Katon\-Karagai",
"772834", "Ushtobe",
"771031", "Aksu\-Ayuly",
"7813", "Leningrad\ region",
"7851", "Astrakhan",
"772334", "Tavricheskoye",
"772842", "Kogaly",
"772771", "Kaskelen",
"771335", "Shalkar",
"7862", "Sochi",
"772433", "Aralsk",
"7842", "Ulyanovsk",
"771441", "Karabalyk",
"77145834", "Krasnogorsk",
"7841", "Penza",
"772344", "Akzhar",
"772832", "Zhansugurov",
"7846", "Samara",
"772332", "Shemonaikha",
"771451", "Sarykol",
"772148", "Molodezhnoye",
"7866", "Kabardino\-Balkarian\ Republic",
"771538", "Beskol",
"771041", "Aktau\,\ Zhezkazgan",
"7861", "Krasnodar\ Territory",
"771431", "Rudny",
"771845", "Pavlodar\ Area",
"77149", "Kostanai",
"7484", "Kaluga",
"7817", "Vologda",
"77187", "Ekibastuz",
"77245", "Kyzylorda\ Region",
"771345", "Karauylkeldy",
"771842", "Koktobe",
"7845", "Saratov",
"7394", "Republic\ of\ Tuva",
"771334", "Emba",
"771638", "Akkol",
"7865", "Stavropol\ territory",
"771043", "Zhairem",
"771453", "Auliekol",
"772548", "Shayan",
"771834", "Uspenka",
"771342", "Badamsha",
"7869", "Sevastopol",
"771138", "Zhalpaktal",
"772835", "Tekeli",
"771433", "Lisakovsk",
"7473", "Voronezh",
"77272983", "Kaskelen",
"772335", "Zyryanovsk",
"771844", "Irtyshsky\ District",
"772538", "Turara\ Ryskulova",
"771332", "Uil",
"771648", "Derzhavinsk",
"771033", "Agadyr",
"772938", "Fort\ Shevchenko",
"771832", "Irtyshsk",
"7855", "Naberezhnye\ Chelny",
"7390", "Republic\ of\ Khakassia",
"772773", "Bakanas",
"772345", "Shar",
"771238", "Miyaly",
"772431", "Zhalagash",
"736", "Simferopol",
"771443", "Borovskoi",
"7381", "Omsk",
"772772", "Kapchagai",
"772540", "Arys",
"7872", "Republic\ of\ Daghestan",
"771136", "Chapayev",
"771237", "Kulsary",
"7415", "Kamchatka\ Region",
"771130", "Peremetnoye",
"772546", "Sholakkorgan",
"771630", "Burabay",
"771434", "Denisovka",
"771636", "Shuchinsk",
"77122", "Atyrau",
"771442", "Fyodorovka",
"772639", "Saudakent",
"77279", "Almaty",
"7342", "Perm",
"772937", "Kuryk",
"771333", "Kandyagash",
"772159", "Karaganda\ Region",
"771647", "Esil",
"772341", "Ulken\ Naryn",
"771147", "Akzhaiksky\ District",
"772537", "Saryagash",
"7474", "Lipetsk",
"771032", "Karazhal",
"7495", "Moscow",
"77292", "Aktau",
"772435", "Zhanakorgan",
"771833", "Terenkol",
"7301", "Republic\ of\ Buryatia",
"7499", "Moscow",
"771454", "Karamendy",
"77252", "Shymkent",
"772841", "Kapal",
"7351", "Chelyabinsk",
"772351", "Borodulikha",
"7836", "Republic\ of\ Marij\ El",
"771539", "Beskol",
"7831", "Nizhni\ Novgorod",
"772774", "Talgar",
"7352", "Kurgan",
"7302", "Chita",
"772149", "Osakarovka",
"771444", "Uzunkol",
"771640", "Balkashino",
"7426", "Jewish\ Autonomous\ Region",
"771646", "Makinsk",
"771146", "Akzhaiksky\ District",
"772530", "Temirlanovka",
"7421", "Khabarovsk\ Territory",
"771140", "Saikhin",
"772536", "Kentau",
"772239", "Makanchi",
"771034", "Zhezdy",
"772831", "Zharkent",
"77135", "Aktobe\ Region",
"77112", "Uralsk",
"7346", "Surgut",
"7341", "Udmurtian\ Republic",
"77162", "Kokshetau\/Krasni\ Yar",
"771843", "Maisky\ District",
"7820", "Cherepovets",
"771230", "Atyrau\ Region",
"771137", "Chingirlau",
"77185", "Shaldai",
"771452", "Karasu",
"772331", "Glubokoye",
"7382", "Tomsk",
"771042", "Zharyk",
"7871", "Chechen\ Republic",
"771236", "Makhambet",
"772547", "Lenger",
"771343", "Irgiz",
"771637", "Korgalzhyn",
"7835", "Chuvashi\ Republic",
"771139", "Taskala",
"77222", "Semey",
"772353", "Novaya\ Shulba",
"7492", "Vladimir",
"771639", "Stepnyak",
"771546", "Talshik",
"771455", "Zatobolsk",
"772237", "Ayagoz",
"771540", "Kishkenekol",
"7814", "Republic\ of\ Karelia",
"7487", "Tula",
"772636", "Kordai",
"772833", "Usharal",
"7345", "Tyumen",
"772257", "Shulbinsk",
"771435", "Zhitikara",
"77273", "Almaty",
"772156", "Shakhtinsk",
"771841", "Aktogai",
"77152", "Petropavlovsk",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"7879", "Mineranye\ Vody",
"772333", "Samarskoye",
"771537", "Timiryazevo",
"772147", "Egindybulak",
"771341", "Khobda",
"7712302", "Tengizshevroil",
"7416", "Amur\ Region",
"772640", "Moiynkumsky\ District",
"771536", "Taiynsha",
"7385", "Altai\ Territory",
"771035", "Ulytau",
"7411", "Republic\ of\ Sakha",
"772146", "Karkaralinsk",
"772256", "Kainar",
"771649", "Zhaksynsky\ District",
"772432", "Shiyeli",
"771149", "Zelenovsky\ District",
"772539", "Kazygurt",
"771547", "Zhambylsky\ District",
"772236", "Beskaragai",
"772775", "Esik",
"771331", "Martuk",
"772137", "Saran",
"733", "Baikonur",
"772230", "Urdzhar",
"772637", "Sarykemer",
"772343", "Terekty",
"77212", "Karaganda",
"771831", "Zhelezinka",
"7496", "Moscow",
"7483", "Bryansk",
"771239", "Makat",
"771445", "Ubaganskoye",
"77274", "Karassaisky\ District",
"772843", "Lepsy",
"77262", "Taraz",
"7491", "Ryazan",
"7347", "Republic\ of\ Bashkortostan",
"7391", "Krasnoyarsk\ Territory",
"772839", "Sarkand",
"7383", "Novosibirsk",
"771336", "Khromtau",
"771330", "Khromtau\ District",
"771438", "Amangeldy",
"77125", "Atyrau\ Region",
"7877", "Republic\ of\ Adygeya",
"7388", "Republic\ of\ Altai",
"772339", "Kurchum",
"771836", "Sharbakty",
"7712303", "Tengizs",
"771458", "Kostanai\ Region",
"771347", "Aitekebisky\ District",
"771633", "Ereimentau",
"771531", "Bulayevo",
"771133", "Aksai",
"772641", "Akkol",
"772543", "Aqsumbe",
"7717", "Astana",
"7427", "Chukotka\ Autonomous\ District",
"7353", "Orenburg",
"7485", "Yaroslavl",
"772251", "Kurchatov",
"7833", "Kirov",
"771840", "Bayanaul",
"77106", "Satpaev",
"771448", "Oktyabrskoye",
"772759", "Almaty\ Region",
"7423", "Primorie\ territory",
"771346", "Shubarkuduk",
"772778", "Chundzha",
"771340", "Khobdinsky\ District",
"771233", "Ganyushkino",
"7343", "Ekaterinburg",
"7878", "Karachayevo\-Cherkessian\ Republic",
"771837", "Aksu",
"77132", "Aktobe\/Kargalinskoye",
"771143", "Akzhaik",
"772533", "Turkestan",
"772631", "Kulan",
"771337", "Alga",
"772131", "Abai",
"77182", "Pavlodar",
"771541", "Mamlutka",
"771643", "Atbasar",
"771038", "Shashubai",
"7873", "Ingushi\ Republic",
"772438", "Aiteke\ bi",
"772836", "Karabulak",
"7482", "Tver",
"771339", "Komsomolskoye",
"772153", "Topar",
"772830", "Alakolsky\ District",
"771231", "Akkystau",
"77272", "Almaty",
"772330", "Zyryanovsky\ District",
"772336", "Ridder",
"771839", "Akku",
"772531", "Aksukent",
"772633", "Asa",
"772347", "Kalbatau",
"771141", "Zhangala",
"771543", "Yavlenka",
"771641", "Astrakhanka",
"772757", "Akshi",
"772931", "Shetpe",
"772340", "Zaisan",
"772346", "Aksuat",
"7413", "Magadan",
"7395", "Irkutsk",
"77213", "Aktau\/Temirtau",
"7844", "Volgograd",
"771651", "Kabanbai\ Batyr",
"771349", "Shalkarsky\ District",
"772840", "Saryozek",
"771631", "Shortandy",
"771533", "Saumalkol",
"7498", "Moscow",
"77224", "Barshatas",
"772643", "Shu",
"772541", "Myrzakent",
"77282", "Taldykorgan",
"771131", "Darinskoye",
"772337", "Serebryansk",
"7486", "Orel",
"77232", "Ust\-Kamenogorsk",
"772837", "Kabanbai",
"7481", "Smolensk",};
$areanames{ru} = {"772353", "Бородулихинский\ р\-н",
"77222", "Семипалатинск",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771139", "Таскалинский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"7492", "Владимирская\ обл\.",
"7487", "Тульская\ обл\.",
"7814", "Республика\ Карелия",
"771540", "Уалихановский\ р\-н",
"771455", "Костанайский\ р\-н",
"772237", "Аязог",
"771546", "Акжарский\ р\-н",
"772636", "Кордай",
"772156", "Шахтинск",
"771435", "Житикаринский\ р\-н",
"772257", "Шульбинск",
"77273", "Алма\-Ата",
"772833", "Алакольский\ р\-н",
"7345", "Тюменская\ обл\.",
"7349", "Ямало\-Ненецкий\ АО",
"77152", "Петропавловск",
"771841", "Актогайский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"7879", "Ставропольский\ край",
"771341", "Хобдинский\ р\-н",
"772147", "Каркаралинский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"7416", "Амурская\ обл\.",
"7712302", "Тенгизшевройл",
"772146", "Каркаралинск",
"7411", "Республика\ Саха\ \/Якутия\/",
"771035", "Улытауский\ р\-н",
"7385", "Алтайский\ край",
"771536", "Тайыншинский\ р\-н",
"772432", "Шиелийский\ р\-н",
"771649", "Жаксынский\ р\-н",
"772256", "Алгабас",
"772539", "Казыгурт",
"771149", "Акжаикский\ р\-н",
"772230", "Урджарский\ р\-н",
"733", "Байконыр",
"772137", "Сарань",
"771331", "Мартукский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772343", "Курчумский\ р\-н",
"772637", "Байзакский\ р\-н",
"771239", "Макатский\ р\-н",
"7483", "Брянская\ обл\.",
"7496", "г\.\ Москва",
"771831", "Железинский\ р\-н",
"77212", "Караганда",
"7491", "Рязанская\ обл\.",
"77262", "Тараз",
"772843", "Лепсы",
"771445", "Алтынсаринский\ р\-н",
"77274", "Карасайский\ р\-н",
"771130", "Зеленовский\ р\-н",
"772546", "Шолаккорган",
"771237", "Жылыойский\ р\-н",
"7415", "Камчатский\ край",
"7872", "Республика\ Дагестан",
"771136", "Акжаикский\ р\-н",
"772540", "Арыс",
"772772", "Капчагай",
"7381", "Омская\ обл\.",
"771636", "Щучинский\ р\-н",
"771434", "Денисовский\ р\-н",
"771630", "Боровое",
"77122", "Атырау",
"7342", "Пермский\ край",
"77279", "Алматы",
"771442", "Федоровский\ р\-н",
"772639", "Сарысуский\ р\-н",
"771647", "Есильский\ р\-н",
"772159", "Карагандинская\ область",
"771333", "Мугалжарский\ р\-н",
"772937", "Каракиянский\ р\-н",
"771032", "Каражал",
"7474", "Липецкая\ обл\.",
"772537", "Сарыагаш",
"771147", "Акжаикский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"771833", "Качирский\ р\-н",
"7495", "Московская\ обл\.",
"772435", "Жанакорганский\ р\-н",
"77292", "Актау",
"7351", "Челябинская\ обл\.",
"772841", "Аксуский\ р\-н",
"7499", "г\.\ Москва",
"771454", "Наурзумский\ р\-н",
"7301", "Республика\ Бурятия",
"77252", "Шымкент",
"7836", "Республика\ Марий\ Эл",
"772351", "Бородулихинский\ р\-н",
"7302", "Забайкальский\ край",
"772149", "Осакаровский\ р\-н",
"7352", "Курганская\ обл\.",
"772774", "Талгарский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771539", "Кызылжарский\ р\-н",
"771646", "Буландинский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"771640", "Сандыктауский\ р\-н",
"771444", "Узункольский\ р\-н",
"772536", "Кентау",
"771140", "Бокейординский\ р\-н",
"7421", "Хабаровский\ край",
"771146", "Акжаикский\ р\-н",
"772530", "Темирлановка",
"77135", "Актюбинская\ область",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"77112", "Уральск",
"772831", "Панфиловский\ р\-н",
"771034", "Улытауский\ р\-н",
"772239", "Урджарский\ р\-н",
"7820", "Вологодская\ обл\.",
"771843", "Майский\ р\-н",
"7341", "Республика\ Удмуртская",
"77162", "Кокшетау",
"772547", "Ленгер",
"771042", "Акой",
"7871", "Республика\ Чеченская",
"771236", "Махамбетский\ р\-н",
"7382", "Томская\ обл\.",
"772331", "Глубоковский\ р\-н",
"77185", "Шалдай",
"771452", "Карасуский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"771230", "Атырауская\ область",
"771637", "Коргалжынский\ р\-н",
"771343", "Иргизский\ р\-н",
"772438", "Казалинский\ р\-н",
"772830", "Алакольский\ р\-н",
"772153", "Абайский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"7482", "Тверская\ обл\.",
"772836", "Ескельдинский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"772336", "Риддер",
"772330", "Зыряновский\ р\-н",
"77272", "Алма\-Ата",
"771231", "Исатайский\ р\-н",
"771141", "Жангалинский\ р\-н",
"772347", "Жарминский\ р\-н",
"772633", "Жамбылский\ р\-н",
"772531", "Аксукент",
"772931", "Мангистауский\ р\-н",
"772757", "Акший",
"771641", "Астраханский\ р\-н",
"771543", "Есильский\ р\-н",
"7413", "Магаданская\ обл\.",
"772346", "Тарбагатайский\ р\-н",
"772340", "Зайсанский\ р\-н",
"7844", "Волгоградская\ обл\.",
"77213", "Темиртау",
"7395", "Иркутская\ обл\.",
"772840", "Кербулакский\ р\-н",
"771349", "Шалкарский\ р\-н",
"771651", "Целиноградский\ р\-н",
"77224", "Эмельтау",
"7498", "Московская\ обл\.",
"771533", "Айыртауский\ р\-н",
"771631", "Шортандинский\ р\-н",
"772337", "Серебрянск",
"771131", "Зеленовский\ р\-н",
"77282", "Талдыкорган",
"772541", "Мырзакент",
"772643", "Шуский\ р\-н",
"7493", "Ивановская\ обл\.",
"7486", "Орловская\ обл\.",
"7481", "Смоленская\ обл\.",
"772837", "Алакольский\ р\-н",
"77232", "Усть\-Каменогорск",
"7391", "Красноярский\ край",
"7347", "Республика\ Башкортостан",
"771330", "Хромтауский\ р\-н",
"771336", "Хромтауский\ р\-н",
"7383", "Новосибирская\ обл\.",
"772839", "Саркандский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772339", "Курчумский\ р\-н",
"7388", "Республика\ Алтай",
"7877", "Республика\ Адыгея",
"77125", "Атырауская\ область",
"771531", "Магжана\ Жумабаева\ р\-н",
"771633", "Ерейментауский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"7712303", "Тензиз",
"771458", "Костанайская\ область",
"772543", "Аксумбе",
"772641", "Таласский\ р\-н",
"771133", "Бурлинский\ р\-н",
"7485", "Ярославская\ обл\.",
"7353", "Оренбургская\ обл\.",
"7427", "Чукотский\ АО",
"7717", "Астана",
"772251", "Курчатов",
"77106", "Сатпаев",
"771840", "Баянаульский\ р\-н",
"7833", "Кировская\ обл\.",
"772759", "Алматинская\ область",
"771448", "Карасуский\ р\-н",
"771340", "Хобдинский\ р\-н",
"772778", "Уйгурский\ р\-н",
"771346", "Темирский\ р\-н",
"7423", "Приморский\ край",
"771233", "Курмангазинский\ р\-н",
"7343", "Свердловская\ обл",
"77132", "Актобе\/Актюбинск",
"771837", "Аксуский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"772631", "Турара\ Рыскулова\ р\-н",
"772533", "Туркестан",
"771143", "Теректинский\ р\-н",
"7873", "Республика\ Ингушетия",
"771643", "Атбасарский\ р\-н",
"771038", "Сыры\-Шаган",
"771541", "Мамлютский\ р\-н",
"77182", "Павлодар",
"772131", "Абайский\ р\-н",
"771337", "Алгинский\ р\-н",
"771134", "Сырымский\ р\-н",
"77102", "Жезказган",
"771838", "Майский\ р\-он",
"772544", "Шаульдер",
"771436", "Тарановский\ р\-н",
"7821", "Республика\ Коми",
"7384", "Кемеровская\ обл\.",
"771430", "Аркалык",
"771142", "Акжаикский\ р\-н",
"772532", "Абая",
"771037", "Актогайский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"772439", "Аральский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"7471", "Курская\ обл\.",
"772635", "Жуалынский\ р\-н",
"771456", "Качар",
"771545", "Жамбылский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"772777", "Райымбекский\ р\-н",
"771232", "Атырауская\ область",
"7834", "Республика\ Мордовия",
"771632", "Зерендинский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"771132", "Теректинский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"771348", "Шалкарский\ р\-н",
"772770", "Жамбылский\ р\-н",
"772542", "Асыката",
"772934", "Жанаозен",
"7424", "Сахалинская\ обл\.",
"7472", "Белгородская\ обл\.",
"771446", "Узункольский\ р\-н",
"7815", "Мурманская\ обл\.",
"771440", "Амангельдинский\ р\-н",
"771644", "Аршалынский\ р\-н",
"771144", "Казталовский\ р\-н",
"772534", "Жетысай",
"771030", "Жана\-Аркинский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771036", "Балхаш",
"772725", "Отеген\-Батыр",
"77142", "Костанай",
"771234", "Индерский\ р\-н",
"771437", "Камыстинский\ р\-н",
"771532", "Аккайынский\ р\-н",
"772338", "Уланский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"771544", "Жамбылский\ р\-н",
"772838", "Коксуский\ р\-н",
"7816", "Новгородская\ обл\.",
"772252", "Абайский\ р\-н",
"772634", "Жанатас",
"7811", "Псковская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"771635", "Жаксынский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"771135", "Жанибекский\ р\-н",
"7847", "Республика\ Калмыкия",
"772545", "Икан",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771459", "Костанайская\ область",
"772644", "Таласский\ р\-н",
"740", "Калининградская\ обл\.",
"772779", "Райымбекский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"772144", "Нуринский\ р\-н",
"77272956", "Талгар",
"7843", "Республика\ Татарстан",
"772632", "Меркенский\ р\-н",
"771449", "Тарановский\ р\-н",
"7863", "Ростовская\ обл\.",
"771542", "Уалихановский\ р\-н",
"7848", "Самарская\ обл\.",
"772348", "Кокпектинский\ р\-н",
"771235", "Макатский\ р\-н",
"772132", "Нуринский\ р\-н",
"771039", "Приозерск",
"7812", "г\.\ Санкт\-Петербург",
"7475", "Тамбовская\ обл\.",
"772437", "Кармакшинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"772535", "Шардара",
"7494", "Костромская\ обл\.",
"77242", "Кызылорда",
"772935", "Каракиянский\ р\-н",
"771645", "Степногорск",
"771334", "Мугалжарский\ р\-н",
"7394", "Республика\ Тыва",
"7845", "Саратовская\ обл\.",
"771842", "Майский\ р\-он",
"771453", "Аулиекольский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"7865", "Ставропольский\ край",
"771638", "Аккольский\ р\-н",
"771138", "Казталовский\ р\-н",
"7869", "г\.\ Севастополь",
"771342", "Каргалинский\ р\-н",
"771834", "Успенский\ р\-н",
"772548", "Шаян",
"771433", "Лисаковск",
"772835", "Текели",
"77272983", "Каскелен",
"7473", "Воронежская\ обл\.",
"772335", "Зыряновск",
"771332", "Уилский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"771844", "Иртышский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"771033", "Шетский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771832", "Иртышский\ р\-н",
"7855", "Республика\ Татарстан",
"772773", "Балхашский\ р\-н",
"7390", "Республика\ Хакасия",
"771238", "Кзылкогинский\ р\-н",
"772345", "Жарминский\ р\-н",
"736", "Республика\ Крым",
"772431", "Жалагашский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"7818", "Архангельская\ обл\.",
"772638", "Шуский\ р\-н",
"772752", "Илийский\ р\-н",
"771031", "Шетский\ р\-н",
"772834", "Каратальский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"7851", "Астраханская\ обл\.",
"7813", "Ленинградская\ обл\.",
"772842", "Кербулакский\ р\-н",
"772334", "Уланский\ р\-н",
"771335", "Шалкарский\ р\-н",
"772771", "Карасайский\ р\-н",
"7862", "Краснодарский\ край",
"7842", "Ульяновская\ обл\.",
"772433", "Аральский\ р\-н",
"77145834", "Красногорск",
"771441", "Карабалыкский\ р\-н",
"772832", "Аксуский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"7841", "Пензенская\ обл\.",
"7846", "Самарская\ обл\.",
"771041", "Актау\,\ Жезказган",
"7866", "Республика\ Кабардино\-Балкарская",
"771538", "Кызылжарский\ р\-н",
"772148", "Осакаровский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"7861", "Краснодарский\ край",
"771431", "Рудный",
"77149", "Костанай",
"771845", "Павлодар",
"77245", "Кызылординская\ область",
"7817", "Вологодская\ обл\.",
"77187", "Экибастуз",
"7484", "Калужская\ обл\.",
"771345", "Байганинский\ р\-н",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;