package JIRA::REST::Class::Project::Version;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.02';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a version of a JIRA project as an object.

__PACKAGE__->mk_data_ro_accessors(qw/ archived id name projectId released self /);

use overload
    '""'   => sub { shift->name    },
    '0+'   => sub { shift->id      },
    'bool' => sub { shift->subtask },
    '<=>'  => sub {
        my($A, $B) = @_;
        my $AA = ref $A ? $A->id : $A;
        my $BB = ref $B ? $B->id : $B;
        $AA <=> $BB
    },
    'cmp'  => sub {
        my($A, $B) = @_;
        my $AA = ref $A ? $A->name : $A;
        my $BB = ref $B ? $B->name : $B;
        $AA cmp $BB
    };

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Project::Version - A helper class for C<JIRA::REST::Class> that represents a version of a JIRA project as an object.

=head1 VERSION

version 0.02

=head1 READ-ONLY ACCESSORS

=head2 B<archived>
A boolean indicating whether the version is archived.

=head2 B<id>
The id of the project version.

=head2 B<name>
The name of the project version.

=head2 B<projectId>
The ID of the project this is a version of.

=head2 B<released>
A boolean indicating whether the version is released.

=head2 B<self>
Returns the JIRA REST API URL of the project version.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
