# Generated by default/object.tt
package Paws::DLM::LifecyclePolicySummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has PolicyId => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::DLM::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DLM::LifecyclePolicySummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DLM::LifecyclePolicySummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DLM::LifecyclePolicySummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Summary information about a lifecycle policy.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the lifecycle policy.


=head2 PolicyId => Str

The identifier of the lifecycle policy.


=head2 State => Str

The activation state of the lifecycle policy.


=head2 Tags => L<Paws::DLM::TagMap>

The tags.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DLM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

