# Generated by default/object.tt
package Paws::MediaTailor::SpliceInsertMessage;
  use Moose;
  has AvailNum => (is => 'ro', isa => 'Int');
  has AvailsExpected => (is => 'ro', isa => 'Int');
  has SpliceEventId => (is => 'ro', isa => 'Int');
  has UniqueProgramId => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::SpliceInsertMessage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::SpliceInsertMessage object:

  $service_obj->Method(Att1 => { AvailNum => $value, ..., UniqueProgramId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::SpliceInsertMessage object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailNum

=head1 DESCRIPTION

Splice insert message configuration.

=head1 ATTRIBUTES


=head2 AvailNum => Int

This is written to splice_insert.avail_num, as defined in section
9.7.3.1 of the SCTE-35 specification. The default value is 0. Values
must be between 0 and 256, inclusive.


=head2 AvailsExpected => Int

This is written to splice_insert.avails_expected, as defined in section
9.7.3.1 of the SCTE-35 specification. The default value is 0. Values
must be between 0 and 256, inclusive.


=head2 SpliceEventId => Int

This is written to splice_insert.splice_event_id, as defined in section
9.7.3.1 of the SCTE-35 specification. The default value is 1.


=head2 UniqueProgramId => Int

This is written to splice_insert.unique_program_id, as defined in
section 9.7.3.1 of the SCTE-35 specification. The default value is 0.
Values must be between 0 and 256, inclusive.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

