*
* $Id: corset.F,v 1.1.1.1 1996/04/01 15:02:56 mclareni Exp $
*
* $Log: corset.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:56  mclareni
* Mathlib gen
*
*
      SUBROUTINE CORSET (V,C,NP)
C         Correlated Gaussian random number package
C
C         CORSET sets up the generation
C         CORGEN actually generates a set of NP random numbers
C                Gaussian-distributed with covariance matrix V
C                and mean values zero.
C
C         NP is dimension of vectors and matrices
C         V(NP,NP) is covariance matrix 
C         C(NP,NP) is working space used internally to hold the
C                  'square root' of V
C         X(NP) is the vector of random numbers generated by CORGEN
C
      DIMENSION V(NP,NP), C(NP,NP)
C
C               Compute C = square root of matrix V
      DO 40 J=1,NP
C               Diagonal terms
      CK = 0.
         DO 10 K= 1, J-1
   10    CK = CK + C(J,K)*C(J,K)
      C(J,J) = SQRT(ABS(V(J,J) - CK))
C
C               Off-diagonal terms
      DO 30 I= J+1, NP
         CK = 0.
         DO 20 K= 1, J-1
   20    CK = CK + C(I,K)*C(J,K)
      C(I,J) = (V(I,J) - CK) /C(J,J)
   30 CONTINUE
   40 CONTINUE
C
      RETURN
      END
