*
* $Id: c328m.F,v 1.1.1.1 1996/04/01 15:01:17 mclareni Exp $
*
* $Log: c328m.F,v $
* Revision 1.1.1.1  1996/04/01 15:01:17  mclareni
* Mathlib gen
*
*
      SUBROUTINE C328M
C     Test the MATHLIB routines CWHITM and WWHITM (C328)
C     Set the number of tests
      PARAMETER ( NT=4 )
*
* $Id: def64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: def64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
*
* def64.inc
*
      DOUBLE PRECISION
     +      ERROR(NT),ERRMAX
*
* $Id: defc64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: defc64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
* defc64.inc
*
      COMPLEX*16
     +      WWHITM
      REAL  SERROR(NT),SERRMAX
      COMPLEX SZ(NT),SKA(NT),SMU(NT),SEXACT(NT),SSOL(NT)
*
* $Id: defc64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: defc64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
* defc64.inc
*
      COMPLEX*16
     +      Z(NT),KA(NT),MU(NT),EXACT(NT),SOL(NT)
      COMPLEX CWHITM
C     Set maximum error allowed for test to be considered successful
      PARAMETER ( TSTERR=1D-12)
      PARAMETER (STSTERR=1D-6 )
      LOGICAL LTEST
*
* $Id: iorc.inc,v 1.1.1.1 1996/04/01 15:01:31 mclareni Exp $
*
* $Log: iorc.inc,v $
* Revision 1.1.1.1  1996/04/01 15:01:31  mclareni
* Mathlib gen
*
*
*
* iorc.inc
*
      COMMON/IOLUNS/LIN,LOUT
      COMMON/GTSTAT/NTEST,NFAIL,IRC
C     Set up the test parameters EXACT holds analytical solution
      DATA KA(1),MU(1),Z(1) / (1,0),         (2,0),   (5,-3) /
      DATA KA(2),MU(2),Z(2) / (-2.25D0,0D0), (-0.25D0,0D0), (0D0,2D0) /
      DATA SKA(2),SMU(2),SZ(2)/(-2.25E0,0E0),(-0.25E0,0E0), (0E0,2E0) /
      DATA KA(3),MU(3),Z(3) / (3,5), (1,1), (-2,6) /
      DATA KA(4),MU(4),Z(4) / (3,5), (1,1), (-2,4) /
      DATA EXACT(1) /( 0.768837780746D+01, -0.402275799430D+02) /
      DATA EXACT(2) /(-0.102761073680D+02, -0.338630674302D+01) /
      DATA EXACT(3) /( 0.133052729239D+03,  0.713294437705D+03) /
      DATA EXACT(4) /(-0.896279277944D+02,  0.848021596620D+02) /
      CALL HEADER('C328',0)
C     Compare the computed results with exact results for a selection
C     of values
      ERRMAX=0D0
      SERRMAX=0E0
      LTEST=.TRUE.
      DO 100 I=1,NT
      SEXACT(I)=EXACT(I)
      IF (I .NE.2) THEN
      SZ(I)=Z(I)
      SKA(I)=KA(I)
      SMU(I)=MU(I)
      ENDIF
         WRITE(LOUT,'(/'' Test number'',I3/)') I
         SOL(I)=WWHITM(Z(I),KA(I),MU(I))
         ERROR(I)=ABS( (SOL(I)-EXACT(I))/SOL(I) )
         WRITE(LOUT,'('' Calculated   '',2F25.16)') SOL(I)
         WRITE(LOUT,'('' Exact        '',2F25.16)') EXACT(I)
         WRITE(LOUT,'('' Rel error    '',4X,1P,D10.1)') ERROR(I)
         ERRMAX=MAX( ERRMAX,ERROR(I) )
         LTEST= LTEST .AND. ERRMAX .LE. TSTERR
         WRITE(LOUT,'(/'' Test of Single Precision Routine''/)')
        SSOL(I)=CWHITM(SZ(I),SKA(I),SMU(I))
        SERROR(I)=ABS( (SSOL(I)-SEXACT(I))/SSOL(I) )
         WRITE(LOUT,'('' Calculated   '',2X,2F15.8)') SSOL(I)
         WRITE(LOUT,'('' Exact        '',2X,2F15.8)') SEXACT(I)
         WRITE(LOUT,'('' Rel error    '',4X,1P,D10.1)') SERROR(I)
         SERRMAX=MAX( SERRMAX,SERROR(I) )
         LTEST= LTEST .AND. SERRMAX .LE. STSTERR
 100  CONTINUE
      WRITE(LOUT,'(/''Double Precision largest Error'',1P,D10.1)')ERRMAX
      WRITE(LOUT,'(''Single Precision largest Error'',1P,D10.1)')SERRMAX
      WRITE(LOUT,'(/''TESTING ERROR MESSAGES:''/)')
      SSOL(NT)=CWHITM((-.5E0,0E0),(.5E0,.5E0),(.5E0,.5E0))
      SSOL(NT)=CWHITM((.5E0,.5E0),(.5E0,.5E0),(-.5E0,0E0))
      SOL(NT)=WWHITM((-.5D0,0D0),(.5D0,.5D0),(.5D0,.5D0))
      SOL(NT)=WWHITM((.5D0,.5D0),(.5D0,.5D0),(-.5D0,0D0))
      WRITE(LOUT,'(1X)')
C     Check if the test was successful
      IRC=ITEST('C328',LTEST)
      CALL PAGEND('C328')
      RETURN
      END
