/*
 * @(#)ws_errmsg.h	1.4 06/18/99 CERN IT-PDP/IP Aneta Baran
 */

/*
 * Copyright (C) 1990-1998 by CERN/IT/PDP/IP
 * All rights reserved
 */


#ifndef WS_ERRMSG_H
#define WS_ERRMSG_H
#if defined(_WIN32)
#include <winsock2.h>
#include <stdio.h>

char *ws_errmsg[] = {
   "No error - operation completed successfully.", 	/* 10000 */
   "", "", "",
   "Interrupted system call.", 				/* 10004 WSAEINTR */ 
   "", "", "", "",					
   "Bad file number",					/* 10009 WSAEBADF */ 
   "", "", "",						
   "Permission denied", 				/* 10013 WSAEACCES */
   "Bad address",					/* 10014 WSAEFAULT */
   "", "", "", "", "", "", "",				
   "Invalid argument",					/* 10022 WSAEINVAL */
   "",							
   "Too many open files",				/* 10024 WSAEMFILE */
   "", "", "", "", "", "", "", "", "", "", "", 		
   "Operation would block", 				/* 10035 WSAEWOULDBLOCK */
   "Operation now in progress", 			/* 10036 WSAEINPROGRESS */
   "Operation already in progress",			/* 10037 WSAEALREADY */
   "Socket operation on non-socket",			/* 10038 WSAENOTSOCK */
   "Destination address required",			/* 10039 WSAEDESTADDRREQ */
   "Message too long",					/* 10040 WSAEMSGSIZE */
   "Protocol wrong type for sockets",			/* 10041 WSAEPROTOTYPE */
   "Protocol not available", 				/* 10042 WSAENOPROTOOPT */
   "Protocol not supported",				/* 10043 WSAEPROTONOSUPPORT */
   "Socket type not supported",				/* 10044 WSAESOCKTNOSUPPORT */
   "Operation not supported on socket",			/* 10045 WSAEOPNOTSUPP */
   "Protocol family not supported",     		/* 10046 WSAEPFNOSUPPORT */
   "Address family not supported by protocol family",	/* 10047 WSAEAFNOSUPPORT */
   "Address already in use",				/* 10048 WSAEADDRINUSE */
   "Cannot assign requested address",			/* 10049 WSAEADDRNOTAVAIL */
   "Network is down",					/* 10050 WSAENETDOWN */
   "Network is unreachable", 				/* 10051 WSAENETUNREACH */
   "Network dropped connection on reset",		/* 10052 WSAENETRESET */
   "Software caused connection abort",			/* 10053 WSAECONNABORTED */
   "Connection reset by peer",				/* 10054 WSAECONNRESET */
   "No buffer space available",				/* 10055 WSAENOBUFS */
   "Socket is already connected",			/* 10056 WSAEISCONN */
   "Socket is not connected",				/* 10057 WSAENOTCONN */
   "Can't send after socket shutdown",			/* 10058 WSAESHUTDOWN */
   "Too many references: cannot splice",		/* 10059 WSAETOOMANYREFS */
   "Connection timed out",				/* 10060 WSAETIMEDOUT */
   "Connection refused",				/* 10061 WSAECONNREFUSED*/
   "Too many levels of symbolic link",			/* 10062 WSAELOOP */
   "File name too long",				/* 10063 WSAENAMETOOLONG */
   "Host is down",					/* 10064 WSAEHOSTDOWN */
   "No route to host",					/* 10065 WSAEHOSTUNREACH */
   "Directory not empty",				/* 10066 WSAENOTEMPTY */
   "Too many processes",				/* 10067 WSAEPROCLIM */
   "Too many users",					/* 10068 WSAEUSERS */
   "Disc quota exceed",					/* 10069 WSAEDQUOT */
   "No filesystem",					/* 10070 WSAESTALE */
   "Item is not local to host",				/* 10071 WSAEREMOTE */
   "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
   "Network subsystem is unavailable",			/* 10091 WSASYSNOTREADY */ 
   "WINSOCK.DLL version out of range",			/* 10092 WSAVERNOTSUPPORTED */ 
   "Successful WSAStartup not yet performed",		/* 10093 WSANOTINITIALISED */ 
   "", "", "", "", "", "", "",				 
   "Graceful shutdown in progress",			/* 10101 WSAEDISCON */ 
   "WSAENOMORE",					/* 10102 WSAENOMORE */ 
   "WSAECANCELLED",					/* 10103 WSAECANCELLED */ 
   "Invalid procedure table from service provider",	/* 10104 WSAEINVALIDPROCTABLE */ 
   "Invalid service provider version number",   	/* 10105 WSAEINVALIDPROVIDER */ 
   "Unable to initialize a service provider",		/* 10106 WSASYSCALLFAILURE */ 
   "System call failure",				/* 10107 WSASYSCALLFAILURE */ 
   "WSASERVICE_NOT_FOUND",				/* 10108 WSASERVICE_NOT_FOUND */ 
   "WSATYPE_NOT_FOUND",					/* 10109 WSATYPE_NOT_FOUND */ 
   "WSA_E_NO_MORE",					/* 10110 WSA_E_NO_MORE */ 
   "WSA_E_CANCELLED",					/* 10111 WSA_E_CANCELLED */ 
   "WSAEREFUSED",					/* 10112 WSAEREFUSED */ 
};

char *geterr(void);
int ws_perror (char *s);
char *ws_strerr (int err_no);

#endif	/* WIN32 */
#endif	/* WS_ERRMSG_H */



