/*
 * Copyright (C) 1990-1993 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tsttmsexit.c	1.4 02/19/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/* 	tsttmsexit - test TMS exits and TMS daemon */
/*
 *	options on the command line
 *
 *	-D	device name
 *	-g	device group name
 *	-l	label option
 *	-r	ring option
 *	-v	volume serial number
*/
#include <stdio.h>
#include <sys/types.h>
#if cray
#include <sys/jtab.h>
#endif
#include <time.h>
#include TAPEINC
#include "tms.h"
extern char *optarg;
#if cray
char msgfn[MAXPATH]="";
#else
char repbuf[PRTBUFSZ];
#endif
main(argc, argv)
int argc;
char **argv;
{
	int c;
	static char dvn[9] = "";
#if cray
	struct jtab jtab;
#else
	char *getacct();
#endif
	char *getenv();
	char *p, *qptr;
	static char reqname[4][8] = {"VERIFY","LOCK","MOUNTED","UNLOCK"};
	int type;
	struct vsn_req vsn_req;

	if (argc == 1) {
		usage (argv[0]);
		exit (38);
	}
	memset ((char *)&vsn_req, 0, sizeof(struct vsn_req));
	while ((c = getopt (argc, argv, "D:g:l:r:v:")) != EOF) {
		switch (c) {
			case 'D':
				strcpy (dvn, optarg);
				break;
			case 'g':
				strcpy (vsn_req.dgn, optarg);
				break;
			case 'l':
				strcpy (vsn_req.lbl, optarg);
				break;
			case 'r':
				if (strcmp (optarg, "in") == 0)
					vsn_req.mode = VSN_WRITE;
				else
					vsn_req.mode = VSN_READ;
				break;
			case 'v':
				strcpy (vsn_req.vid[0], optarg);
				strcpy (vsn_req.vsn[0], optarg);
				vsn_req.num = 1;
				break;
			default:
				usage (argv[0]);
				exit (38);
		}
	}
	vsn_req.uid = getuid();
	vsn_req.gid = getgid();
#if cray
	vsn_req.acctid = acctid (0, -1);
	vsn_req.jid = getjtab(&jtab);
#else
	p = getacct();
	strcpy (vsn_req.acctname, p);
	vsn_req.jid = findpgrp();
#endif
	if ((qptr = getenv("QSUB_REQID")) != NULL) {	/* NQS batch job id */
		strcpy(vsn_req.nqsid, qptr);
	} else {
		vsn_req.nqsid[0] = '\0';
	}
	vsn_req.dvn[0] = '\0';
	vsn_req.nounload = 0;
	vsn_req.path[0] = '\0';
	if (vsn_req.dgn[0] == '\0') strcpy (vsn_req.dgn, "CART");
	if (vsn_req.lbl[0] == '\0') strcpy (vsn_req.lbl, "sl");
	if (vsn_req.mode == 0) vsn_req.mode = VSN_READ;
	for (type = 0; type < 3; type++) {
		if (type == TMLOCK) {
			strcpy (vsn_req.dvn, dvn);
#if cray
			strcpy (msgfn, "tape.msg");
#endif
		}
		c = tmsexit (&vsn_req, type);
#ifndef cray
		if (repbuf[0]) fprintf (stderr, "%s\n", repbuf);
#endif
		fprintf (stderr, "tmsexit(%s), rc = %d\n", reqname[type], c);
		if (c != 0) break;
	}
	if (type == TMVERIFY && c == ETPRM)
		fprintf (stderr, "tmsexit(CANCEL), rc = %d\n",
			tmsexit (&vsn_req, TMUNLOCKV));
	fprintf (stderr, "tmsexit(CANCEL), rc = %d\n", tmsexit (&vsn_req, TMUNLOCKA));
	if (c != 0) exit (1);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "[-g device-group-name] [-l label-type] [-r ring-option]\n");
	fprintf (stderr, "-v volume-serial-number(s)\n");
}

#if cray
#include <fcntl.h>
errmsg(func, ec, msg, p1, p2, p3, p4, p5)
char *func;
int ec;
char *msg;
{
	char prtbuf[TMPRTBUFSZ];
	struct tm *tm;
	time_t current_time;
	int fd_log;

	if (msgfn[0] != '\0') {
		time (&current_time);		/* Get current time */
		tm = localtime (&current_time);
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d ", tm->tm_mon+1,
			tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec);
		sprintf (prtbuf+strlen(prtbuf), msg, p1, p2, p3, p4, p5);
		strcat (prtbuf, "\n");
		fd_log = open (msgfn, O_WRONLY | O_CREAT | O_APPEND, 0664);
		write (fd_log, prtbuf, strlen(prtbuf));
		close (fd_log);
	} else {
		fprintf (stderr, msg, p1, p2, p3, p4, p5);
		fprintf (stderr, "\n");
	}
}

usrmsg(func, msg, p1, p2, p3, p4, p5)
char *func;
char *msg;
{
	extern char msgfn[];
	char prtbuf[TMPRTBUFSZ];
	struct tm *tm;
	time_t current_time;
	int fd_log;

	if (msgfn[0] != '\0') {
		time (&current_time);		/* Get current time */
		tm = localtime (&current_time);
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d ", tm->tm_mon+1,
			tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec);
		sprintf (prtbuf+strlen(prtbuf), msg, p1, p2, p3, p4, p5);
		strcat (prtbuf, "\n");
		fd_log = open (msgfn, O_WRONLY | O_CREAT | O_APPEND, 0664);
		write (fd_log, prtbuf, strlen(prtbuf));
		close (fd_log);
	}
}
#endif
