/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tmsexit.c	1.11 12/09/98 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tmsexit - tapedaemon user exit interfacing to tmsdaemon */
/*
 *	rc = 0		everything ok
 *	rc = EACCES	access denied
 *	rc = ETPRM	parameter inconsistency
 *	rc = ETVBSY	volume busy
 *	rc = ETMSS	tmsdaemon system error
*/
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <pwd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include TAPEINC
#if cray
#define DEFDGN "CART"
#endif
#include <varargs.h>
#include "tms.h"

tmsexit(rqp, type)
struct vsn_req *rqp;
int type;
{
	char func[16];
	struct tmsreq req;
	int repsize;
	struct stat st;
	char tmrepbuf[TMREPBUFSZ];
	struct passwd *pwd;
	struct tmsmreq *tmrp;
#if cray
	char *acid2nam();
#endif
	time_t time();
	char *p, *q;
	int c, i, n;

	if (stat (NOTMSD, &st) == 0) return (0);	/* does not want to call TMS */
	strcpy (func, "tmsexit");
	memset ((char *)&req, 0, sizeof(struct tmsreq));
	req.rh.size = sizeof(struct tmrqhdr) + sizeof(struct tmsmreq);
	req.rh.code = TMSMOUNT;
	tmrp = (struct tmsmreq *) req.data;
	tmrp->jid = rqp->jid;
	tmrp->mode = rqp->mode == VSN_WRITE ? 'W':'R';
	tmrp->type = type;
#if cray
	if (rqp->uid >= 100)
		p = acid2nam (rqp->acctid);
	else
		p = "xmp$cy";
#else
	p = rqp->acctname;
#endif
	strncpy (tmrp->userid, p, 3);
	strncpy (tmrp->account, p+4, 2);
	if (rqp->nqsid[0] != '\0') {
		q = tmrp->uniqueid;
		*q = 'B';
		for (p = rqp->nqsid; *p != '.'; p++)
			*++q = *p;
	} else
		sprintf (tmrp->uniqueid, "I%d", rqp->jid);
	pwd = getpwuid (rqp->uid);
	strcpy (tmrp->logonid, pwd->pw_name);
	strcpy (tmrp->unit, rqp->dvn);
	if (type == TMVERIFY)
		strcpy (tmrp->system, "VERIFY");
	tmrp->nounload = rqp->nounload == 1 ? '+':' ';
	strcpy (tmrp->path, rqp->path);

	for (i = 0; i < rqp->num; i++) {
		strcpy (tmrp->vid, rqp->vid[i]);
		tmrp->req_time = time(0);
		n = 0;
		while (1) {
			c = send2tmsd (&req, tmrepbuf, &repsize);
			switch (c) {
			case 0: /* volume available */
				if (type == TMVERIFY && repsize != 0) {
					c = chkparvalid (rqp, i, tmrepbuf);
					if (c != 0) return (c);
				}
				break;
			case EACCDEN:	/* access denied or volume inactive */
				umsg (func, TMS02, tmrepbuf);
				return (EACCES);
			case EVOLBSY:	/* volume in use */
				umsg (func, TMS02, tmrepbuf);
				return (ETVBSY);
			case ETMNRSP:	/* no answer from SYSREQ/TMS */
				if (c != n) umsg (func, TMS03);
				n = c;
				sleep (TMSVNRSRI);
				continue;
			case EVOLUNK:	/* volume unknown */
				umsg (func, TMS02, tmrepbuf);
				if (rqp->uid == 0)
					c = 0;
				else
					return (EACCES);
				break;
			case ETMNACT:	/* TMS not working for a long period of time */
				/* allow read operations only */
				if (tmrp->mode != 'R' &&
				   (type == TMVERIFY || type == TMLOCK)) {
					if (c != n) umsg (func, TMS16);
					n = c;
					sleep (TMSNWRKRI);
					continue;
				} else c = 0;
				break;
			default:	/* error */
				sleep (TMSVNRSRI);
				continue;
			}
			break;
		}
	}
	return (0);
}

chkparvalid (rqp, vsn_index, trepp)
struct vsn_req *rqp;
int vsn_index;
char *trepp;
{
	char func[16];
	int errflag;
	int i;
	char dgn[16];
	static char tmsvsn[7] = "      ";
	static char tmsdgn[7] = "      ";
	static char tmslbl[3] = "  ";

	/* check vsn, label type and device group name against TMS information */
	strcpy (func, "chkparvalid");
	errflag = 0;
	strncpy (tmsvsn, trepp, 6);
	for  (i = 0; tmsvsn[i]; i++)
		if (tmsvsn[i] == ' ') break;
	tmsvsn[i] = '\0';
	if (strcmp (rqp->vsn[vsn_index], tmsvsn) != 0) {
		umsg (func, TMS04, rqp->vsn[vsn_index], tmsvsn);
		errflag++;
	}
	if (strcmp (rqp->lbl, "blp") != 0) {
		tmslbl[0] = *(trepp+32) - 'A' + 'a';
		tmslbl[1] = *(trepp+33) - 'A' + 'a';
		if (strcmp (rqp->lbl, tmslbl) != 0) {
			umsg (func, TMS04, rqp->lbl, tmslbl);
			errflag++;
		}
	}
	if (rqp->dgn[0] == '\0')
		strcpy (dgn, DEFDGN);
	else
		strcpy (dgn, rqp->dgn);
	strncpy (tmsdgn, trepp+25, 6);
	for  (i = 0; tmsdgn[i]; i++)
		if (tmsdgn[i] == ' ') break;
	tmsdgn[i] = '\0';
	if (strcmp (tmsdgn, "CT1") == 0) strcpy (tmsdgn, "CART");
	if (strcmp (dgn, tmsdgn) != 0) {
	    if (strcmp (tmsdgn, "CART") || strcmp (dgn, "CT2") || rqp->mode == VSN_WRITE) {
		umsg (func, TMS04, rqp->dgn, tmsdgn);
		errflag++;
	    }
	}
	return (errflag == 0 ? 0 : ETPRM);
}

#if cray
umsg(func, msg, p1, p2, p3, p4, p5)
char *func;
char *msg;
{
/*      send user messages to stderr if called from a command module (tpmnt, rls
)
        or to tape.msg if called from a tpdaemon overlay.
*/
        extern char msgfn[];
        if (msgfn[0] == '\0')
                errmsg (func, 0, msg, p1, p2, p3, p4, p5);
        else
                usrmsg (func, msg, p1, p2, p3, p4, p5);
}
#else
umsg(va_alist) va_dcl
{
	va_list args;
	char *func;
	char *msg;
	extern char repbuf[];

	va_start (args);
	func = va_arg (args, char *);
	msg = va_arg (args, char *);
	vsprintf (repbuf, msg, args);
	va_end (args);
}
#endif
