/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

/*
 * @(#)tms.h	1.10 06/26/97 CERN CN-SW/CU   Jean-Philippe Baud
 */

			/* TMS constants and macros */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  64
#endif
#ifdef MAXPATH
#undef MAXPATH
#endif
#define MAXPATH  80		/* maximum path length */
#define TMPRTBUFSZ 2064		/* must be >= (max(TMREPBUFSZ, TMREQBUFSZ) + 16) */
#define TMREPBUFSZ 2048		/* reply buffer size */
#define TMREQBUFSZ 168		/* must be >= (max(sizeof(tmsmreq), sizeof(tmsqreq)) */
#define TMCLNREQI  180		/* retry interval to check for jobs that have died */
#define TMGETREPI  1		/* retry interval to get reply */
#define TMGETREQI  1		/* retry interval to look for a new request */
#define TMMAXRETRY 2		/* max nb retries if SYSREQ/TMS servers busy or not resp. */
#define TMSNWRKRI  600		/* retry interval if TMS not working */
#define TMTIMEOUT  300		/* timeout if no answer from tmsdaemon */
#define TMSVBSYRI  5		/* retry interval if SYSREQ/TMS servers busy */
#define TMSVNRSRI  60		/* retry interval if SYSREQ/TMS servers not responding */

#ifdef ultrix
#define READ(x,y,z) recv(x,y,z,0)
#define WRITE(x,y,z) send(x,y,z,0)
#else
#define READ(x,y,z) read(x,y,z)
#define WRITE(x,y,z) write(x,y,z)
#endif

			/* TMS commands */

#define TMSMOUNT   0
#define TMSQVOL    1
			/* TMS MOUNT request types */
#define TMVERIFY   0
#define TMLOCK     1
#define TMMOUNTED  2
#define TMUNLOCKV  3
#define TMUNLOCKD  4
#define TMUNLOCKP  5
#define TMUNLOCKA  6
#define TMLOCKED   7
#define TMUNLOCKB  8

			/* TMS daemon return codes */

#define EACCDEN    81
#define EVOLBSY    82
#define ETMNRSP    83
#define EVOLUNK    84
#define ETMNACT    85
#define ETMSS      99

			/* TMS daemon messages */

#define TMS00	"TMS00 - TMS daemon not available"
#define TMS01	"TMS01 - no response from TMS daemon"
#define TMS02	"TMS02 - %s"
#define TMS03	"TMS03 - SYSREQ/TMS not responding"
#define TMS04	"TMS04 - parameter inconsistency: %s<->%s"
#define TMS05	"TMS05 - Fatal sysreq error %d"
#define TMS06	"TMS06 - Illegal function %d"
#define TMS07	"TMS07 - Error reading request header, read = %d"
#define TMS08	"TMS08 - tabinfo error: %d"
#define TMS09	"TMS09 - cannot get memory"
#define TMS10	"TMS10 - tabread error: %d"
#define TMS11   "TMS11 - %s"
#define TMS12	"TMS12 - sysreq rc = %d"
#define TMS13	"TMS13 - TMS service unavailable"
#define TMS14	"TMS14 - SYSREQ daemon not active"
#define TMS15	"TMS15 - ops replied: %s"
#define TMS16	"TMS16 - TMS not available, only read operations are allowed"
#define TMS17	"TMS17 - notms"
#define TMS18	"TMS18 - tmsactive"
#define TMS19	"TMS19 - %s : %s error : %d"
#define	TMS20	"TMS20 - SYSREQ/TMS communication error"
#define	TMS21	"TMS21 - you are not registered in account file\n"
#define	TMS22	"TMS22 - tmsdaemon not responding\n"

		/* TMS daemon request structures */

struct tmrqhdr {	/* tms request header */
	int size;
	int code;
	char rpn[MAXPATH];
};
struct tmsmreq {	/* tms mount request */
	time_t	req_time;
	int	jid;
	char	mode;
	char	type;
	char	vid[8];
	char	userid[4];
	char	uniqueid[9];
	char	logonid[9];
	char	account[3];
	char	unit[9];
	char	system[8];
	char	nounload;
	char	path[MAXPATH];
	char	library[9];
	char	rackslot[9];
};
struct tmsqreq {	/* tms qvol request */
	char	logonid[9];
	char	acctname[7];
	char	buf[128];
};
struct tmsreq {		/* tms request */
	struct tmrqhdr rh;
	char data[TMREQBUFSZ];
};

		/* TMS daemon reply structures */

struct tmrphdr {	/* tms reply header */
	int size;
	int rc;
};
struct tmsrep {		/* tms reply */
	struct tmrphdr rh;
	char data[TMREPBUFSZ];
};
