/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpstat.c	1.9 05/13/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tpstat - tape status display */
#include <stdio.h>
#include <pwd.h>
#include <sys/param.h>
#include <time.h>
#include "tape.h"
int jid;
struct tpst req;
struct tpstr rep[MAXUNIT];
char *strchr();

main(argc, argv)
int	argc;
char	**argv;
{
	int c, i, n;
	struct passwd *pwd;
	struct tpstr *tstp;
	char fullunitname[18];
	char hostname[MAXHOSTNAMELEN];
	char label;
	char mounted;
	char name[15];
	char jobid[7];
	char *p;
	char ring;
	char status[5];
	struct tm *tm;
	static char labeldef[5] = {' ', 'a', 'n', 's', 'b'};
	char timestamp[9];

	if (argc != 1) {
		usage (argv[0]);
		exit (ETPRM);
	}
	jid = findpgrp();
	req.rh.size = sizeof(struct tpst);
	req.rh.code = TPSTAT;
	req.uid = getuid();
	c = send2tpd (&req, rep, &n);
	if (c == 0 && n > 0) {
		gethostname (hostname, MAXHOSTNAMELEN);
		if (p = strchr (hostname, '.')) *p = '\0';
		printf ("userid     jid  dgn        stat dvn                 rl  vsn    vid\n");
		n = n / sizeof(struct tpstr);
		tstp = rep;
		for (i = 0; i < n; i++) {
			if (tstp->asn == 0) {
				if (tstp->status == 0)
					strcpy (status, "down");
				else
					strcpy (status, "idle");
				name[0] = '\0';
				jobid[0] = '\0';
				ring = ' ';
				label = ' ';
				mounted = ' ';
				timestamp[0] = '\0';
			} else {
				if (tstp->status == 0)
					strcpy (status, "wdwn");
				else
					strcpy (status, "assn");
				pwd = getpwuid (tstp->uid);
				strcpy (name, pwd->pw_name);
				sprintf (jobid, "%d", tstp->jid);
				if (tstp->ring == OUT)
					ring = 'o';
				else
					ring = 'i';
				label = labeldef[tstp->lbl];
				if (tstp->tobemounted)
					mounted = '*';
				else
					mounted = ' ';
				tm = localtime (&tstp->asn_time);
				sprintf (timestamp,"%02d:%02d:%02d",
					tm->tm_hour, tm->tm_min, tm->tm_sec);
			}
			sprintf (fullunitname, "%s@%-8s", tstp->unm, hostname);
			printf ("%-8s %-6s %-8s   %-4s %-17s   %c%c%c%-6s %-6s %s\n",
				name, jobid, tstp->dgn, status, fullunitname,
				ring, label, mounted, tstp->vsn, tstp->vid,
				timestamp);
			tstp++;
		}
	}
	switch (c) {
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s\n", cmd);
}

