.\" @(#)tpmnt.man	1.27	09/08/97 CERN CN-SW/CU Jean-Philippe Baud
.\" Copyright (C) 1990-1997 by CERN/CN/SW/CU
.\" All rights reserved
.\"
.TH TPMNT l "09/08/97"
.SH NAME
tpmnt \- ask operator to mount a tape and position the tape
.SH SYNOPSIS
.B tpmnt
[
.BI -a
] [
.BI -b " max_block_size"
] [
.BI -D " device_name"
] [
.BI -d " density"
] [
.B -E ignoreeoi
] [
.BI -F " record_format"
] [
.BI -f " file_id"
] [
.BI -g " device_group_name"
] [
.BI -L " record_length"
] [
.BI -l " label_type"
] [
.BI -N
] [
.BI -n
] [
.BI -o
] [
.BI -q " file_sequence_number"
] [
.BI -r " ring_option"
] [
.BI -T
] [
.BI -t " retention_period_in_days"
]
.BI -P " path_name"
.BI -v " volume_serial_number[=visual_identifier]"
.SH DESCRIPTION
.B tpmnt
checks with TMS if the tape is available, asks the operator
to mount it on a unit selected by the tape daemon, checks the vsn
in VOL1 if the tape is labelled, positions to the file requested,
checks the labels HDR1 and HDR2.

.B tpmnt
stores the label information in the file
.B .tplabel
in the current directory. This filename can be changed by setting
the environment variable TAPENV.

The file contains one line feed terminated record per
.B tpmnt
command in the following format:
.RS
.TP
.RB "* the pathname as specified in " tpmnt " (80 characters)"
.TP
* the tape label type (2 characters: al, nl or sl)
.TP
.RB "* the Tflag value ('T' if -T option was present in " tpmnt ", blank otherwise)"
.TP
* the file sequence number (4 characters)
.TP
* VOL1 label (80 characters)
.TP
* HDR1 label (80 characters)
.TP
* HDR2 label (80 characters)
.RE

A new
.B tpmnt
for the same path will overwrite the corresponding record.
Three routines are provided to write the labels:
.B wrthdrlbl
to write the header labels,
.B wrttrllbl
to write the trailer labels,
.B asc2ebc
is internally called
to do character conversion between ASCII and EBCDIC for SL tapes.
.SH OPTIONS
.TP
.BI \-a
Positions the tape at the end of an existing file to append new data.
This is incompatible with -n and -o options.
.TP
.BI \-b " blksize"
Specifies the maximum block size. The value is only used to build HDR2.
The default value is taken from the existing tape label if -a or -o is
also specified.
If the option -n is set, for all drive types except Redwoods the default is
32760 if
.I lrecl
is not specified,
.I lrecl
otherwise. On Redwoods, the default is 262144 if
.I lrecl
is not specified or the largest multiple of
.I lrecl
below 262144.
.TP
.BI \-D " devname"
Explicit device name.
.TP
.BI \-d " density"
.B 1600
or
.B 6250
for round (IBM 3420) tapes,
.B 38000
for standard IBM 3480 cartridges,
.B 38KC
for 3480 cartridges with compaction (IDRC),
.B 38KD
for double density IBM 3490 cartridges,
.B 38KDC
for 3490 cartridges with compaction (IDRC),
.BR 8200 ,
.B 8500
or
.B 8500C
for Exabytes,
.B DDS
or
.B DDSC
for DAT cartridges,
.BR 2G ,
.BR 6G ,
.BR 10G ,
.BR 10GC ,
.BR 20G ,
.BR 20GC ,
.B 35G
or
.B 35GC
for DLT cartridges,
.B 10G
or
.B 10GC
for IBM 3590 cartridges,
.BR 10G ,
.BR 10GC ,
.BR 25G ,
.BR 25GC ,
.B 50G
or
.B 50GC
for Redwood cartridges.
.TP
.B \-E ignoreeoi
Do not take two consecutive tapemarks as End Of Information.
This option is only valid for label type
.B nl
or
.B blp
and should be avoided on IBM 3420 drives (the reel could wind off).
.TP
.BI \-F " recfm"
.BR F ,
.BR FB ,
.BR FBS ,
.B FS
or
.BR U .
The value is only used to build HDR2.
The default value is taken from the existing tape label if -a or -o is
also specified or is set to U if the option -n is set.
.TP
.BI \-f " fid"
Specifies the fileid in HDR1. If more than 17 characters long,
only the last 17 are taken. It is then converted to upper case.
If -n is not specified the fileid parameter is checked against the fid in HDR1.
If -n is specified, but the -f parameter is absent,
the pathname (-P) is used instead.
.TP
.BI \-g " dgn"
Requests a device from an installation defined set of "device groups".
It must match the device group specified in TMS (if installed).
Default is CART.
.TP
.BI \-L " lrecl"
Specifies the logical record length. The value is only used to build HDR2.
The default value is taken from the existing tape label if -a or -o is
also specified or from the blocksize if the option -n is set.
.TP
.BI \-l " lab_type"
Label type:
.BR al ,
.BR nl ,
.B sl
or
.BR blp .
It must match the label type specified in TMS.  blp is allowed only for read.
Default is sl.
.TP
.BI \-N
Does not reposition tapes when accessing two consecutive files.
This flag should only be set when the requestor knows that the tape is already
positionned correctly.
.TP
.BI \-n
Positions the tape at the specified file. It does not check the fileid
but if the new file would overwrite an existing one,
it checks the old file expiry date.
.TP
.BI \-o
Positions the tape at the specified file. It checks the fileid if specified.
If ring in is also specified, and the new file would overwrite an existing one,
it checks the old file expiry date.
.TP
.BI \-P " pathname"
Specifies the pathname relative to the current directory or the full pathname
which be used by the application program in the OPEN statement.
This path should not exist yet.
.TP
.BI \-q " fseq"
File sequence number. It can be a positive integer number to give
an explicit position,
.B n
to specify a new file after the last file on tape or
.B u
to position the tape by fid.
Default is 1.
.TP
.BI \-r " ring"
Ring option: either
.B in
(write enable) or
.B out
(write disable). Default is ring out.
.TP
.BI \-T
Does not check trailer labels.
.TP
.BI \-t " days"
Retention period in days. A file may be overwritten only if it is expired.
Default is 0, which means that the file may be overwritten immediately.
.TP
.BI \-v " vsn[=vid]"
Specifies the volume serial number of the tape and optionally the visual
identifier. They must be six characters long (maximum) and are converted
to upper case. The vsn must match the one specified in TMS.
.SH RETURN CODES
\ 
.br
0	Ok.
.br
2	File not found.
.br
5	I/O error.
.br
6	Unit not operational.
.br
13	Operator cancel, access denied by TMS, wrong label type or file not expired.
.br
200	Tape daemon is not running.
.br
201	System or communication error.
.br
203	Bad parameter.
.br
206	Too many units requested.
.br
207	Invalid device group name.
.br
208	Reserv not done.
.br
209	No unit with requested characteristics.
.br
210	Bad label structure.
.br
211	Bad file sequence number.
.br
212	Interrupted by user.
.br
216	Blank tape.
.br
217	Drive/cartridge compatibility problem.
.br
218	Device malfunction.
.br
219	Parity error.
.br
220	Unrecoverable media error.
.br
221	No sense data available.
.br
222	Reselect server requested by operator.
.SH SEE ALSO
.BR wrthdrlbl,
.BR wrttrllbl,
.BR deltpfil
