/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpmnt.c	1.33 05/30/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tpmnt - ask operator to mount tape and verify VOL1 label */
#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
int jid;
char repbuf[MAXPATH+246];
struct	tpmount	req;
char *strchr();
#ifdef TMS
struct	vsn_req	vrqp;
#endif

main(argc, argv)
int	argc;
char	**argv;
{
	int c, i, n;
	void cleanup();
	char *dp;
	int errflg = 0;
	char *getacct();
	char *getcwd();
	char *getenv();
	static char labels[5][4] = {"", "al", "nl", "sl", "blp"};
	int numvid = 0;
	char *p, *q;
	int rflg = 0;
	char savepath[MAXPATH];
	char *strtok();
	char tplblfn[MAXPATH];

	jid = findpgrp();
	req.rh.size = sizeof(struct tpmount);
	req.rh.code = TPMOUNT;
	req.uid = getuid();
	req.gid = getgid();
	req.jid = jid;
#ifdef TMS
	p = getacct();
	if (p == NULL) {
		fprintf (stderr, TP027);
		exit (1);
	}
	strcpy (req.acctname, p);
#else
	strcpy (req.acctname, "NOACCT");
#endif
	if ((p = getenv("QSUB_REQID")) != NULL)
		strcpy (req.nqsid, p);
	req.ignoreeoi = ' ';
	req.Nflag = ' ';
	req.Tflag = ' ';
	while ((c = getopt (argc, argv, "ab:D:d:E:F:f:g:L:l:NnoP:Q:q:r:Tt:v:")) != EOF) {
		switch (c) {
		case 'a':
			if (req.filstat == '\0') {
				req.filstat = 'a';
			} else {
				if (req.filstat == 'a')
					fprintf (stderr, TP007, argv[optind-1]);
				else
					fprintf (stderr, TP016, req.filstat, 'a');
				errflg++;
			}
			break;
		case 'b':
			if (req.blksize == 0) {
				req.blksize = strtol (optarg, &dp, 10);
				if (*dp != '\0') {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'D':
			if (req.dvn[0] == '\0') {
				if (strlen(optarg) < sizeof(req.dvn))
					strcpy (req.dvn, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'd':
			if (req.den == 0) {
				if ((req.den = cvtden (optarg)) <= 0) {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'E':
			if (strcmp (optarg, "ignoreeoi") == 0)
				req.ignoreeoi = 'i';
			else {
				fprintf (stderr, TP006, argv[optind-2]);
				errflg++;
			}
			break;
		case 'F':
			if (req.recfm[0] == '\0') {
				if (strcmp (optarg, "F") == 0 ||
				    strcmp (optarg, "FB") == 0 ||
				    strcmp (optarg, "FBS") == 0 ||
				    strcmp (optarg, "FS") == 0 ||
				    strcmp (optarg, "U") == 0)
					strcpy (req.recfm, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'f':
			if (req.fid[0] == '\0') {
				p = optarg;
				if ((i = strlen (p) - 17) > 0) p += i;
				strcpy (req.fid, p);
				UPPER (req.fid);
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'g':
			if (req.dgn[0] == '\0') {
				if (strlen(optarg) < sizeof(req.dgn))
					strcpy (req.dgn, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'L':
			if (req.lrecl == 0) {
				req.lrecl = strtol (optarg, &dp, 10);
				if (*dp != '\0') {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'l':
			if (req.lbl == 0) {
				if (!strcmp (optarg, "al")) req.lbl = AL;
				else if (!strcmp (optarg, "nl")) req.lbl = NL;
				else if (!strcmp (optarg, "sl")) req.lbl = SL;
				else if (!strcmp (optarg, "blp")) req.lbl = BLP;
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'N':
			req.Nflag = 'N';
			break;
		case 'n':
			if (req.filstat == '\0') {
				req.filstat = 'n';
			} else {
				if (req.filstat == 'n')
					fprintf (stderr, TP007, argv[optind-1]);
				else
					fprintf (stderr, TP016, req.filstat, 'n');
				errflg++;
			}
			break;
		case 'o':
			if (req.filstat == '\0') {
				req.filstat = 'o';
			} else {
				if (req.filstat == 'o')
					fprintf (stderr, TP007, argv[optind-1]);
				else
					fprintf (stderr, TP016, req.filstat, 'o');
				errflg++;
			}
			break;
		case 'P':
			if (req.path[0] == '\0') {
				if (*optarg != '/') {
					if (getcwd (req.path, sizeof(req.path) - 3) == NULL) {
						fprintf (stderr,
						    "TP002 -  : getcwd error : %d\n", errno);
						errflg++;
					}
					strcat (req.path, "/");
				}
				if (strlen(req.path) + strlen(optarg) < sizeof(req.path)) {
					strcat (req.path, optarg);
					strcpy (savepath, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'Q':
			if (req.Qfirst == 0) {
				p = strtok (optarg, "-");
				req.Qfirst = strtol (p, &dp, 10);
				if (*dp != '\0' || req.Qfirst == 0) {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
				if (p = strtok (NULL, "-")) {
					req.Qlast = strtol (p, &dp, 10);
					if (*dp != '\0' || req.Qlast < req.Qfirst) {
						fprintf (stderr, TP006, argv[optind-2]);
						errflg++;
					}
				} else
					req.Qlast = req.Qfirst;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'q':
			if (req.fseq == 0) {
				if (optarg[0] == 'n')
					req.fseq = -1;
				else if (optarg[0] == 'u')
					req.fseq = -2;
				else {
					req.fseq = strtol (optarg, &dp, 10);
					if (*dp != '\0') {
						fprintf (stderr, TP006, argv[optind-2]);
						errflg++;
					}
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'r':
			if (rflg == 0) {
				if (!strcmp (optarg, "in")) req.ring = IN;
				else if (!strcmp (optarg, "out")) req.ring = OUT;
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			rflg = 1;
			break;
		case 'T':
			req.Tflag = 'T';
			break;
		case 't':
			if (req.retentd == 0) {
				req.retentd = strtol (optarg, &dp, 10);
				if (*dp != '\0') {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'v':
			if (numvid == 0) {
				p = strtok (optarg, ":");
				while (p) {
					if (numvid >= MAXVSN) {
						fprintf (stderr, TP019);
						errflg++;
						break;
					}
					if (q = strchr (p, '=')) {
						*q++ = '\0';
						if (strlen (q) > 0 && strlen (q) < 7) {
							strcpy (req.vid[numvid], q);
							UPPER (req.vid[numvid]);
						} else {
							fprintf (stderr, TP006, argv[optind-2]);
							errflg++;
						}
					}
					if (strlen (p) > 0 && strlen (p) < 7) {
						strcpy (req.vsn[numvid], p);
						UPPER (req.vsn[numvid]);
					} else {
						fprintf (stderr, TP006, argv[optind-2]);
						errflg++;
					}
					if (req.vid[numvid][0] == '\0')
						strcpy (req.vid[numvid], req.vsn[numvid]);
					numvid++;
					p = strtok (NULL, ":");
				}
				req.numvid = numvid;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (req.numvid == 0) {
		fprintf (stderr, TP031);
		errflg++;
	}
	if (req.path[0] == '\0') {
		fprintf (stderr, TP029);
		errflg++;
	} else {
		if (chkdirw (req.path)) {
			fprintf (stderr, "TP002 - %s : access error : %d\n",
				req.path, errno);
			errflg++;
		}
	}
	if (req.lbl == BLP && req.ring == IN) {
		fprintf (stderr, TP017);
		errflg++;
	}
	if (req.ignoreeoi == 'i' &&
	    (req.lbl == 0 || req.lbl == AL || req.lbl == SL)) {
		fprintf (stderr, TP049);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}
	if (req.Qfirst && req.fseq > (req.Qlast - req.Qfirst + 1)) {
		fprintf (stderr, "TP024 - file %d does not exist\n", req.fseq);
		if (req.fseq == (req.Qlast - req.Qfirst + 2))
			exit (ETFSQ);
		else
			exit (ENOENT);
	}

	/* Set default values */

	if (req.dgn[0] == '\0') strcpy (req.dgn, DEFDGN);
	if (req.filstat == '\0') req.filstat = 'o';
	if (req.fseq == 0) req.fseq = 1;
	if (req.lbl == 0) req.lbl = SL;
	if (rflg == 0 && req.filstat != 'o') req.ring = IN;

	/* check if allowed to save tape label info */

	if ((p = getenv ("TAPENV")) == NULL)
		p = ".tplabel";
	if (*p == '/') {
		tplblfn[0] = '\0';
	} else {
		if (getcwd (tplblfn, sizeof(tplblfn) - 3) == NULL) {
			fprintf (stderr, "TP002 -  : getcwd error : %d\n", errno);
			exit (ETPRM);
		}
		strcat (tplblfn, "/");
	}
	if (strlen(tplblfn) + strlen(p) < sizeof(tplblfn)) {
		strcat (tplblfn, p);
	} else {
		fprintf (stderr, TP038, p);
		exit (ETPRM);
	}
	if (access (tplblfn, W_OK)) {
		if (errno != ENOENT || chkdirw (tplblfn)) {
			fprintf (stderr, "TP002 - %s : access error : %d\n",
				tplblfn, errno);
			exit (errno);
		}
	}

#ifdef TMS
	vrqp.num = req.numvid;
	vrqp.uid = req.uid;
	vrqp.gid = req.gid;
	vrqp.mode = req.ring == IN ? VSN_WRITE : VSN_READ;
	for (i = 0; i < req.numvid; i++) {
		strcpy (vrqp.vsn[i], req.vsn[i]);
		strcpy (vrqp.vid[i], req.vid[i]);
	}
	strcpy (vrqp.acctname, req.acctname);
	vrqp.jid = req.jid;
	strcpy (vrqp.nqsid, req.nqsid);
	vrqp.dvn[0] = '\0';
	strcpy (vrqp.path, req.path);
	strcpy (vrqp.dgn, req.dgn);
	strcpy (vrqp.lbl, labels[req.lbl]);
	c = tmsexit (&vrqp, 0);
	if (c != 0) {
		fprintf (stderr, "%s\n", repbuf);
		tmsexit (&vrqp, 5);
		exit (c);
	}
#endif
	signal (SIGHUP, cleanup);
	signal (SIGINT, cleanup);
	signal (SIGQUIT, cleanup);
	signal (SIGTERM, cleanup);

	while ((c = send2tpd (&req, repbuf, &n)) == ETVBSY) {
                req.nretry++;
		sleep (VOLBSYRI);
	}
	switch (c) {
	case 0:
		savelabel (tplblfn, req.uid, req.gid, savepath, repbuf);
		break;
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	case ETNDV:
		fprintf (stderr, TP012);
		break;
	case ETIDG:
		fprintf (stderr, TP013);
		break;
	case ETNRS:
		fprintf (stderr, TP014);
		break;
	case ETIDN:
		fprintf (stderr, TP015);
		break;
	default:
		if (n) fprintf (stderr, "%s\n", repbuf);
		break;
	}
	exit (c);
}

void cleanup(sig)
int sig;
{
	int c;
	struct killmnt klmreq;

	signal (sig, SIG_IGN);

	klmreq.rh.size = sizeof(struct killmnt);
	klmreq.rh.code = KILLMNT;
	klmreq.jid = req.jid;
	strcpy (klmreq.path, req.path);
	c = send2tpd (&klmreq, NULL, (int *)0);
	exit (ETINTR);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s%s%s%s%s",
		"[-a] [-b max_block_size] [-D device_name] [-d density]\n",
		"[-E ignoreeoi] [-F record_format] [-f file_id] [-g device_group_name]\n",
		"[-L record_length] [-l label_type] [-N] [-n] [-o] -P path_name\n",
		"[-Q first_mapped_file-last_mapped_file] [-q file_sequence_number]\n",
		"[-r ring_option] [-T] [-t retention_period] -v volume_serial_number(s)\n");
}
