.\" @(#)tplblinfo.man	1.2 06/29/94 CERN CN-PDP/DH Jean-Philippe Baud
.\" Copyright (C) 1994 by CERN/CN/PDP/DH
.\" All rights reserved
.\"
.TH TPLBLINFO l "06/29/94"
.SH NAME
tplblinfo \- get information from header labels
.SH SYNOPSIS
.B tplblinfo
[
.B -b
] [
.B -F
] [
.B -f
] [
.B -L
] [
.B -q
]
.BI -P " path_name"
.SH DESCRIPTION
.B tplblinfo
prints on standard output the main characteristics of a tape file
as an option string.
If the tape is labelled, values are taken from the header labels;
if not, only the file sequence number is available.
.SH OPTIONS
.TP
.BI \-b
Prints the tape block size preceded by the option letter
.B \-b.
.TP
.BI \-F
Prints the tape record format preceded by the option letter
.B \-F.
.TP
.BI \-f
Prints the tape file identifier preceded by the option letter
.B \-f.
.TP
.BI \-L
Prints the tape record length preceded by the option letter
.B \-L.
.TP
.BI \-P " pathname"
Specifies the pathname relative to the current directory or the full pathname
which is used by the application program in the OPEN statement.
.TP
.BI \-q
Prints the file sequence number preceded by the option letter
.B \-q.
.TP
If no option is specified, all known values are printed.
.SH EXAMPLES
.nf
	tpmnt -P test -v AB1234
	tplblinfo -P test
would report
	-b 32760 -F U -f TSTDATA -L 32760 -q 1
while
	tplblinfo -F -b -P test
would give
	-b 32760 -F U
.fi
.SH RETURN CODES
\ 
.br
0	Ok, tape is al or sl.
.br
1	Ok, tape is nl or blp is selected.
.br
2	No such file.
.br
203	Bad parameter.
.SH SEE ALSO
.BR gethdrinfo
