.\" @(#)tplabel.man	1.7	12/20/96 CERN CN-SW/CU Jean-Philippe Baud
.\" Copyright (C) 1990-1996 by CERN/CN/SW/CU
.\" All rights reserved
.\"
.TH TPLABEL l "12/20/96"
.SH NAME
tplabel \- initialize a new blank tape
.SH SYNOPSIS
.B tplabel
[
.BI -D " device_name"
] [
.BI -d " density"
] [
.BI -g " device_group_name"
] [
.BI -H " number_headers"
] [
.BI -l " label_type"
] [
.BI -v " volume_serial_number[=visual_identifier]"
]
.SH DESCRIPTION
.B tplabel
checks with TMS if the tape is available and if the user
has write permission. It asks the operator to mount it on a unit
selected by the tape daemon with ring in. When the tape is ready,
rewinds it and writes VOL1 and HDR1 label records followed by two
tape marks for labelled tapes or only two tape marks for unlabelled
tapes.
.SH OPTIONS
.TP
.BI \-D " devname"
Explicit device name.
.TP
.BI \-d " density"
.B 1600
or
.B 6250
for round (IBM 3420) tapes,
.B 38000
for standard IBM 3480 cartridges,
.B 38KC
for 3480 cartridges with compaction (IDRC),
.B 38KD
for double density IBM 3490 cartridges,
.B 38KDC
for 3490 cartridges with compaction (IDRC),
.BR 8200 ,
.B 8500
or
.B 8500C
for Exabytes,
.B DDS
or
.B DDSC
for DAT cartridges,
.BR 2G ,
.BR 6G ,
.BR 10G ,
.BR 10GC ,
.BR 20G ,
.BR 20GC ,
.B 35G
or
.B 35GC
for DLT cartridges,
.B 10G
or
.B 10GC
for IBM 3590 cartridges,
.BR 10G ,
.BR 10GC ,
.BR 25G ,
.BR 25GC ,
.B 50G
or
.B 50GC
for Redwood cartridges.
.TP
.BI \-g " dgn"
Requests a device from an installation defined set of "device groups".
It must match the device group specified in TMS (if installed).
Default is CART.
.TP
.BI \-H " number_headers"
Defines the number of headers included in the prelabel: if
.BR 0 ,
only a VOL1 record is written; if
.BR 1 ,
VOL1 and HDR1 are written (this is the default); if
.BR 2 ,
VOL1, HDR1 and HDR2 are written to tape.
.TP
.BI \-l " lab_type"
Label type:
.BR al ,
.BR nl ,
.B sl
or
.BR blp .
It must match the label type specified in TMS.  blp is allowed only for read.
Default is sl.
.TP
.BI \-v " vsn[=vid]"
Specifies the volume serial number of the tape and optionally the visual
identifier. They must be six characters long (maximum) and are converted
to upper case. The vsn must match the one specified in TMS.

VOL1 record structure:

1:4	"VOL1"
.br
5:10	vsn (maximum 6 characters in upper case).
.br
42:51	Owner (login name) for SL tapes.

HDR1 record structure:

1:4	"HDR1"
.br
5:12	"PRELABEL"
.br
28:31	0001 (volume sequence number)
.br
32:35	0001 (file sequence number)
.br
43:47	today's date in Julian form (creation date)
.br
49:53	today's date in Julian form (expiration date)
.br
55:60	000000 (block count)
.br
61:73	system name ("SUN", "SGI/IRIX", "DEC3100")

.SH RETURN CODES
\ 
.br
0	Ok.
.br
5	I/O error.
.br
6	Unit not operational.
.br
13	Operator cancel, access denied by TMS.
.br
200	Tape daemon is not running.
.br
201	System or communication error.
.br
203	Bad parameter.
.br
206	Too many units requested.
.br
207	Invalid device group name.
.br
208	Reserv not done.
.br
209	No unit with requested characteristics.
.br
212	Interrupted by user.
