/*
 * Copyright (C) 1995-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpinfo.c	1.7 03/28/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tpinfo - tape information display */
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
int jid;
struct tpinfo req;
struct tpinfor rep;

main(argc, argv)
int	argc;
char	**argv;
{
	int c, n;
	int errflg = 0;
	char *getcwd();
	char *p;

	jid = findpgrp();
	req.rh.size = sizeof(struct tpinfo);
	req.rh.code = TPINFO;
	while ((c = getopt (argc, argv, "P:")) != EOF) {
		switch (c) {
		case 'P':
			if (req.path[0] == '\0') {
				if (*optarg != '/') {
					if (getcwd (req.path, sizeof(req.path) - 3) == NULL) {
						fprintf (stderr,
						    "TP002 -  : getcwd error : %d\n", errno);
						errflg++;
					}
					strcat (req.path, "/");
				}
				if (strlen(req.path) + strlen(optarg) < sizeof(req.path)) {
					strcat (req.path, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (req.path[0] == '\0') {
		fprintf (stderr, TP029);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}
	c = send2tpd (&req, &rep, &n);
	switch (c) {
	case 0:
		if (rep.blksize)
			printf ("-b %d ", rep.blksize);
		if (rep.recfm[0])
			printf ("-F %s ", rep.recfm);
		if (rep.fid[0])
			printf ("-f %s ", rep.fid);
		if (rep.lrecl)
			printf ("-L %d ", rep.lrecl);
		if (p = strstr (rep.devtype, "/VB")) *p= '\0';
		printf ("-q %d -D %s -T %s", rep.cfseq, rep.unm, rep.devtype);
		if (rep.den)
			printf (" -d %s\n", den2aden (rep.den));
		else
			printf ("\n");
		break;
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	default:
		if (n) fprintf (stderr, "%s\n", (char *) &rep);
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s",
		"-P path_name\n");
}

