/*
 * Copyright (C) 1994 by CERN/CN/PDP/DH
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tapeacct.c	1.4 11/07/94 CERN CN-PDP/DH Jean-Philippe Baud";
#endif /* not lint */

#include <stdio.h>
#include <sys/types.h>
#include "../h/sacct.h"
struct mountrsn {
	char *text;
	int code;
};

struct mountrsn mountrsn[] = {
	"", 		   TPM_NORM,
	"wrong ring status",	TPM_WNGR,
	"wrong vsn", 	   TPM_WNGV,
	"reselect", 	   TPM_RSLT,
	"reselect same",   TPM_RSLT,
	"reselect failed", TPM_RSLT
};

tapeacct(subtype, uid, gid, jid, nqsid, dgn, unm, vid, fseq, reason)
int subtype;
uid_t uid;
gid_t gid;
int jid;
char *nqsid;
char *dgn;
char *unm;
char *vid;
int fseq;
char *reason;
{
	struct accttape accttape;
	char *getconfent();
	char *p;
	int r;

	if ((p = getconfent("ACCT", "TAPE", 0)) == NULL ||
	    (strcmp (p, "YES") && strcmp (p, "yes"))) return;
	memset ((char *) &accttape, 0, sizeof(struct accttape));
	accttape.subtype = subtype;
	accttape.uid = uid;
	accttape.gid = gid;
	accttape.jid = jid;
	strcpy (accttape.nqsid, nqsid);
	strcpy (accttape.dgn, dgn);
	strcpy (accttape.unm, unm);
	strcpy (accttape.vid, vid);
	accttape.fseq = fseq;
	for (r = 0; r < 6; r++)
		if (strcmp (reason, mountrsn[r].text) == 0) break;
	accttape.reason = mountrsn[r].code;

	wsacct (ACCTTAPE, &accttape, sizeof(struct accttape));
}
