/*
 * Copyright (C) 1995-1999 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sonysubr.c	1.6 11/11/99 CERN CN-PDP/DS Jean-Philippe Baud";
#endif /* not lint */

/*	sonysubr - sends scsi commands to support RAW mode on SONY DIR1000
	using a DFC-1500/1700 controller */
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include "../h/scsictl.h"
#include "tape.h"
#if !defined(linux)
extern char *sys_errlist[];
#endif
chkunitready_sony(tapefd)
int tapefd;
{
	unsigned char cdb[6];
	char func[16];
	char *msgaddr;
	int nb_sense_ret;
	int rc;
	char sense[MAXSENSE];

	strcpy (func, "chkunitready");
	memset (cdb, 0, sizeof(cdb));
	rc = send_scsi_cmd (tapefd, "", 1, cdb, 6, NULL, 0,
		sense, 38, 30000, SCSI_NONE, &nb_sense_ret, &msgaddr);
	if (rc == -1 || rc == -2) {
		tplogit (func, "%s", msgaddr);
		return (-errno);	/* error */
	}
	if (rc < 0)
		return (0);	/* unit not ready */
	else
		return (1);	/* unit ready */
}

chkringstatus_sony(tapefd)
int tapefd;
{
	unsigned char cdb[6];
	char func[16];
	char *msgaddr;
	int nb_sense_ret;
	int rc;
	char sense[MAXSENSE];

	strcpy (func, "chkringstatus");
	memset (cdb, 0, sizeof(cdb));
	cdb[0] = 0x03;		/* request sense */
	cdb[4] = 38;
	rc = send_scsi_cmd (tapefd, "", 1, cdb, 6, sense, 38,
		NULL, 0, 30000, SCSI_IN, &nb_sense_ret, &msgaddr);
	if (rc < 0) {
		tplogit (func, "%s", msgaddr);
		if (rc == -1 || rc == -2)
			return (-errno);
		else
			return (-EIO);	/* error */
	}
	if (sense[18] & 0x2)
		return (0);     /* ring out */
	else
		return (1);     /* ring in */
}

erase_sony(tapefd, path)
int tapefd;
char *path;
{
	unsigned char cdb[6];
	char func[16];
	char *msgaddr;
	int nb_sense_ret;
	int rc;
	char sense[MAXSENSE];

	ENTRY (erase);
	memset (cdb, 0, sizeof(cdb));
	cdb[0] = 0x19;		/* erase */
	rc = send_scsi_cmd (tapefd, path, 1, cdb, 6, NULL, 0,
		sense, 38, 90000, SCSI_NONE, &nb_sense_ret, &msgaddr);
	if (rc < 0) {
		usrmsg (func, "%s", msgaddr);
		if (rc == -1 || rc == -2) {
			RETURN (-errno);
		} else {
			RETURN (-EIO);	/* error */
		}
	}
	RETURN (0);
}

locate_sony(tapefd, path, tracksetid)
int tapefd;
char *path;
int tracksetid;
{
	unsigned char cdb[10];
	char func[16];
	char *msgaddr;
	int nb_sense_ret;
	int rc;
	char sense[MAXSENSE];

	ENTRY (locate);
	memset (cdb, 0, sizeof(cdb));
	cdb[0] = 0x2B;		/* locate */
	cdb[3] = tracksetid >> 24;
	cdb[4] = (tracksetid >> 16) & 0xFF;
	cdb[5] = (tracksetid >> 8) & 0xFF;
	cdb[6] = tracksetid & 0xFF;
	rc = send_scsi_cmd (tapefd, path, 1, cdb, 10, NULL, 0,
		sense, 38, 360000, SCSI_NONE, &nb_sense_ret, &msgaddr);
	if (rc < 0) {
		usrmsg (func, "%s", msgaddr);
		if (rc == -1 || rc == -2) {
			RETURN (-errno);
		} else {
			RETURN (-EIO);	/* error */
		}
	}
	RETURN (0);
}

unldtape_sony(tapefd, path)
int tapefd;
char *path;
{
	unsigned char cdb[6];
	char func[16];
	char *msgaddr;
	int nb_sense_ret;
	int rc;
	char sense[MAXSENSE];

	ENTRY (unldtape);
	if (tapefd < 0) RETURN (0);
	memset (cdb, 0, sizeof(cdb));
	cdb[0] = 0x1B;		/* unload */
	rc = send_scsi_cmd (tapefd, path, 1, cdb, 6, NULL, 0,
		sense, 38, 300000, SCSI_NONE, &nb_sense_ret, &msgaddr);
	if (rc < 0) {
		usrmsg (func, "%s", msgaddr);
		if (rc == -1 || rc == -2) {
			RETURN (-errno);
		} else {
			RETURN (-EIO);	/* error */
		}
	}
	RETURN (0);
}
