.\" @(#)smc.man	1.1 03/12/98 CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1998 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH SMC l "03/12/98"
.SH NAME
smc \- command line interface to drive robotic devices through SCSI
.SH SYNOPSIS
.B smc
.BI -d
.BI -D " drive_ordinal"
.BI -l " loader"
[
.BI -V " vid"
] [
.BI -v
]
.br
.B smc
.BI -e
.BI -l " loader"
.BI -V " vid"
[
.BI -v
]
.br
.B smc
.BI -i
.BI -l " loader"
[
.BI -V " vid"
] [
.BI -v
]
.br
.B smc
.BI -m
.BI -D " drive_ordinal"
.BI -l " loader"
.BI -V " vid"
[
.BI -v
]
.br
.B smc
.BI -l " loader"
.B -q D
[
.BI -D " drive_ordinal"
]
[
.BI -v
]
.br
.B smc
.BI -l " loader"
.B -q L
[
.BI -v
]
.br
.B smc
.BI -l " loader"
.B -q P
[
.BI -v
]
.br
.B smc
.BI -l " loader"
.B -q S
[
.BI -N " nbelem"
] [
.BI -S " starting_slot"
] [
.BI -v
]
.br
.B smc
.BI -l " loader"
.B -q V
[
.BI -V " vid"
] [
.BI -v
]
.SH DESCRIPTION
.B smc
is a program allowing to mount, dismount, export volumes in a robotic
library through SCSI. It allows also to query various elements of the library.
.SH OPTIONS
.TP
.BI \-d
triggers a dismount operation. The drive must be already unloaded.
The drive must be specified while the vid of the cartridge is optional.
If
.B -V
is specified, the vid must match the vid on the cartridge to be dismounted.
.TP
.BI \-e
exports a volume. The cartridge must be in a storage slot (not a drive).
The vid must be specified.
.TP
.BI \-i
imports either a specific volume indicated by
.B -V
option or all volumes in state "import" in the import/export cells.
.TP
.BI \-l " loader"
specifies the picker SCSI device. This parameter is mandatory.
.TP
.BI \-m
triggers a mount operation. The drive must be free.
The drive and the vid must be specified.
.TP
.BI \-N " nbelem"
allows to specify the maximum number of entries to be reported.
.TP
.BI \-q " query_type"
queries the library and produce a report about the status of various elements
in the library.
.I query_type
may be one of the following:
.RS
.TP
.B D
produce a list of drives with their status and the vid of the mounted tape
if any. Unless a specific drive is also given with the option
.BR -D ,
the status of all drives is reported.
.TP
.B L
prints the result of the INQUIRY command (Vendor/Product/Revision).
It gives also the starting address and the number of slots, drives, ports
and transports (hands) in the library.
.TP
.B P
prints the status of import/export slots.
.TP
.B S
prints the status of slots. By default all slots are reported, but the
starting address may be specified with the option
.B -S
and the number of elements to be reported may be given by the option
.BR -N .
.TP
.B V
prints the status of volumes. A single vid or a pattern may also be specified
with the option
.BR -V .
.RE
.TP
.B \-S " starting_slot"
specifies the starting slot address for the query operation.
.TP
.B \-V " vid"
A full vid or a pattern may be specified. In the latter case wild card
characters '*' and '?' may be used but must be escaped because of the shell.
.TP
.B \-v
verbose mode. On query requests it prints headers on top of the columns.

.SH EXAMPLES
.LP
To mount the volume JK2005 on drive 1:
.br
.RS
.B "smc -l /dev/smc01 -m -D 1 -V JK2005"
.RE
.LP
To dismount the volume present on drive 1 after checking the vid:
.br
.RS
.B "smc -l /dev/smc01 -d -D 1 -V JK2005"
.RE
.LP
To query the main charateristics of the library:
.br
.RS
.B "smc -l /dev/smc01 -q L"
.sp
.nf
Vendor/Product/Revision = <STK     9714            1500>
Transport Count = 1, Start = 1000
Slot Count = 99, Start = 0
Port Count = 1, Start = 1010
Device Count = 2, Start = 1030
.fi
.RE
.LP
To query the status of all the drives:
.br
.RS
.B "smc -l /dev/smc01 -q D -v"
.sp
.nf
.cs R 20
Drive Ordinal   Element Addr.   Status          Vid
         0          1030        free
         1          1031        unloaded        JK2005
.cs R
.fi
.RE
.LP
To get the list of a few slots in the library:
.br
.RS
.B "smc -l /dev/smc01 -q S -S 20 -N 10 -v"
.sp
.nf
.cs R 20
Element Addr.   Vid
      20        JK2021
      21        JK2022
      22        JK2023
      23        JK2024
      24        JK2025
      25        JK2026
      26        JK2027
      27        JK2028
      28        JK2029
      29        JK2030
.cs R
.fi
.RE
.LP
To get the status of volumes for which the vid starts with JK200
.br
.RS
.B "smc -l /dev/smc01 -q V -V 'JK200*' -v"
.sp
.nf
.cs R 20
Vid     Element Addr.   Element Type
JK2001         0        slot
JK2002         1        slot
JK2003         2        slot
JK2004         3        slot
JK2006         5        slot
JK2007         6        slot
JK2008         7        slot
JK2009         8        slot
JK2005      1031        drive
.cs R
.fi
.RE
.SH RETURN CODES
0	Ok.
.br
1	Parameter error or unrecoverable error (just log it).
.br
2	Should release drive & retry in 600 seconds.
.br
3	Should retry in 60 seconds.
.br
4	Should do first a demount force.
.br
5	Should configure the drive down.
.br
6	Should send a msg to operator and exit.
.br
7	Ops msg (nowait) + release drive + slow retry.
.br
8	Should send a msg to operator and wait.
.br
9	Should unload the tape and retry demount.
